/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.forge.fileuploadclient;

import com.tridium.cloud.util.HttpStatusException;
import com.tridium.cloud.util.HttpUtils;
import com.tridium.cloud.util.StandardHttpUtils;
import com.tridium.forge.cloud.platform.IotHubConnectionPropertyNames;
import com.tridium.forge.fileuploadclient.FileConfig;
import com.tridium.forge.fileuploadclient.FileConfigV2;
import com.tridium.forge.fileuploadclient.FileUploadStatus;
import com.tridium.forge.fileuploadclient.IFileUploadStatusHandler;
import com.tridium.forge.fileuploadclient.IUploadHandler;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUploader<T> {
    private final IUploadHandler uploadHandler;
    private final Logger logger;
    private final Callable<IFileUploadStatusHandler> uploadStatusHandler;
    private final HttpUtils httpUtils;
    private static final double maxBlockSizeToUploadInTb = 4.75;
    private static final int BYTES_IN_KB = 1024;
    public static final String FILE_UPLOAD_URL_JSON_KEY = "FileUploadSasUrl";

    public FileUploader(IUploadHandler uploadHandler, Logger logger, Callable<IFileUploadStatusHandler> uploadStatusHandler) {
        this.uploadHandler = uploadHandler;
        this.logger = logger;
        this.uploadStatusHandler = uploadStatusHandler;
        this.httpUtils = StandardHttpUtils.getInstance();
    }

    public FutureTask<Object> uploadFileToConnection(T config, Map<String, String> connectionDetails) {
        FutureTask<Object> uploaderTask;
        Object resultObject = new Object();
        try {
            if (!this.isFileValid((FileConfig)config)) {
                this.logger.log(Level.SEVERE, String.format(Locale.getDefault(), "%s is not available or Size is greater than the Maximum Blob Size", ((FileConfig)config).getFileDisplayName()));
                this.notifyUploadStatusHandler((FileConfig)config, FileUploadStatus.FILE_UPLOAD_ERROR);
                return null;
            }
            UploadWorkerThread worker = new UploadWorkerThread(this.uploadStatusHandler, connectionDetails, config);
            uploaderTask = new FutureTask<Object>(worker, resultObject);
            ExecutorService exec = Executors.newSingleThreadExecutor();
            exec.execute(uploaderTask);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Error checking the validity of the file to be uploaded", e);
            return null;
        }
        return uploaderTask;
    }

    protected String getFileUploadSasUrl(Map<String, String> connectionDetails, T config) {
        StringBuilder requestBody;
        String fileUploadUrl;
        this.logger.info("Obtaining file upload SAS URL");
        String fileUploadBaseUrl = connectionDetails.get(IotHubConnectionPropertyNames.getBasePath());
        String fileUploadJwtToken = connectionDetails.get(IotHubConnectionPropertyNames.getPassword());
        String systemGuid = connectionDetails.get(IotHubConnectionPropertyNames.getUserName());
        if (fileUploadBaseUrl == null || fileUploadJwtToken == null || systemGuid == null) {
            this.logger.log(Level.INFO, "Invalid File Upload Connection Details!! Provisioning Failed.");
            this.notifyUploadStatusHandler((FileConfig)config, FileUploadStatus.FILE_UPLOAD_ERROR);
            return null;
        }
        String fileUploadResourceUrl = "api/fileupload/systems/";
        if (config instanceof FileConfigV2) {
            fileUploadUrl = String.format(Locale.getDefault(), "%s%s%s/v2/request", fileUploadBaseUrl, fileUploadResourceUrl, systemGuid);
            JSONArray dataTags = new JSONArray();
            for (String tags : ((FileConfigV2)config).getDataClassificationTags()) {
                dataTags.put((Object)tags);
            }
            requestBody = new StringBuilder("{\"FileName\":\"");
            requestBody.append(((FileConfigV2)config).getFileName().replace('\\', '/'));
            requestBody.append("\",\"DataClassificationTags\":");
            requestBody.append(dataTags);
            requestBody.append(",\"MimeType\":\"");
            requestBody.append("text/html");
            requestBody.append("\"}");
        } else {
            fileUploadUrl = String.format(Locale.getDefault(), "%s%s%s/request", fileUploadBaseUrl, fileUploadResourceUrl, systemGuid);
            requestBody = new StringBuilder("{\"FileName\":\"");
            requestBody.append(((FileConfig)config).getFileName().replace('\\', '/'));
            requestBody.append("\",\"MimeType\":\"");
            requestBody.append("text/html");
            requestBody.append("\"}");
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(String.format("fileUploadUrl: %s, requestBody: %s", fileUploadUrl, requestBody));
        }
        try {
            JSONObject uploadUrlResp = this.sendHttpPostRequest(fileUploadUrl, requestBody.toString(), fileUploadJwtToken);
            this.logger.log(Level.INFO, "upload URL response:\n" + uploadUrlResp);
            return uploadUrlResp.getString(FILE_UPLOAD_URL_JSON_KEY);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed getting the File Upload SAS Url");
            this.logger.log(Level.SEVERE, String.format(Locale.getDefault(), "Error getting File Upload SAS url %s", e));
            this.notifyUploadStatusHandler((FileConfig)config, FileUploadStatus.FILE_UPLOAD_ERROR);
            return null;
        }
    }

    private JSONObject sendHttpPostRequest(String url, String json, String authToken) throws IOException, HttpStatusException {
        return (JSONObject)this.httpUtils.post(url, "application/json; charset=utf-8", HttpUtils.makeAuthHeaderMap((String)authToken), -1L, Optional.of(HttpUtils.fromStringToOutputStreamFunc((Object)json)), Optional.of(HttpUtils::fromInputStreamToJsonObject), Optional.empty());
    }

    public boolean isFileValid(FileConfig fileInfo) throws IOException {
        File file = new File(fileInfo.getFileName());
        if (!file.exists()) {
            this.logger.log(Level.SEVERE, String.format(Locale.getDefault(), "%s not found", fileInfo.getFileName()));
            return false;
        }
        double bytes = file.length();
        long size = Double.valueOf(bytes).longValue();
        return size <= Double.valueOf(4.75).longValue() * 1024L * 1024L * 1024L * 1024L;
    }

    void notifyUploadStatusHandler(FileConfig config, FileUploadStatus status) {
        try {
            this.uploadStatusHandler.call().notifyUploadStatus(config, status);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error notifying File Upload Complete event", e);
        }
    }

    private class UploadWorkerThread
    implements Runnable {
        private final Callable<IFileUploadStatusHandler> uploadStatusHandler;
        private final Map<String, String> connectionDetails;
        private final T fileConfig;

        UploadWorkerThread(Callable<IFileUploadStatusHandler> handlerCallable, Map<String, String> connectionDetails, T config) {
            this.uploadStatusHandler = handlerCallable;
            this.connectionDetails = connectionDetails;
            this.fileConfig = config;
        }

        @Override
        public void run() {
            FileUploader.this.logger.info("Running file upload worker thread");
            String fileUploadSasUrl = FileUploader.this.getFileUploadSasUrl(this.connectionDetails, this.fileConfig);
            if (fileUploadSasUrl != null) {
                try {
                    this.uploadStatusHandler.call().notifyUploadStatus((FileConfig)this.fileConfig, FileUploadStatus.FILE_UPLOAD_STARTED);
                }
                catch (Exception e) {
                    FileUploader.this.logger.log(Level.SEVERE, "Error notifying the file upload start event", e);
                }
                this.uploadFile(fileUploadSasUrl, (FileConfig)this.fileConfig, this.connectionDetails);
            }
        }

        private void uploadFile(String fileUploadSasUrl, FileConfig fileConfig, Map<String, String> connectionDetails) {
            FileUploader.this.logger.log(Level.INFO, "Uploading file...");
            try {
                boolean uploadStatus = FileUploader.this.uploadHandler.uploadDataToBlob(fileConfig, fileUploadSasUrl, connectionDetails);
                if (!uploadStatus) {
                    FileUploader.this.notifyUploadStatusHandler(fileConfig, FileUploadStatus.FILE_UPLOAD_ERROR);
                } else {
                    FileUploader.this.notifyUploadStatusHandler(fileConfig, FileUploadStatus.FILE_UPLOAD_COMPLETE);
                }
            }
            catch (Exception e) {
                try {
                    FileUploader.this.logger.log(Level.SEVERE, "Error in uploading the file", e);
                    this.uploadStatusHandler.call().notifyUploadStatus(fileConfig, FileUploadStatus.FILE_UPLOAD_ERROR);
                }
                catch (Exception e1) {
                    FileUploader.this.logger.log(Level.SEVERE, "Error notifying the file upload error event", e1);
                }
            }
        }
    }
}

