/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSync.service;

import com.tridium.fcModelSync.command.BUpdateModelIdCommand;
import com.tridium.fcModelSync.command.BUpdateModelSyncStatusCommand;
import com.tridium.fcModelSync.enums.BUnitSystem;
import com.tridium.fcModelSync.extractor.BContextDiscoveryModelExtractor;
import com.tridium.fcModelSync.job.BModelDiscoveryJob;
import com.tridium.fcModelSync.job.BModelSyncJob;
import com.tridium.fcModelSync.writer.BModelWriterImpl;
import com.tridium.nc.cmds.BCloudCommands;
import com.tridium.nc.cmds.BCloudCommandsDeviceExt;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="siteName", type="String", defaultValue=""), @NiagaraProperty(name="contextDiscoveryRequired", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="unit", type="BUnitSystem", defaultValue="BUnitSystem.DEFAULT", flags=1), @NiagaraProperty(name="modelCacheRequired", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="fastStoreRetentionPolicyInDays", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="modelExtractor", type="BContextDiscoveryModelExtractor", defaultValue="new BContextDiscoveryModelExtractor()"), @NiagaraProperty(name="modelWriter", type="BModelWriterImpl", defaultValue="new BModelWriterImpl()", flags=4), @NiagaraProperty(name="modelSyncStatus", type="String", defaultValue="", flags=1), @NiagaraProperty(name="modelId", type="String", defaultValue="", flags=1), @NiagaraProperty(name="statusUpdatedTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="deleteFilesAfterSync", type="boolean", defaultValue="true"), @NiagaraProperty(name="useDriverDiscoveryJobs", type="boolean", defaultValue="false", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="syncModel"), @NiagaraAction(name="updateUploadStatus", parameterType="BString", defaultValue="BString.make(\"\")", flags=4), @NiagaraAction(name="updateModelId", parameterType="BString", defaultValue="BString.make(\"\")", flags=4), @NiagaraAction(name="discoverModelInfo")})
public class BModelSyncService
extends BAbstractService {
    public static final Property siteName = BModelSyncService.newProperty((int)0, (String)"", null);
    public static final Property contextDiscoveryRequired = BModelSyncService.newProperty((int)5, (boolean)false, null);
    public static final Property unit = BModelSyncService.newProperty((int)1, (BValue)BUnitSystem.DEFAULT, null);
    public static final Property modelCacheRequired = BModelSyncService.newProperty((int)4, (boolean)false, null);
    public static final Property fastStoreRetentionPolicyInDays = BModelSyncService.newProperty((int)4, (int)0, null);
    public static final Property modelExtractor = BModelSyncService.newProperty((int)0, (BValue)new BContextDiscoveryModelExtractor(), null);
    public static final Property modelWriter = BModelSyncService.newProperty((int)4, (BValue)new BModelWriterImpl(), null);
    public static final Property modelSyncStatus = BModelSyncService.newProperty((int)1, (String)"", null);
    public static final Property modelId = BModelSyncService.newProperty((int)1, (String)"", null);
    public static final Property statusUpdatedTime = BModelSyncService.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property deleteFilesAfterSync = BModelSyncService.newProperty((int)0, (boolean)true, null);
    public static final Property useDriverDiscoveryJobs = BModelSyncService.newProperty((int)4, (boolean)false, null);
    public static final Action syncModel = BModelSyncService.newAction((int)0, null);
    public static final Action updateUploadStatus = BModelSyncService.newAction((int)4, (BValue)BString.make((String)""), null);
    public static final Action updateModelId = BModelSyncService.newAction((int)4, (BValue)BString.make((String)""), null);
    public static final Action discoverModelInfo = BModelSyncService.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BModelSyncService.class);
    private static final Logger log = Logger.getLogger("modelSync.sentience.service");

    public String getSiteName() {
        return this.getString(siteName);
    }

    public void setSiteName(String v) {
        this.setString(siteName, v, null);
    }

    public boolean getContextDiscoveryRequired() {
        return this.getBoolean(contextDiscoveryRequired);
    }

    public void setContextDiscoveryRequired(boolean v) {
        this.setBoolean(contextDiscoveryRequired, v, null);
    }

    public BUnitSystem getUnit() {
        return (BUnitSystem)this.get(unit);
    }

    public void setUnit(BUnitSystem v) {
        this.set(unit, (BValue)v, null);
    }

    public boolean getModelCacheRequired() {
        return this.getBoolean(modelCacheRequired);
    }

    public void setModelCacheRequired(boolean v) {
        this.setBoolean(modelCacheRequired, v, null);
    }

    public int getFastStoreRetentionPolicyInDays() {
        return this.getInt(fastStoreRetentionPolicyInDays);
    }

    public void setFastStoreRetentionPolicyInDays(int v) {
        this.setInt(fastStoreRetentionPolicyInDays, v, null);
    }

    public BContextDiscoveryModelExtractor getModelExtractor() {
        return (BContextDiscoveryModelExtractor)this.get(modelExtractor);
    }

    public void setModelExtractor(BContextDiscoveryModelExtractor v) {
        this.set(modelExtractor, (BValue)v, null);
    }

    public BModelWriterImpl getModelWriter() {
        return (BModelWriterImpl)this.get(modelWriter);
    }

    public void setModelWriter(BModelWriterImpl v) {
        this.set(modelWriter, (BValue)v, null);
    }

    public String getModelSyncStatus() {
        return this.getString(modelSyncStatus);
    }

    public void setModelSyncStatus(String v) {
        this.setString(modelSyncStatus, v, null);
    }

    public String getModelId() {
        return this.getString(modelId);
    }

    public void setModelId(String v) {
        this.setString(modelId, v, null);
    }

    public BAbsTime getStatusUpdatedTime() {
        return (BAbsTime)this.get(statusUpdatedTime);
    }

    public void setStatusUpdatedTime(BAbsTime v) {
        this.set(statusUpdatedTime, (BValue)v, null);
    }

    public boolean getDeleteFilesAfterSync() {
        return this.getBoolean(deleteFilesAfterSync);
    }

    public void setDeleteFilesAfterSync(boolean v) {
        this.setBoolean(deleteFilesAfterSync, v, null);
    }

    public boolean getUseDriverDiscoveryJobs() {
        return this.getBoolean(useDriverDiscoveryJobs);
    }

    public void setUseDriverDiscoveryJobs(boolean v) {
        this.setBoolean(useDriverDiscoveryJobs, v, null);
    }

    public void syncModel() {
        this.invoke(syncModel, null, null);
    }

    public void updateUploadStatus(BString parameter) {
        this.invoke(updateUploadStatus, (BValue)parameter, null);
    }

    public void updateModelId(BString parameter) {
        this.invoke(updateModelId, (BValue)parameter, null);
    }

    public void discoverModelInfo() {
        this.invoke(discoverModelInfo, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void started() throws Exception {
        super.started();
        this.setContextDiscoveryRequired(true);
    }

    private void addModelSyncCommands() {
        try {
            BCloudSentienceDevice cloudDevice = this.getModelExtractor().getCloudDevice();
            if (null != cloudDevice) {
                BCloudCommandsDeviceExt bCloudCommandsDeviceExt = cloudDevice.getCommands();
                BCloudCommands commands = bCloudCommandsDeviceExt.getCloudCommands();
                if (((BUpdateModelIdCommand[])commands.getChildren(BUpdateModelIdCommand.class)).length == 0) {
                    BUpdateModelIdCommand cmd1 = new BUpdateModelIdCommand();
                    commands.add("UpdateModelIdCommand", (BValue)new BUpdateModelIdCommand());
                    cmd1.setEnabled(true);
                }
                if (((BUpdateModelSyncStatusCommand[])commands.getChildren(BUpdateModelSyncStatusCommand.class)).length == 0) {
                    BUpdateModelSyncStatusCommand cmd2 = new BUpdateModelSyncStatusCommand();
                    commands.add("UpdateModelSyncStatusCommand", (BValue)cmd2);
                    cmd2.setEnabled(true);
                }
                log.finer("added model sync status update command");
            }
        }
        catch (UnresolvedException exp) {
            log.log(Level.SEVERE, "Unable to resolve cloud commands to add the upload status commands", exp.getCause());
        }
    }

    public void doSyncModel() {
        try {
            if (!this.getModelExtractor().deviceIsHealthy()) {
                throw new BajaRuntimeException("Cloud connector sentience device is down.");
            }
            if (!this.getModelWriter().connectorIsHealthy()) {
                throw new BajaRuntimeException("Cloud connector not active.");
            }
        }
        catch (NullPointerException exp) {
            throw new BajaRuntimeException("Cloud connector not configured.");
        }
        this.addModelSyncCommands();
        BModelSyncJob syncJob = new BModelSyncJob(this);
        BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        jobService.submit((BJob)syncJob, null);
    }

    public void doUpdateUploadStatus(BString status) {
        this.setModelSyncStatus(status.getString());
        this.setStatusUpdatedTime(BAbsTime.now());
    }

    public void doUpdateModelId(BString modelId) {
        this.setModelId(modelId.getString());
        this.setStatusUpdatedTime(BAbsTime.now());
    }

    public void doDiscoverModelInfo() {
        BModelDiscoveryJob syncJob = new BModelDiscoveryJob(this);
        BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        jobService.submit((BJob)syncJob, null);
    }
}

