/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSync.job;

import com.tridium.fcModelSync.driver.BModelDiscoverer;
import com.tridium.fcModelSync.service.BModelSyncService;
import com.tridium.util.CompUtil;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.driver.BDevice;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BModelDiscoveryJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BModelDiscoveryJob.class);
    BModelSyncService service;
    JobLog modelSyncLog;

    public Type getType() {
        return TYPE;
    }

    public BModelDiscoveryJob() {
    }

    public BModelDiscoveryJob(BModelSyncService service) {
        this.service = service;
    }

    void setModelSyncLog(JobLog log) {
        this.modelSyncLog = log;
    }

    public JobLog log() {
        return this.modelSyncLog != null ? this.modelSyncLog : super.log();
    }

    public void run(Context cx) throws Exception {
        this.discoverModelInfo(cx);
    }

    public void discoverModelInfo(Context cx) {
        try {
            BDevice[] devices;
            for (BDevice device : devices = (BDevice[])CompUtil.getDescendants((BComponent)Sys.getStation(), BDevice.class)) {
                AgentList agents = device.getAgents().filter(AgentFilter.is((Type)BModelDiscoverer.TYPE));
                if (agents.size() > 0) {
                    AgentInfo info = agents.getDefault();
                    BModelDiscoverer discoverer = (BModelDiscoverer)info.getInstance().as(BModelDiscoverer.class);
                    try {
                        discoverer.discoverModelInfo(device, this.log());
                        this.log().success("Model Discovery completed for " + device.getName());
                    }
                    catch (Exception modelDiscoveryException) {
                        this.log().failed("Model Discovery failed for " + device.getName() + ": " + modelDiscoveryException, (Throwable)modelDiscoveryException);
                    }
                    continue;
                }
                this.log().message("No model discoverer found for device " + device.getName() + " [" + device.getTypeDisplayName(cx) + "]; skipping model discovery");
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                this.log().failed("Model Discovery failed: " + cause);
            } else {
                this.log().failed("Model Discovery failed: " + e.getMessage());
            }
            throw e;
        }
    }
}

