/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.niagaraProv;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.BAbstractMqttDriverNetwork;
import com.tridium.mqttClientDriver.authenticator.aws.BAwsJitpMqttAuthenticator;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.signing.fox.BFoxSigningRequester;
import java.security.AccessController;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDriverContainer;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="mqttDeviceName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="signingServiceStation", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="mqttBrokerEndpoint", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="certificatePassword", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="overwriteDeviceIfPresent", type="boolean", defaultValue="false"), @NiagaraProperty(name="createSiblingDeviceIfPresent", type="boolean", defaultValue="true"), @NiagaraProperty(name="signingServiceOnboardingComment", type="String", defaultValue="BString.make(DEFAULT_COMMENT)"), @NiagaraProperty(name="autoRequestDeviceCertificate", type="boolean", defaultValue="true")})
public class BInstallJitpDeviceJobStep
extends BDeviceJobStep {
    private static final String DEFAULT_COMMENT = Lexicon.make((String)"platCrypto").getText("signingRequester.defaultOnboardingComment");
    @Generated
    public static final Property mqttDeviceName = BInstallJitpDeviceJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property signingServiceStation = BInstallJitpDeviceJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property mqttBrokerEndpoint = BInstallJitpDeviceJobStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property certificatePassword = BInstallJitpDeviceJobStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property overwriteDeviceIfPresent = BInstallJitpDeviceJobStep.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property createSiblingDeviceIfPresent = BInstallJitpDeviceJobStep.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property signingServiceOnboardingComment = BInstallJitpDeviceJobStep.newProperty((int)0, (BValue)BString.make((String)DEFAULT_COMMENT), null);
    @Generated
    public static final Property autoRequestDeviceCertificate = BInstallJitpDeviceJobStep.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BInstallJitpDeviceJobStep.class);
    private static final String MQTT_NETWORK_NAME = "AbstractMqttDriverNetwork";
    private static final String AUTHENTICATOR_SLOT = "authenticator";
    private static final Lexicon LEX = Lexicon.make(BInstallJitpDeviceJobStep.class);
    private static final String LEX_MODULE = "awsUtils";
    private static final Logger LOG = Logger.getLogger("awsUtils.niagara.provisioning");

    @Generated
    public String getMqttDeviceName() {
        return this.getString(mqttDeviceName);
    }

    @Generated
    public void setMqttDeviceName(String v) {
        this.setString(mqttDeviceName, v, null);
    }

    @Generated
    public String getSigningServiceStation() {
        return this.getString(signingServiceStation);
    }

    @Generated
    public void setSigningServiceStation(String v) {
        this.setString(signingServiceStation, v, null);
    }

    @Generated
    public String getMqttBrokerEndpoint() {
        return this.getString(mqttBrokerEndpoint);
    }

    @Generated
    public void setMqttBrokerEndpoint(String v) {
        this.setString(mqttBrokerEndpoint, v, null);
    }

    @Generated
    public BPassword getCertificatePassword() {
        return (BPassword)this.get(certificatePassword);
    }

    @Generated
    public void setCertificatePassword(BPassword v) {
        this.set(certificatePassword, (BValue)v, null);
    }

    @Generated
    public boolean getOverwriteDeviceIfPresent() {
        return this.getBoolean(overwriteDeviceIfPresent);
    }

    @Generated
    public void setOverwriteDeviceIfPresent(boolean v) {
        this.setBoolean(overwriteDeviceIfPresent, v, null);
    }

    @Generated
    public boolean getCreateSiblingDeviceIfPresent() {
        return this.getBoolean(createSiblingDeviceIfPresent);
    }

    @Generated
    public void setCreateSiblingDeviceIfPresent(boolean v) {
        this.setBoolean(createSiblingDeviceIfPresent, v, null);
    }

    @Generated
    public String getSigningServiceOnboardingComment() {
        return this.getString(signingServiceOnboardingComment);
    }

    @Generated
    public void setSigningServiceOnboardingComment(String v) {
        this.setString(signingServiceOnboardingComment, v, null);
    }

    @Generated
    public boolean getAutoRequestDeviceCertificate() {
        return this.getBoolean(autoRequestDeviceCertificate);
    }

    @Generated
    public void setAutoRequestDeviceCertificate(boolean v) {
        this.setBoolean(autoRequestDeviceCertificate, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        this.validate();
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BInstallJitpDeviceJobStep.logFine(() -> String.format("Installing AWS MQTT device for station %s", device.getName()));
            BFoxSession session = util.getEngagedFoxSession();
            try {
                BStation remoteStation = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)session);
                this.performMqttInstall(remoteStation);
            }
            finally {
                util.disengageFoxSession();
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, LEX.getText("aws.niagaraProv.unexpectedError", new Object[]{device.getName()}), e);
            throw e;
        }
    }

    private void performMqttInstall(BStation remoteStation) {
        BAbstractMqttDriverNetwork network = BInstallJitpDeviceJobStep.getOrAddMqttNetwork(remoteStation);
        network.lease();
        BAbstractMqttDevice mqttDevice = new BAbstractMqttDevice();
        BAwsJitpMqttAuthenticator authenticator = new BAwsJitpMqttAuthenticator();
        BFoxSigningRequester foxSigningRequester = (BFoxSigningRequester)authenticator.getCertRequester();
        foxSigningRequester.setSigningServiceStation(this.getSigningServiceStation());
        authenticator.setAutoOnboard(this.getAutoRequestDeviceCertificate());
        authenticator.setBrokerEndpoint(this.getMqttBrokerEndpoint());
        authenticator.setAutoOnboardComment(this.getSigningServiceOnboardingComment());
        BPassword password = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.getCertificatePassword()).getValue()));
        authenticator.getCertificateAliasAndPassword().setPassword(password);
        mqttDevice.add(AUTHENTICATOR_SLOT, (BValue)authenticator);
        this.addDevice(network, mqttDevice);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addDevice(BAbstractMqttDriverNetwork network, BAbstractMqttDevice mqttDevice) {
        String deviceName = SlotPath.escape((String)this.getMqttDeviceName());
        BValue existingDev = network.get(deviceName);
        if (existingDev != null) {
            if (!this.getOverwriteDeviceIfPresent()) {
                if (!this.getCreateSiblingDeviceIfPresent()) throw new LocalizableRuntimeException(LEX_MODULE, "aws.niagaraProv.device.exists", new Object[]{deviceName});
                deviceName = deviceName + '?';
            } else {
                BInstallJitpDeviceJobStep.overwriteExistingDevice((BAbstractMqttDevice)existingDev.as(BAbstractMqttDevice.class), mqttDevice);
                return;
            }
        }
        network.add(deviceName, (BValue)mqttDevice);
    }

    private static void overwriteExistingDevice(BAbstractMqttDevice existingMqttDev, BAbstractMqttDevice mqttDevice) {
        existingMqttDev.lease(2);
        existingMqttDev.disconnect();
        BAwsJitpMqttAuthenticator existingAuth = (BAwsJitpMqttAuthenticator)existingMqttDev.getAuthenticator(true).as(BAwsJitpMqttAuthenticator.class);
        BAwsJitpMqttAuthenticator newAuth = (BAwsJitpMqttAuthenticator)mqttDevice.getAuthenticator(true).as(BAwsJitpMqttAuthenticator.class);
        String existingCertAlias = existingAuth.getCertificateAliasAndPassword().getAlias();
        existingAuth.copyFrom((BComplex)newAuth);
        existingAuth.setClientID("");
        existingAuth.getCertificateAliasAndPassword().setAlias(existingCertAlias);
        BFoxSigningRequester newRequester = new BFoxSigningRequester();
        newRequester.setSigningServiceStation(((BFoxSigningRequester)newAuth.getCertRequester().as(BFoxSigningRequester.class)).getSigningServiceStation());
        existingAuth.setCertRequester((BAbstractSigningRequester)newRequester);
        existingAuth.attemptAutoOnboard();
    }

    private static BAbstractMqttDriverNetwork getOrAddMqttNetwork(BStation remoteStation) {
        BDriverContainer driverContainer = (BDriverContainer)remoteStation.get("Drivers");
        if (driverContainer != null) {
            driverContainer.lease();
            BAbstractMqttDriverNetwork[] networks = (BAbstractMqttDriverNetwork[])driverContainer.getChildren(BAbstractMqttDriverNetwork.class);
            if (networks.length == 0) {
                BAbstractMqttDriverNetwork network = new BAbstractMqttDriverNetwork();
                driverContainer.add(MQTT_NETWORK_NAME, (BValue)network);
                return (BAbstractMqttDriverNetwork)driverContainer.get(MQTT_NETWORK_NAME);
            }
            return networks[0];
        }
        throw new LocalizableRuntimeException(LEX_MODULE, "aws.niagaraProv.no.drivers");
    }

    private void validate() {
        if (this.getMqttBrokerEndpoint().isEmpty()) {
            throw new LocalizableRuntimeException(LEX_MODULE, "aws.niagaraProv.no.endpoint");
        }
        if (this.getSigningServiceStation().isEmpty()) {
            throw new LocalizableRuntimeException(LEX_MODULE, "aws.niagaraProv.no.serviceStation");
        }
        if (this.getMqttDeviceName().isEmpty()) {
            throw new LocalizableRuntimeException(LEX_MODULE, "aws.niagaraProv.no.deviceName");
        }
    }

    private static void logFine(Supplier<String> message) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(message.get());
        }
    }
}

