/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.integration.model;

import com.tridiumx.integration.model.BVisitorDialog;
import com.tridiumx.integration.model.BVisitorInput;
import com.tridiumx.integration.model.BVisitorTable;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.TableController;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableController;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"visitorintegration:VisitorTable"})})
@NiagaraAction(name="newButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BVisitorTableFE
extends BWbFieldEditor {
    @Generated
    public static final Action newButtonPressed = BVisitorTableFE.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVisitorTableFE.class);
    private static final double DIVIDER_POSITION = 80.0;
    private BSplitPane editPane = new BSplitPane(BOrientation.vertical, 80.0);
    private Column visitorType = new Column("Visitor Type", BVisitorInput.visitorType);
    private Column accessRights = new Column("Access Right", BVisitorInput.accessRights);
    private Column wiegandFormat = new Column("Wiegand Format", BVisitorInput.wiegandFormat);
    private Column facilityCode = new Column("Facility Code", BVisitorInput.facilityCode);
    private final Column[] colNames = new Column[]{this.visitorType, this.accessRights, this.wiegandFormat, this.facilityCode};
    private BVisitorInputTable visitorInputTable = new BVisitorInputTable(new Controller(), new Model((ComponentTableModel.Column[])this.colNames));
    private BButton newButton = new BButton("New");
    private static final Lexicon lex = Lexicon.make(BVisitorTableFE.class);
    private BVisitorTable visitorTable;

    @Generated
    public void newButtonPressed(BWidgetEvent parameter) {
        this.invoke(newButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVisitorTableFE() {
        this.setContent((BWidget)this.editPane);
        this.editPane.setWidget1((BWidget)this.visitorInputTable);
        this.editPane.setWidget2((BWidget)this.newButton);
        this.linkTo("linkNewButton", (BComponent)this.newButton, (Slot)BButton.actionPerformed, (Slot)newButtonPressed);
    }

    public BVisitorInputTable getTable() {
        return this.visitorInputTable;
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.visitorInputTable.loadValue(value);
    }

    public void doNewButtonPressed(BWidgetEvent widgetEvent) {
        try {
            new BVisitorDialog(this.visitorInputTable, this.visitorTable).open();
        }
        catch (Exception e) {
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)e.getMessage(), (Throwable)e);
        }
    }

    public class BVisitorInputTable
    extends BComponentTable {
        public BVisitorInputTable(Controller controller, Model model) {
            super((ComponentTableModel)model);
            this.setController((TableController)controller);
            this.setCopyEnabled(false);
            this.setPasteEnabled(false);
            this.setDuplicateEnabled(false);
            this.setPasteSpecialEnabled(false);
            this.setColorRows(true);
        }

        private void loadValue(BObject value) {
            BVisitorInput[] visitorInputs;
            BVisitorTableFE.this.visitorTable = (BVisitorTable)value;
            ((Model)BVisitorTableFE.this.visitorInputTable.getModel()).removeAllRows();
            BVisitorTableFE.this.visitorInputTable.setContainer(BVisitorTableFE.this.visitorTable);
            for (BVisitorInput visitorInput : visitorInputs = (BVisitorInput[])BVisitorTableFE.this.visitorTable.getChildren(BVisitorInput.class)) {
                ((Model)this.getModel()).loadRow(visitorInput);
            }
            this.setupTableDimensions();
            BVisitorTableFE.this.visitorInputTable.repaint();
        }

        private void setupTableDimensions() {
            double headerHeight;
            int rowCount = this.getModel().getRowCount();
            double cellHeight = this.getCellRenderer().getCellHeight();
            double buttonHeight = headerHeight = this.getHeaderRenderer().getHeaderHeight();
            double tableHeight = headerHeight + cellHeight * (double)rowCount;
            double totalWidth = this.getWidth();
            BVisitorTableFE.this.editPane.setSize(totalWidth, tableHeight + buttonHeight);
            BVisitorTableFE.this.editPane.setDividerWidth(0.0);
            BVisitorTableFE.this.editPane.setDividerPosition(100.0 * (tableHeight / (tableHeight + buttonHeight)));
            this.setSize(totalWidth, tableHeight);
            BVisitorTableFE.this.newButton.setSize(totalWidth, buttonHeight);
        }

        public CommandArtifact doDelete() throws Exception {
            CommandArtifact commandArtifact = super.doDelete();
            this.loadValue((BObject)BVisitorTableFE.this.visitorTable);
            return commandArtifact;
        }
    }

    public class Controller
    extends ComponentTableController {
        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BVisitorInput visitorInput = (BVisitorInput)((Model)this.getModel()).getComponentAt(row);
            new BVisitorDialog(BVisitorTableFE.this.visitorInputTable, BVisitorTableFE.this.visitorTable, visitorInput).open();
        }
    }

    public static class Column
    extends ComponentTableModel.PropertyColumn {
        public Column(String name, Property prop) {
            super(name, prop);
        }

        private void save(BComponent oldComp, BComponent newComp, Context cx) {
            BValue newVal;
            BValue oldVal = oldComp.get(this.prop);
            if (!oldVal.equivalent((Object)(newVal = newComp.get(this.prop)))) {
                oldComp.set(this.prop, newVal.newCopy(), cx);
            }
        }
    }

    public class Model
    extends ComponentTableModel {
        public Model(ComponentTableModel.Column[] columns) {
            super(columns);
        }

        public void newRow(BComponent component) throws Exception {
            if (!this.validate(null, component)) {
                throw new Exception(lex.get("visitorTableFE.exception.visitorTypeExists"));
            }
            String name = ((BVisitorInput)component).getVisitorType().getTag();
            Mark mark = new Mark((BObject)component, name);
            mark.moveTo((BObject)BVisitorTableFE.this.visitorTable, null);
            BVisitorTableFE.this.visitorInputTable.loadValue((BObject)BVisitorTableFE.this.visitorTable);
        }

        private void loadRow(BVisitorInput visitorInput) {
            this.addRow(visitorInput);
            visitorInput.lease();
        }

        public void editRow(BComponent oldComponent, BComponent newComponent) throws Exception {
            Context cx;
            if (this.validate(oldComponent, newComponent)) {
                cx = Transaction.start((BComponent)BVisitorTableFE.this.visitorTable, null);
                for (Column column : BVisitorTableFE.this.colNames) {
                    column.save(oldComponent, newComponent, cx);
                }
            } else {
                throw new Exception(lex.get("visitorTableFE.exception.visitorTypeExists"));
            }
            Transaction.end((BComponent)BVisitorTableFE.this.visitorTable, (Context)cx);
            BVisitorTableFE.this.visitorInputTable.loadValue((BObject)BVisitorTableFE.this.visitorTable);
        }

        private boolean validate(BComponent oldComponent, BComponent newComponent) {
            BComponent[] visitorInputs;
            String newVisitorType = ((BVisitorInput)newComponent).getVisitorType().getTag();
            for (BComponent visitorInput : visitorInputs = this.getRows()) {
                if (!newVisitorType.equals(((BVisitorInput)visitorInput).getVisitorType().getTag()) || oldComponent != null && oldComponent.equals((Object)visitorInput)) continue;
                return false;
            }
            return true;
        }
    }
}

