/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.file.BINtplFile;
import com.tridium.template.file.PxFileRef;
import com.tridium.template.manifest.TemplateManifest;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.util.LabelUtil;
import com.tridium.ui.util.ValidatingTextController;
import com.tridium.util.CompUtil;
import com.tridium.workbench.auth.AuthUtil;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.tools.NewStationUtil;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.agent.BPxView;
import javax.baja.category.BCategoryMask;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDataFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDeployable;
import javax.baja.file.BIFile;
import javax.baja.file.BITemplate;
import javax.baja.file.FilePath;
import javax.baja.file.types.image.BImageFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.gx.Size;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.util.BNotifyPane;

public final class NewStationWizard
extends WizardModel {
    public static final String STATION_TEMPLATE_DIR = "stationTemplates";
    public static final BOrd STATION_TEMPLATE_DIR_ORD = BOrd.make((String)"local:|file:~stationTemplates");
    private static final Pattern COMPILE = Pattern.compile("file:~stationTemplates/", 16);
    private static final Pattern DEFAULT_COMPILE = Pattern.compile("file:!defaults/workbench/newStations/", 16);
    private static final String DEFAULT_PATH = "default: ";
    private static final UiLexicon LEXICON = UiLexicon.makeUiLexicon(NewStationWizard.class);
    private static final BImage BANNER = BImage.make((String)"module://icons/x32/newDatabase.png");
    private BNiagaraWbShell shell;
    private Step currentStep;
    private final List<BIFile> templates = new ArrayList<BIFile>();
    private Set<String> duplicateTemplates = null;
    private final List<BUser> adminUsers = new ArrayList<BUser>();
    private ArrayList<String> changedUsers = new ArrayList();
    private NameAndTemplateStep nameAndTemplateStep;
    private StationConfigStep stationConfigStep;

    public static void open(BNiagaraWbShell shell) {
        NewStationWizard model = new NewStationWizard(shell);
        BWizard.open((BWidget)shell, (WizardModel)model);
    }

    private NewStationWizard(BNiagaraWbShell shell) {
        this.shell = shell;
        this.nameAndTemplateStep = new NameAndTemplateStep();
        this.currentStep = this.nameAndTemplateStep;
        this.stationConfigStep = new StationConfigStep();
    }

    private static BWidget radioWidget(ToggleCommand command) {
        return new BRadioButton(command);
    }

    private FilePath getStationPath(String stationName) {
        FilePath stationsPath = new FilePath("~stations");
        if (stationName == null || stationName.trim().length() == 0) {
            return stationsPath;
        }
        return stationsPath.merge(stationName);
    }

    private static String toLocal(FilePath path) {
        return BFileSystem.INSTANCE.pathToLocalFile(path).getAbsolutePath();
    }

    private void notifySuccess(String detailText) {
        BNotifyPane pane = new BNotifyPane();
        BGridPane notifyGrid = new BGridPane(1);
        BLabel label = new BLabel(BImage.make((BIcon)BIcon.make((String)LEXICON.getText("NewStationTool.icon"))), LEXICON.getText("newStation.success", new Object[]{this.nameAndTemplateStep.stationNameTextField.getText()}));
        StyleUtils.addStyleClass((IStylable)label, (String)"strong");
        notifyGrid.add(null, (BValue)label);
        if (detailText != null) {
            label = new BLabel(detailText);
        }
        notifyGrid.add(null, (BValue)label);
        pane.setCenter((BWidget)notifyGrid);
        pane.open(7000);
    }

    public String getTitle() {
        return LEXICON.getText("newStation.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(420.0, 400.0);
    }

    public void init() {
        this.nameAndTemplateStep.enter();
    }

    public void back() {
        if (this.currentStep.equals(this.stationConfigStep)) {
            this.nameAndTemplateStep.enter();
        }
    }

    public void next() {
        if (this.currentStep.equals(this.nameAndTemplateStep) && this.nameAndTemplateStep.validate()) {
            this.stationConfigStep.enter();
        }
    }

    public boolean finish() {
        if (this.stationConfigStep.validate()) {
            FilePath targetStationPath;
            block7: {
                this.stationConfigStep.saveTemplateConfig();
                this.stationConfigStep.stationFile.close();
                targetStationPath = this.getStationPath(this.nameAndTemplateStep.stationNameTextField.getText());
                try {
                    BDirectory stationsDir = (BDirectory)BFileSystem.INSTANCE.findFile(this.getStationPath(null));
                    if (stationsDir == null) break block7;
                    for (BIFile kid : stationsDir.listFiles()) {
                        if (!kid.getFileName().equalsIgnoreCase(targetStationPath.getName())) continue;
                        kid.delete();
                        break;
                    }
                }
                catch (Exception stationsDir) {
                    // empty catch block
                }
            }
            try {
                BFileSystem.INSTANCE.move(this.stationConfigStep.stationFile.getFilePath().getParent(), targetStationPath, this.shell.getContext());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
            this.getWizard().close();
            ((FinishCommand)this.stationConfigStep.finalActionsGroup.getSelected()).finish();
            return true;
        }
        return false;
    }

    public boolean cancel() {
        if (this.stationConfigStep.stationFile != null) {
            try {
                this.stationConfigStep.stationFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                BFileSystem.INSTANCE.delete(this.stationConfigStep.stationFile.getFilePath().getParent());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static Set<String> findDuplicatesTemplates(List<BIFile> listContainingDuplicates) {
        HashSet<String> duplicateTemplate = new HashSet<String>();
        HashSet<String> templates = new HashSet<String>();
        for (BIFile file : listContainingDuplicates) {
            if (templates.add(file.getFileName())) continue;
            duplicateTemplate.add(file.getFileName());
        }
        return duplicateTemplate;
    }

    public static String getUniqueTemplateName(BITemplate template, Set<String> duplicateTemplates) {
        String uniqueName = "";
        uniqueName = duplicateTemplates != null && duplicateTemplates.contains(((BIDeployable)template).getFileName()) ? DEFAULT_COMPILE.matcher(String.valueOf(((BIDeployable)template).getFilePath())).replaceAll(Matcher.quoteReplacement(DEFAULT_PATH)) : ((BIDeployable)template).getFileName();
        return COMPILE.matcher(uniqueName.substring(0, uniqueName.lastIndexOf(46))).replaceAll(Matcher.quoteReplacement(""));
    }

    private abstract class Step {
        private Step() {
        }

        public abstract void enter();

        public abstract boolean validate();
    }

    public class AdminUsersModel
    extends TableModel {
        public void selectionModified() {
            ((NewStationWizard)NewStationWizard.this).stationConfigStep.isUserSelected = this.getTable().getSelection().getRow() >= 0;
            NewStationWizard.this.stationConfigStep.btnSetPassword.setEnabled(true);
        }

        public int getRowCount() {
            return NewStationWizard.this.adminUsers.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return LEXICON.getText("newStation.username");
                }
                case 1: {
                    return LEXICON.getText("newStation.role");
                }
                case 2: {
                    return LEXICON.getText("newStation.adminPasswordModified");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BUser user = (BUser)NewStationWizard.this.adminUsers.get(row);
            switch (col) {
                case 0: {
                    return user.getUsername();
                }
                case 1: {
                    return user.getRoles();
                }
                case 2: {
                    return NewStationWizard.this.changedUsers.contains(user.getUsername()) ? LEXICON.getText("newStation.yes") : "";
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return NewStationWizard.this.adminUsers.get(row);
        }
    }

    public class StationTemplateModel
    extends TableModel {
        public void selectionModified() {
            ((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.isStationSelected = this.getTable().getSelection().getRow() >= 0;
            NewStationWizard.this.getWizard().setNextEnabled(((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.isNameEntered && ((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.isStationSelected);
        }

        public int getRowCount() {
            return NewStationWizard.this.templates.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return LEXICON.getText("newStation.template.name");
                }
                case 1: {
                    return LEXICON.getText("newStation.template.vendor");
                }
                case 2: {
                    return LEXICON.getText("newStation.template.version");
                }
                case 3: {
                    return LEXICON.getText("newStation.template.description");
                }
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            BITemplate template = (BITemplate)NewStationWizard.this.templates.get(row);
            switch (col) {
                case 0: {
                    return NewStationWizard.getUniqueTemplateName(template, NewStationWizard.this.duplicateTemplates);
                }
                case 1: {
                    return template.getVendor();
                }
                case 2: {
                    return template.getVersion();
                }
                case 3: {
                    return template.getDescription();
                }
            }
            return "";
        }

        public Object getSubject(int row) {
            return NewStationWizard.this.templates.get(row);
        }
    }

    private class SessionFinishCommand
    extends FinishCommand {
        private final BDaemonSession session;

        public SessionFinishCommand(BDaemonSession session) {
            super(LEXICON.getText("newStation.sessionFinish.label", new Object[]{session.getType().getTypeName().equals("DaemonSecureSession") ? LEXICON.getText("newStation.securePlatform") : LEXICON.getText("newStation.platform"), session.getAddressString()}));
            this.session = session;
        }

        @Override
        public void finish() {
            NewStationWizard.this.notifySuccess(LEXICON.getText("newStation.startStationCopier"));
            Executors.newSingleThreadScheduledExecutor().schedule(() -> {
                NewStationWizard.this.shell.hyperlink(BOrd.make((BOrd)this.session.getNavOrd(), (String)("view:platDaemon:StationCopier?transferRemote=" + ((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.stationNameTextField.getText())));
                if (NewStationWizard.this.shell.getActiveOrdTarget() == null) {
                    BDialog.error((BWidget)NewStationWizard.this.shell, (String)LEXICON.getText("newStation.platformError.title"), (Object)LEXICON.getText("newStation.platformError.message"));
                } else {
                    NewStationWizard.this.shell.syncTree();
                }
            }, 2500L, TimeUnit.MILLISECONDS);
        }
    }

    private class OpenNewPlatformFinishCommand
    extends FinishCommand {
        public OpenNewPlatformFinishCommand() {
            super((Lexicon)LEXICON, "newStation.newSessionFinish");
        }

        @Override
        public void finish() {
            NewStationWizard.this.notifySuccess(LEXICON.getText("newStation.startStationCopier"));
            Executors.newSingleThreadScheduledExecutor().schedule(() -> {
                AuthUtil.connect((BWidget)NewStationWizard.this.shell, (BCnxHandler[])BCnxHandler.getHandlersOnType((TypeInfo)Sys.getType((String)"workbench:PlatformCnxType").getTypeInfo(), (BHost)BLocalHost.INSTANCE));
                if (NewStationWizard.this.shell.getActiveOrdTarget() == null) {
                    BDialog.error((BWidget)NewStationWizard.this.shell, (String)LEXICON.getText("newStation.platformError.title"), (Object)LEXICON.getText("newStation.platformError.message"));
                } else {
                    NewStationWizard.this.shell.hyperlink(BOrd.make((BOrd)NewStationWizard.this.shell.getActiveOrd(), (String)("view:platDaemon:StationCopier?transferRemote=" + ((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.stationNameTextField.getText())));
                    if (NewStationWizard.this.shell.getActiveOrdTarget() == null) {
                        BDialog.error((BWidget)NewStationWizard.this.shell, (String)LEXICON.getText("newStation.platformError.title"), (Object)LEXICON.getText("newStation.platformError.message"));
                    } else {
                        NewStationWizard.this.shell.syncTree();
                    }
                }
            }, 2500L, TimeUnit.MILLISECONDS);
        }
    }

    private class NoFinishCommand
    extends FinishCommand {
        public NoFinishCommand() {
            super((Lexicon)LEXICON, "newStation.noFinish");
        }

        @Override
        public void finish() {
            BDialog.info((BWidget)NewStationWizard.this.shell, (Object)LEXICON.getText("newStation.success", new Object[]{((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.stationNameTextField.getText()}));
        }
    }

    private class OpenLocalBogFinishCommand
    extends FinishCommand {
        public OpenLocalBogFinishCommand() {
            super((Lexicon)LEXICON, "newStation.openStationBog");
            this.setSelected(true);
        }

        @Override
        public void finish() {
            NewStationWizard.this.notifySuccess(LEXICON.getText("newStation.openBog"));
            FilePath targetStationPath = NewStationWizard.this.getStationPath(((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.stationNameTextField.getText());
            BOrd ord = BOrd.make((BOrd)BLocalHost.INSTANCE.getAbsoluteOrd(), (OrdQuery)targetStationPath.merge("config.bog"));
            ord = BOrd.make((BOrd)ord, (String)"bog:|slot:/");
            NewStationWizard.this.shell.hyperlink(ord);
            if (NewStationWizard.this.shell.getActiveOrdTarget() != null) {
                NewStationWizard.this.shell.syncTree();
            }
        }
    }

    private abstract class FinishCommand
    extends ToggleCommand {
        protected FinishCommand(Lexicon lexicon, String keyBase) {
            super((BWidget)NewStationWizard.this.shell, lexicon, keyBase);
        }

        public FinishCommand(String label) {
            super((BWidget)NewStationWizard.this.shell, label, null, null, null);
        }

        public void finish() {
        }
    }

    public class StationConfigStep
    extends Step {
        private FilePath lastSelectedTemplatePath = null;
        private FilePath lastStationConfigPath = null;
        private BBogFile stationFile = null;
        private BWidget content;
        private BGridPane templateConfigGrid;
        private BTemplateConfig templateConfig;
        private BButton btnSetPassword;
        private BTable adminUsersTable;
        public boolean isUserSelected = false;
        private boolean isPasswordReset = false;
        private BPasswordFE adminPass0;
        private BPasswordFE adminPass1;
        private BPassword newPass;
        private BLabel errorLabel;
        private BLabel stationConfigErrorLabel;
        private BLabel lblResetPass = new BLabel("");
        private final ToggleCommandGroup<ToggleCommand> finalActionsGroup;
        private final Map<Property, BWbFieldEditor> templateConfigFieldEditors = new LinkedHashMap<Property, BWbFieldEditor>();

        public StationConfigStep() {
            this.errorLabel = new BLabel("", BHalign.left);
            this.stationConfigErrorLabel = new BLabel("", BHalign.left);
            StyleUtils.addStyleClass((IStylable)this.errorLabel, (String)"error");
            StyleUtils.addStyleClass((IStylable)this.stationConfigErrorLabel, (String)"error");
            StyleUtils.addStyleClass((IStylable)this.lblResetPass, (String)"strong");
            BGridPane finalActionsGrid = new BGridPane(1);
            finalActionsGrid.setHalign(BHalign.left);
            this.finalActionsGroup = new ToggleCommandGroup();
            finalActionsGrid.add(null, (BValue)new BLabel(LEXICON.getText("newStation.finishHeader")));
            FinishCommand finalActionCommand = new OpenLocalBogFinishCommand();
            finalActionsGrid.add(null, (BValue)NewStationWizard.radioWidget(finalActionCommand));
            this.finalActionsGroup.add((ToggleCommand)finalActionCommand);
            boolean anyDaemonSessions = false;
            for (BISession localSession : BLocalHost.INSTANCE.getChildSessions()) {
                if (!(localSession instanceof BDaemonSession)) continue;
                anyDaemonSessions = true;
                finalActionCommand = new SessionFinishCommand((BDaemonSession)localSession);
                finalActionsGrid.add(null, (BValue)NewStationWizard.radioWidget(finalActionCommand));
                this.finalActionsGroup.add((ToggleCommand)finalActionCommand);
            }
            if (!anyDaemonSessions) {
                finalActionCommand = new OpenNewPlatformFinishCommand();
                finalActionsGrid.add(null, (BValue)NewStationWizard.radioWidget(finalActionCommand));
                this.finalActionsGroup.add((ToggleCommand)finalActionCommand);
            }
            finalActionCommand = new NoFinishCommand();
            finalActionsGrid.add(null, (BValue)NewStationWizard.radioWidget(finalActionCommand));
            this.finalActionsGroup.add((ToggleCommand)finalActionCommand);
            this.templateConfigGrid = new BGridPane(1);
            this.templateConfigGrid.setHalign(BHalign.left);
            this.templateConfigGrid.setValign(BValign.top);
            BEdgePane headerEdge = new BEdgePane();
            final BEdgePane topGrid = new BEdgePane();
            BEdgePane outerEdge = new BEdgePane();
            final BGridPane resetPassGrid = new BGridPane(1);
            BGridPane resetPassEditors = new BGridPane(1);
            headerEdge.setTop((BWidget)new BWizardHeader(BANNER, NewStationWizard.this.getTitle()));
            headerEdge.setCenter((BWidget)outerEdge);
            outerEdge.setTop((BWidget)new BBorderPane((BWidget)topGrid, 10.0, 10.0, 5.0, 10.0));
            this.adminUsersTable = new BTable((TableModel)new AdminUsersModel());
            this.adminUsersTable.setMultipleSelection(false);
            this.adminUsersTable.getSelection().select(0);
            this.isUserSelected = true;
            this.adminPass0 = new BPasswordFE();
            this.adminPass1 = new BPasswordFE();
            this.adminPass0.loadValue((BObject)BPassword.make((String)""));
            this.adminPass1.loadValue((BObject)BPassword.make((String)""));
            resetPassEditors.add(null, (BValue)this.lblResetPass);
            resetPassEditors.add(null, (BValue)new BLabel(" "));
            LabelUtil.addLabelWidgetPair((BPane)resetPassEditors, (String)LEXICON.getText("newStation.adminPasswordShort"), (BWidget)this.adminPass0);
            LabelUtil.addLabelWidgetPair((BPane)resetPassEditors, (String)LEXICON.getText("newStation.adminPasswordConfirmShort"), (BWidget)this.adminPass1);
            resetPassGrid.add(null, (BValue)resetPassEditors);
            resetPassGrid.add(null, (BValue)this.errorLabel);
            resetPassGrid.add(null, (BValue)new BLabel(" "));
            this.btnSetPassword = new BButton(LEXICON.getText("newStation.adminPasswordSetPassword")){

                public void doInvokeAction(CommandEvent event) {
                    int row = StationConfigStep.this.adminUsersTable.getSelection().getRow();
                    boolean validated = false;
                    BUser user = (BUser)NewStationWizard.this.adminUsers.get(row);
                    StationConfigStep.this.lblResetPass.setText(LEXICON.getText("newStation.adminPasswordReset", new Object[]{user.getName()}));
                    do {
                        int result;
                        if ((result = BDialog.open((BWidget)topGrid, (String)LEXICON.getText("newStation.adminPasswordSetPassword", new Object[]{user.getName()}), (Object)resetPassGrid, (int)3)) == 1 && StationConfigStep.this.validateCredentials()) {
                            try {
                                StationConfigStep.this.newPass = (BPassword)StationConfigStep.this.adminPass0.saveValue();
                                StationConfigStep.this.setPassword(user, StationConfigStep.this.newPass);
                                StationConfigStep.this.stationConfigErrorLabel.setText("");
                                StationConfigStep.this.isPasswordReset = true;
                                StationConfigStep.this.addUserToLabel(user);
                            }
                            catch (Exception e) {
                                System.out.println(e);
                            }
                            validated = true;
                        } else if (result == 2) break;
                        StationConfigStep.this.adminPass0.loadValue((BObject)BPassword.make((String)""));
                        StationConfigStep.this.adminPass1.loadValue((BObject)BPassword.make((String)""));
                    } while (!validated);
                    StationConfigStep.this.errorLabel.setText("");
                }
            };
            this.btnSetPassword.setEnabled(true);
            BEdgePane adminUserGrid = new BEdgePane();
            adminUserGrid.setCenter((BWidget)new BScrollPane((BWidget)this.adminUsersTable));
            BGridPane setPassGrid = new BGridPane(1);
            BGridPane readoutGrid = new BGridPane(1);
            readoutGrid.setHalign(BHalign.left);
            setPassGrid.add(null, (BValue)this.btnSetPassword);
            setPassGrid.setHalign(BHalign.left);
            adminUserGrid.setBottom((BWidget)setPassGrid);
            readoutGrid.add(null, (BValue)this.stationConfigErrorLabel);
            topGrid.setCenter((BWidget)new BBorderPane((BWidget)adminUserGrid, 10.0, 10.0, 10.0, 10.0));
            topGrid.setBottom((BWidget)readoutGrid);
            BScrollPane scrollPane = new BScrollPane((BWidget)this.templateConfigGrid);
            scrollPane.setVpolicy(BScrollBarPolicy.asNeeded);
            scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground((IStylable)scrollPane));
            outerEdge.setCenter((BWidget)new BBorderPane((BWidget)scrollPane, 0.0, 0.0, 0.0, 10.0));
            headerEdge.setBottom((BWidget)new BBorderPane((BWidget)finalActionsGrid, 10.0, 10.0, 10.0, 10.0));
            this.content = headerEdge;
        }

        private void addUserToLabel(BUser user) {
            if (!NewStationWizard.this.changedUsers.contains(user.getUsername())) {
                NewStationWizard.this.changedUsers.add(user.getUsername());
            }
        }

        private void setPassword(BUser user, BPassword pass) {
            BBogSpace space = (BBogSpace)this.stationFile.open();
            BStation station = (BStation)space.getRootComponent();
            BServiceContainer[] serviceContainers = (BServiceContainer[])station.getChildren(BServiceContainer.class);
            BUserService[] userServices = (BUserService[])serviceContainers[0].getChildren(BUserService.class);
            userServices[0].get(user.getName()).asComplex().set("authenticator", (BValue)new BPasswordAuthenticator(BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.newPass).getValue()), (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)));
        }

        @Override
        public void enter() {
            this.errorLabel.setText("");
            NewStationWizard.this.changedUsers.clear();
            try {
                String stationName = ((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.stationNameTextField.getText();
                String stationNameTemp = stationName + "Temp";
                BINtplFile ntpl = (BINtplFile)NewStationWizard.this.nameAndTemplateStep.getSelectedStationTemplate();
                FilePath stationConfigPath = NewStationWizard.this.getStationPath(stationNameTemp).merge("config.bog");
                if (!stationConfigPath.equals((Object)this.lastStationConfigPath) || !ntpl.getFilePath().equals((Object)this.lastSelectedTemplatePath)) {
                    this.lastSelectedTemplatePath = ntpl.getFilePath();
                    this.lastStationConfigPath = stationConfigPath;
                    if (this.stationFile != null) {
                        this.stationFile.close();
                        BFileSystem.INSTANCE.delete(this.stationFile.getFilePath().getParent());
                        this.stationFile = null;
                    }
                    BStation station = (BStation)ntpl.getBaseComponent();
                    station.setCategoryMask(BCategoryMask.make((String)"1"), null);
                    station.setStationName(stationName);
                    BServiceContainer[] serviceContainers = (BServiceContainer[])station.getChildren(BServiceContainer.class);
                    BUserService[] userServices = (BUserService[])serviceContainers[0].getChildren(BUserService.class);
                    BUser[] userList = (BUser[])userServices[0].getChildren(BUser.class);
                    NewStationWizard.this.adminUsers.clear();
                    for (BUser user : userList) {
                        Set roles = user.getRoleIds();
                        Iterator iterator = roles.iterator();
                        while (iterator.hasNext()) {
                            String role = (String)iterator.next();
                            if (!role.equals("admin")) continue;
                            NewStationWizard.this.adminUsers.add(user);
                        }
                    }
                    TemplateManifest tm = ntpl.getTemplateManifest();
                    FilePath stationPath = NewStationWizard.this.getStationPath(stationNameTemp);
                    FilePath sharedPath = stationPath.merge("shared");
                    boolean stationFilesFound = this.copyStationFiles(ntpl, stationPath);
                    if (!stationFilesFound) {
                        this.copyPxFiles(ntpl, sharedPath, false);
                        this.copyImageFiles(ntpl, sharedPath, false);
                    }
                    ntpl.close();
                    for (Object st : tm.subtemplates) {
                        FilePath filePath;
                        BIFile file;
                        TemplateManifest.Subtemplate subtemplate = (TemplateManifest.Subtemplate)st;
                        String stFileOrd = subtemplate.ntplFileOrd;
                        String stLocation = subtemplate.locationOrd;
                        if (stLocation.startsWith("slot:")) {
                            stLocation = stLocation.substring(5);
                        }
                        SlotPath stSlotPath = new SlotPath(stLocation);
                        if (stFileOrd.startsWith("file:")) {
                            stFileOrd = stFileOrd.substring(5);
                        }
                        if (!((file = BFileSystem.INSTANCE.findFile(filePath = new FilePath(stFileOrd))) instanceof BINtplFile)) continue;
                        BINtplFile ntplFile = (BINtplFile)file;
                        this.copyPxFiles(ntplFile, sharedPath, true);
                        this.copyImageFiles(ntplFile, sharedPath, true);
                        ((BINtplFile)file).close();
                        this.copyNtplFile(ntplFile, sharedPath);
                        BComponent stRoot = this.getSubtemplateRoot((BComponent)station, stSlotPath);
                        if (stRoot == null) continue;
                        FilePath pxpath = new FilePath("^px/deploy/" + ntplFile.getBaseComponent().getName());
                        for (BPxView pxView : (BPxView[])CompUtil.getDescendants((BComponent)stRoot, BPxView.class)) {
                            String pxOrdString = pxView.getPxFile().toString();
                            int i = pxOrdString.lastIndexOf(47);
                            String pxFileName = pxOrdString.substring(i + 1);
                            FilePath newPxpath = pxpath.merge(pxFileName);
                            pxView.setPxFile(BOrd.make((OrdQuery)newPxpath));
                        }
                    }
                    this.stationFile = (BBogFile)BFileSystem.INSTANCE.makeFile(stationConfigPath);
                    ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)new BufferedOutputStream(this.stationFile.getOutputStream()));
                    encoder.setZipped(true);
                    encoder.encodeDocument((BValue)station);
                    encoder.close();
                    this.templateConfig = BTemplateConfig.getConfigForRoot((BComponent)station);
                    this.templateConfigGrid.removeAll();
                    this.templateConfigFieldEditors.clear();
                    SlotCursor c = this.templateConfig.getProperties();
                    while (c.next()) {
                        if (c.property().isFrozen() || c.property().getName().equals("displayNames") || c.property().getType().getTypeName().equals("ConfigBinding")) continue;
                        BasicContext feContext = new BasicContext(NewStationWizard.this.shell.getContext(), this.templateConfig.getSlotFacets((Slot)c.property()));
                        BValue value = this.templateConfig.get(c.property()).newCopy(true);
                        BWbFieldEditor fieldEditor = BWbFieldEditor.makeFor((BObject)value, (Context)feContext, (BWbShell)NewStationWizard.this.shell);
                        if (fieldEditor == null) {
                            Logger.getLogger("wbutil").log(Level.WARNING, "No field editor available for " + this.templateConfig.getDisplayName((Slot)c.property(), NewStationWizard.this.shell.getContext()));
                            continue;
                        }
                        if (!fieldEditor.getType().getTypeName().equals("PropertySheetFE")) {
                            this.templateConfigGrid.add(null, (BValue)new BLabel(this.templateConfig.getDisplayName((Slot)c.property(), NewStationWizard.this.shell.getContext())));
                        }
                        this.templateConfigGrid.add(null, (BValue)fieldEditor);
                        this.templateConfigFieldEditors.put(c.property(), fieldEditor);
                        fieldEditor.loadValue((BObject)value, (Context)feContext);
                    }
                }
                NewStationWizard.this.currentStep = this;
                NewStationWizard.this.update(this.content, 5);
                if (!this.templateConfigFieldEditors.isEmpty()) {
                    this.templateConfigFieldEditors.values().stream().findFirst().get().requestFocus();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private BComponent getSubtemplateRoot(BComponent station, SlotPath templateRoot) {
            String[] names = templateRoot.getNames();
            if (names.length < 2) {
                return null;
            }
            try {
                BComponent component = station;
                for (int i = 1; i < names.length; ++i) {
                    component = component.get(names[i]).asComponent();
                }
                return component;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private void copyNtplFile(BINtplFile ntpl, FilePath sharedPath) throws Exception {
            BIFile file = (BIFile)ntpl;
            TemplateManifest tm = ntpl.getTemplateManifest();
            FilePath path = sharedPath.merge("template/" + tm.vendor);
            FilePath filePath = path.merge(file.getFileName());
            BIFile existingFile = BFileSystem.INSTANCE.findFile(filePath);
            if (existingFile != null) {
                if (existingFile.equals((Object)file)) {
                    return;
                }
                BFileSystem.INSTANCE.delete(filePath, NewStationWizard.this.shell.getContext());
            }
            BDirectory imDir = BFileSystem.INSTANCE.makeDir(path, NewStationWizard.this.shell.getContext());
            Mark mark = new Mark((BObject)file, file.getFileName());
            mark.copyTo((BObject)imDir, NewStationWizard.this.shell.getContext());
        }

        private void copyPxFiles(BINtplFile ntpl, FilePath sharedPath, boolean isSubTemplate) throws Exception {
            TemplateManifest tm = ntpl.getTemplateManifest();
            String path = isSubTemplate ? "px/deploy/" + ntpl.getBaseComponent().getName() : "px";
            FilePath pxpath = sharedPath.merge(path);
            for (PxFileRef pxrf : ntpl.getPxFiles()) {
                TemplateManifest.Resource pxResource = tm.getResource(pxrf.getPxName(), "px");
                if (pxResource != null) {
                    String pxOrd = pxResource.sourceOrd;
                    pxOrd = (pxOrd = pxOrd.replace("file:^", "")).equals(pxResource.name) ? "" : pxOrd.replace("/" + pxResource.name, "");
                    pxpath = sharedPath.merge(pxOrd);
                }
                this.copyFile((BIFile)pxrf.getPxFile(), "px", pxpath, tm);
            }
        }

        private void copyImageFiles(BINtplFile ntpl, FilePath sharedPath, boolean isSubTemplate) throws Exception {
            TemplateManifest tm = ntpl.getTemplateManifest();
            String path = isSubTemplate ? "images/deploy/" + ntpl.getBaseComponent().getName() : "px";
            FilePath pxpath = sharedPath.merge(path);
            for (BImageFile imag : ntpl.getPxImageFiles()) {
                TemplateManifest.Resource imageResource = tm.getResource(imag.getFileName(), "image");
                if (imageResource != null) {
                    String pxOrd = imageResource.sourceOrd;
                    pxOrd = (pxOrd = pxOrd.replace("file:^", "")).equals(imageResource.name) ? "" : pxOrd.replace("/" + imageResource.name, "");
                    pxpath = sharedPath.merge(pxOrd);
                }
                this.copyFile((BIFile)imag, "image", pxpath, ntpl.getTemplateManifest());
            }
        }

        private boolean copyStationFiles(BINtplFile ntpl, FilePath stationPath) throws Exception {
            BDataFile[] stationFiles = ntpl.getStationFiles();
            if (stationFiles == null || stationFiles.length == 0) {
                return false;
            }
            for (BDataFile dFile : stationFiles) {
                String relativeDirPath = dFile.getFilePath().getParent().getBody();
                FilePath fullDirPath = stationPath.merge(relativeDirPath = relativeDirPath.substring(relativeDirPath.indexOf(58) + 1));
                FilePath fullFilePath = fullDirPath.merge(dFile.getFileName());
                BIFile existingFile = BFileSystem.INSTANCE.findFile(fullFilePath);
                if (existingFile != null && !existingFile.equals((Object)dFile)) {
                    BFileSystem.INSTANCE.delete(fullFilePath, NewStationWizard.this.shell.getContext());
                    existingFile = null;
                }
                if (existingFile != null) continue;
                BDirectory dir = BFileSystem.INSTANCE.makeDir(fullDirPath, NewStationWizard.this.shell.getContext());
                Mark mark = new Mark((BObject)dFile, dFile.getFileName());
                mark.copyTo((BObject)dir, NewStationWizard.this.shell.getContext());
            }
            return true;
        }

        private void copyFile(BIFile f, String fileType, FilePath sharedPath, TemplateManifest tm) throws Exception {
            TemplateManifest.Resource res;
            FilePath filePath = sharedPath.merge(f.getFileName());
            BIFile existingFile = BFileSystem.INSTANCE.findFile(filePath);
            if (existingFile != null) {
                if (existingFile.equals((Object)f)) {
                    return;
                }
                BFileSystem.INSTANCE.delete(filePath, NewStationWizard.this.shell.getContext());
            }
            if ((res = tm.getResource(f.getFileName(), fileType)) != null && res.sourceOrd.startsWith("file:^")) {
                BDirectory imDir = BFileSystem.INSTANCE.makeDir(sharedPath, NewStationWizard.this.shell.getContext());
                Mark mark = new Mark((BObject)f, f.getFileName());
                mark.copyTo((BObject)imDir, NewStationWizard.this.shell.getContext());
            }
        }

        public boolean validateCredentials() {
            BPassword b;
            BPassword a;
            try {
                a = (BPassword)this.adminPass0.saveValue();
                b = (BPassword)this.adminPass1.saveValue();
            }
            catch (Throwable e) {
                return false;
            }
            if (!AccessController.doPrivileged(() -> ((BPassword)a).getValue()).equals(AccessController.doPrivileged(() -> ((BPassword)b).getValue()))) {
                this.errorLabel.setText(LEXICON.getText("newStation.adminPasswordMismatch"));
                return false;
            }
            try {
                String password = AccessController.doPrivileged(() -> ((BPassword)a).getValue());
                BPasswordStrength.DEFAULT.isPasswordValid(password);
                if (AccessController.doPrivileged(() -> ((BPassword)a).getValue()).equalsIgnoreCase(((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.stationNameTextField.getText())) {
                    this.errorLabel.setText(Lexicon.make((String)"baja").getText("user.strongPassword.matchStation"));
                    return false;
                }
            }
            catch (Exception e) {
                this.errorLabel.setText(e.getMessage());
                return false;
            }
            return true;
        }

        @Override
        public boolean validate() {
            this.errorLabel.setText("");
            if (!this.isPasswordReset) {
                this.stationConfigErrorLabel.setText(LEXICON.getText("newStation.adminPasswordMustReset"));
                return false;
            }
            BBogSpace space = (BBogSpace)this.stationFile.open();
            BStation station = (BStation)space.getRootComponent();
            BServiceContainer[] serviceContainers = (BServiceContainer[])station.getChildren(BServiceContainer.class);
            if (serviceContainers == null || serviceContainers.length == 0) {
                this.errorLabel.setText(LEXICON.getText("newStation.invalidTemplateFile.noServiceContainer"));
                return false;
            }
            BUserService[] userServices = (BUserService[])serviceContainers[0].getChildren(BUserService.class);
            if (userServices == null || userServices.length == 0) {
                this.errorLabel.setText(LEXICON.getText("newStation.invalidTemplateFile.noUserService"));
                return false;
            }
            for (Map.Entry<Property, BWbFieldEditor> templateConfigEntry : this.templateConfigFieldEditors.entrySet()) {
                BWbFieldEditor fieldEditor = templateConfigEntry.getValue();
                try {
                    fieldEditor.saveValue(NewStationWizard.this.shell.getContext());
                }
                catch (Exception e) {
                    fieldEditor.setModified();
                    this.errorLabel.setText(this.templateConfig.getDisplayName((Slot)templateConfigEntry.getKey(), NewStationWizard.this.shell.getContext()) + " : " + e.getLocalizedMessage());
                    return false;
                }
            }
            return true;
        }

        void saveTemplateConfig() {
            BBogSpace space = (BBogSpace)this.stationFile.open();
            BStation station = (BStation)space.getRootComponent();
            this.templateConfig = BTemplateConfig.getConfigForRoot((BComponent)station);
            for (Map.Entry<Property, BWbFieldEditor> editorEntry : this.templateConfigFieldEditors.entrySet()) {
                try {
                    this.templateConfig.set(editorEntry.getKey().getName(), (BValue)editorEntry.getValue().saveValue(NewStationWizard.this.shell.getContext()));
                }
                catch (Exception e) {
                    throw new LocalizableRuntimeException("wbutil", "newStation.saveError.saveTemplateConfig", (Throwable)e);
                }
            }
            BTemplateConfig.removeConfigFromRoot((BComponent)station);
            try {
                this.stationFile.save();
            }
            catch (Exception e) {
                throw new LocalizableRuntimeException("wbutil", "newStation.saveError.saveStationFile", (Throwable)e);
            }
        }
    }

    public class DeleteExistingStation {
        public BBooleanFE fieldEditor;
        public BLabel label;
        public BFlowPane content = new BFlowPane(BHalign.left);
        public Context facetsContext;

        public DeleteExistingStation() {
            this.label = new BLabel("");
            this.content.add(null, (BValue)this.label);
            StyleUtils.addStyleClass((IStylable)this.label, (String)"warning");
            this.fieldEditor = new BBooleanFE();
            this.content.add(null, (BValue)this.fieldEditor);
            Lexicon bajaui = Lexicon.make((String)"bajaui", (Context)NewStationWizard.this.shell.getContext());
            BFacets facets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BIDataValue[]{BString.make((String)bajaui.getText("dialog.yes")), BString.make((String)bajaui.getText("dialog.no"))});
            this.facetsContext = new BasicContext(NewStationWizard.this.shell.getContext(), facets);
            this.setVisible(false);
            this.setSelected(false);
        }

        public void setVisible(boolean value) {
            this.content.setVisible(value);
            this.content.relayoutSync();
        }

        public boolean isVisible() {
            return this.content.isVisible();
        }

        public void setSelected(boolean value) {
            this.fieldEditor.loadValue((BObject)BBoolean.make((boolean)value), this.facetsContext);
        }

        public void setStationName(String stationName) {
            this.setText(LEXICON.getText("newStation.deleteExisting", new Object[]{stationName}));
        }

        public void setText(String value) {
            this.label.setText(value);
        }

        public boolean isSelected() {
            try {
                return ((BBoolean)this.fieldEditor.saveValue(NewStationWizard.this.shell.getContext())).getBoolean();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public BWidget content() {
            return this.content;
        }
    }

    public class NameAndTemplateStep
    extends Step {
        public DeleteExistingStation deleteExistingStation;
        public BWidget content;
        public BTextField stationNameTextField;
        public BLabel errorLabel;
        public BTextField stationDirTextField;
        public BTable stationTemplateTable;
        public boolean isStationSelected = false;
        public boolean isNameEntered = false;

        public NameAndTemplateStep() {
            Collections.addAll(NewStationWizard.this.templates, NewStationUtil.getNewStationTemplates());
            if (NewStationWizard.this.templates.isEmpty()) {
                throw new LocalizableRuntimeException("wbutil", "newStation.noTemplates");
            }
            NewStationWizard.this.duplicateTemplates = NewStationWizard.findDuplicatesTemplates(NewStationWizard.this.templates);
            this.deleteExistingStation = new DeleteExistingStation();
            this.stationNameTextField = new BTextField("", 20);
            this.stationNameTextField.setModel(new TextModel(){

                protected void textModified() {
                    NameAndTemplateStep.this.stationNameTextFieldUpdated();
                }
            });
            this.stationNameTextField.setController((TextController)ValidatingTextController.make(updatedText -> updatedText == null || updatedText.length() == 0 || updatedText.length() <= 32 && SlotPath.isValidName((String)updatedText)));
            this.stationDirTextField = new BTextField(NewStationWizard.toLocal(NewStationWizard.this.getStationPath(this.stationNameTextField.getText())), 50, false);
            BFlowPane nameFlow = new BFlowPane(BHalign.left);
            nameFlow.add(null, (BValue)this.stationNameTextField);
            nameFlow.add(null, (BValue)new BLabel("   "));
            this.errorLabel = new BLabel("", BHalign.left);
            nameFlow.add(null, (BValue)this.errorLabel);
            StyleUtils.addStyleClass((IStylable)this.errorLabel, (String)"error");
            BGridPane fieldEditorsGrid = new BGridPane(1);
            fieldEditorsGrid.setHalign(BHalign.left);
            fieldEditorsGrid.setValign(BValign.top);
            fieldEditorsGrid.add(null, (BValue)new BLabel(LEXICON.getText("newStation.stationName")));
            fieldEditorsGrid.add(null, (BValue)nameFlow);
            fieldEditorsGrid.add(null, (BValue)new BLabel(LEXICON.getText("newStation.stationDir")));
            fieldEditorsGrid.add(null, (BValue)this.stationDirTextField);
            fieldEditorsGrid.add(null, (BValue)this.deleteExistingStation.content());
            BCanvasPane spacer = new BCanvasPane();
            spacer.setViewSize(BSize.make((double)0.0, (double)10.0));
            fieldEditorsGrid.add(null, (BValue)spacer);
            fieldEditorsGrid.add(null, (BValue)new BLabel(LEXICON.getText("newStation.templates")));
            this.stationTemplateTable = new BTable((TableModel)new StationTemplateModel());
            this.stationTemplateTable.setMultipleSelection(false);
            this.stationTemplateTable.getSelection().select(0);
            this.isStationSelected = true;
            BEdgePane fieldsAboveButtonsEdge = new BEdgePane();
            fieldsAboveButtonsEdge.setTop((BWidget)fieldEditorsGrid);
            fieldsAboveButtonsEdge.setCenter((BWidget)new BScrollPane((BWidget)this.stationTemplateTable));
            BEdgePane outerEdge = new BEdgePane();
            outerEdge.setTop((BWidget)new BWizardHeader(BANNER, NewStationWizard.this.getTitle()));
            outerEdge.setCenter((BWidget)new BBorderPane((BWidget)fieldsAboveButtonsEdge, 10.0, 10.0, 10.0, 10.0));
            Subscriber subscriber = new Subscriber(){

                public void event(BComponentEvent event) {
                    if (event.getSlot().equals((Object)BTable.selectionModified)) {
                        ((StationTemplateModel)NameAndTemplateStep.this.stationTemplateTable.getModel()).selectionModified();
                    }
                }
            };
            subscriber.subscribe((BComponent)this.stationTemplateTable);
            this.content = outerEdge;
        }

        public void stationNameTextFieldUpdated() {
            BDirectory stationsDir;
            String text = this.stationNameTextField.getText();
            if (NewStationWizard.this.getWizard() != null) {
                this.isNameEntered = SlotPath.isValidName((String)text) && text.length() <= 32;
                NewStationWizard.this.getWizard().setNextEnabled(this.isNameEntered && this.isStationSelected);
            }
            this.stationDirTextField.setText(NewStationWizard.toLocal(NewStationWizard.this.getStationPath(text)));
            boolean stationExists = false;
            if (text.length() > 0 && (stationsDir = (BDirectory)BFileSystem.INSTANCE.findFile(NewStationWizard.this.getStationPath(null))) != null) {
                for (BIFile kid : stationsDir.listFiles()) {
                    if (!kid.getFileName().equalsIgnoreCase(text)) continue;
                    stationExists = true;
                    break;
                }
            }
            if (text.length() > 0 && stationExists) {
                this.deleteExistingStation.setStationName(text);
                this.deleteExistingStation.setVisible(true);
            } else {
                this.deleteExistingStation.setVisible(false);
                this.errorLabel.setText("");
            }
        }

        @Override
        public void enter() {
            this.errorLabel.setText("");
            this.stationNameTextFieldUpdated();
            String name = this.stationNameTextField.getText();
            int mask = SlotPath.isValidName((String)name) && name.length() <= 32 ? 2 : 0;
            NewStationWizard.this.update(this.content, mask);
            NewStationWizard.this.getWizard().setNextAsDefault();
            this.stationNameTextField.requestFocus();
            NewStationWizard.this.currentStep = this;
        }

        @Override
        public boolean validate() {
            this.errorLabel.setText("");
            if (this.deleteExistingStation.isVisible() && !this.deleteExistingStation.isSelected()) {
                this.errorLabel.setText(LEXICON.getText("newStation.stationExists"));
                return false;
            }
            if (((NewStationWizard)NewStationWizard.this).nameAndTemplateStep.stationNameTextField.getText().length() == 0) {
                this.errorLabel.setText(LEXICON.getText("newStation.emptyStationName"));
                return false;
            }
            if (NewStationWizard.this.nameAndTemplateStep.getSelectedStationTemplate() == null) {
                this.errorLabel.setText(LEXICON.getText("newStation.noTemplateSelected"));
                return false;
            }
            return true;
        }

        public BIFile getSelectedStationTemplate() {
            BIFile selectedTemplate = null;
            TableSelection selection = this.stationTemplateTable.getModel().getSelection();
            for (int i = 0; i < NewStationWizard.this.templates.size(); ++i) {
                if (!selection.isSelected(i)) continue;
                selectedTemplate = (BIFile)NewStationWizard.this.templates.get(i);
                break;
            }
            return selectedTemplate;
        }
    }
}

