/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.gx.micro.awt.MicroFontWriter;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import java.awt.GraphicsEnvironment;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class EmbeddedDeviceFontWizard
extends WizardModel {
    private BWbShell wbShell;
    private Lexicon lexicon;
    private BWidget step1;
    private BWidget step2;
    private int currentStep;
    private BTextField fontOutputFilePathTextField;
    private BListDropDown systemFontDropDown;
    private BTextField systemFontSizes;
    private BCheckBox plainCheckBox;
    private BCheckBox boldCheckBox;
    private BCheckBox italicCheckBox;
    private BCheckBox boldItalicCheckBox;
    private BRadioButton allCodePointsRadioButton;
    private BRadioButton someCodePointsRadioButton;
    private BIntegerFE numCodePoints;
    private ToggleCommand someCodePoints;
    private ToggleCommand allCodePoints;
    private FilePath fontOutputFilePath;

    public EmbeddedDeviceFontWizard(BWbShell wbShell) {
        this.wbShell = wbShell;
        this.lexicon = Lexicon.make(EmbeddedDeviceFontWizard.class);
    }

    public static void open(BWbShell shell) {
        BWizard.open((BWidget)shell, (WizardModel)new EmbeddedDeviceFontWizard(shell));
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(550.0, 450.0);
    }

    public String getTitle() {
        return this.lexicon.getText("embeddedDeviceFontWizard.title");
    }

    public void init() {
        this.makeStep1();
        this.makeStep2();
        this.update(this.step1, 2);
        this.currentStep = 1;
    }

    public void back() {
        this.update(this.step1, 2);
        --this.currentStep;
    }

    public void next() {
        if (this.validateInputs() && this.createMicroFonts()) {
            this.update(this.step2, 5);
            return;
        }
        ++this.currentStep;
    }

    private void makeStep1() {
        BLabel infoLabel = new BLabel();
        infoLabel.setHalign(BHalign.make((int)0));
        infoLabel.setText(this.lexicon.getText("embeddedDeviceFontWizard.step1Info"));
        BGridPane infoLabelGridPane = new BGridPane(1);
        infoLabelGridPane.add(null, (BValue)infoLabel);
        BLabel fontOutputDirectoryLabel = new BLabel(this.lexicon.getText("embeddedDeviceFontWizard.fontOutputDirectoryInstructions"));
        BGridPane fontOutputDirectoryLabelGridPane = new BGridPane(1);
        fontOutputDirectoryLabelGridPane.add(null, (BValue)fontOutputDirectoryLabel);
        this.fontOutputFilePath = BFileSystem.INSTANCE.localFileToPath(Sys.getNiagaraSharedUserHome().toPath().resolve("microFont/").toFile());
        this.fontOutputFilePathTextField = new BTextField(this.fontOutputFilePath.toString(), 60);
        BButton openFileChooserButton = new BButton((Command)new FileChooser((BWidget)this.wbShell));
        openFileChooserButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane fontOutputDirectoryGridPane = new BGridPane(2);
        fontOutputDirectoryGridPane.add(null, (BValue)this.fontOutputFilePathTextField);
        fontOutputDirectoryGridPane.add(null, (BValue)openFileChooserButton);
        BLabel systemFontDropDownLabel = new BLabel(this.lexicon.getText("embeddedDeviceFontWizard.systemFontDropDownInstructions"));
        BGridPane systemFontDropDownLabelGridPane = new BGridPane(1);
        systemFontDropDownLabelGridPane.add(null, (BValue)systemFontDropDownLabel);
        String[] systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.systemFontDropDown = new BListDropDown();
        for (String systemFont : systemFonts) {
            this.systemFontDropDown.getList().addItem((Object)systemFont);
        }
        this.systemFontDropDown.setSelectedItem((Object)this.lexicon.getText("embeddedDeviceFontWizard.systemFontDropDownSelectedItem"));
        BGridPane systemFontDropDownGridPane = new BGridPane(1);
        systemFontDropDownGridPane.add(null, (BValue)this.systemFontDropDown);
        BLabel systemFontSizesLabel = new BLabel(this.lexicon.getText("embeddedDeviceFontWizard.systemFontSizesInstructions"));
        BGridPane systemFontSizesLabelGridPane = new BGridPane(1);
        systemFontSizesLabelGridPane.add(null, (BValue)systemFontSizesLabel);
        this.systemFontSizes = new BTextField(this.lexicon.getText("embeddedDeviceFontWizard.sizes"), 60);
        BGridPane systemFontSizesGridPane = new BGridPane(1);
        systemFontSizesGridPane.add(null, (BValue)this.systemFontSizes);
        BLabel systemFontStyleLabel = new BLabel(this.lexicon.getText("embeddedDeviceFontWizard.systemFontStyleInstructions"));
        BGridPane systemFontStylesLabelGridPane = new BGridPane(1);
        systemFontStylesLabelGridPane.add(null, (BValue)systemFontStyleLabel);
        this.plainCheckBox = new BCheckBox(this.lexicon.getText("embeddedDeviceFontWizard.plain"));
        this.boldCheckBox = new BCheckBox(this.lexicon.getText("embeddedDeviceFontWizard.bold"));
        this.italicCheckBox = new BCheckBox(this.lexicon.getText("embeddedDeviceFontWizard.italic"));
        this.boldItalicCheckBox = new BCheckBox(this.lexicon.getText("embeddedDeviceFontWizard.boldItalic"));
        this.plainCheckBox.setSelected(true);
        BGridPane systemFontStylesGridPane = new BGridPane(4);
        systemFontStylesGridPane.add(null, (BValue)this.plainCheckBox);
        systemFontStylesGridPane.add(null, (BValue)this.boldCheckBox);
        systemFontStylesGridPane.add(null, (BValue)this.italicCheckBox);
        systemFontStylesGridPane.add(null, (BValue)this.boldItalicCheckBox);
        BLabel systemFontCodePointsRadioButtonLabel = new BLabel(this.lexicon.getText("embeddedDeviceFontWizard.systemFontCodePointsRadioButtonInstructions"));
        BGridPane systemFontCodePointsRadioButtonLabelGridPane = new BGridPane(1);
        systemFontCodePointsRadioButtonLabelGridPane.add(null, (BValue)systemFontCodePointsRadioButtonLabel);
        this.someCodePoints = new ToggleCommand((BWidget)this.wbShell, this.lexicon.getText("embeddedDeviceFontWizard.someCharacters"));
        this.allCodePoints = new ToggleCommand((BWidget)this.wbShell, this.lexicon.getText("embeddedDeviceFontWizard.allCharacters"));
        this.someCodePointsRadioButton = new BRadioButton(this.someCodePoints);
        this.allCodePointsRadioButton = new BRadioButton(this.allCodePoints);
        BGridPane systemFontCodePointsRadioButtonsGridPane = new BGridPane(2);
        systemFontCodePointsRadioButtonsGridPane.add(null, (BValue)this.someCodePointsRadioButton);
        systemFontCodePointsRadioButtonsGridPane.add(null, (BValue)this.allCodePointsRadioButton);
        BLabel theFirstLabel = new BLabel(this.lexicon.getText("embeddedDeviceFontWizard.theFirst"));
        BLabel charactersLabel = new BLabel(this.lexicon.getText("embeddedDeviceFontWizard.characters"));
        this.numCodePoints = new BIntegerFE();
        this.numCodePoints.loadValue((BObject)BInteger.make((int)256), (Context)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)256), (String)"max", (BIDataValue)BInteger.make((int)65536)));
        BGridPane systemFontNumCodePointsGridPane = new BGridPane(3);
        systemFontNumCodePointsGridPane.add(null, (BValue)theFirstLabel);
        systemFontNumCodePointsGridPane.add(null, (BValue)this.numCodePoints);
        systemFontNumCodePointsGridPane.add(null, (BValue)charactersLabel);
        RadioButtonGroup radioButtonGroup = new RadioButtonGroup();
        radioButtonGroup.add(this.someCodePoints);
        radioButtonGroup.add(this.allCodePoints);
        BGridPane gridPane = new BGridPane(1);
        gridPane.setRowGap(10.0);
        gridPane.add(null, (BValue)infoLabelGridPane);
        gridPane.add(null, (BValue)fontOutputDirectoryLabelGridPane);
        gridPane.add(null, (BValue)fontOutputDirectoryGridPane);
        gridPane.add(null, (BValue)systemFontDropDownLabelGridPane);
        gridPane.add(null, (BValue)systemFontDropDownGridPane);
        gridPane.add(null, (BValue)systemFontSizesLabelGridPane);
        gridPane.add(null, (BValue)systemFontSizesGridPane);
        gridPane.add(null, (BValue)systemFontStylesLabelGridPane);
        gridPane.add(null, (BValue)systemFontStylesGridPane);
        gridPane.add(null, (BValue)systemFontCodePointsRadioButtonLabelGridPane);
        gridPane.add(null, (BValue)systemFontCodePointsRadioButtonsGridPane);
        gridPane.add(null, (BValue)systemFontNumCodePointsGridPane);
        BEdgePane edgePane = new BEdgePane();
        edgePane.setTop((BWidget)new BWizardHeader(null, this.getTitle(), this.lexicon.getText("embeddedDeviceFontWizard.oneOfTwo")));
        edgePane.setCenter((BWidget)new BBorderPane((BWidget)gridPane, 10.0, 10.0, 10.0, 10.0));
        this.step1 = edgePane;
    }

    private void makeStep2() {
        BTextEditor infoEditor = new BTextEditor();
        infoEditor.setEditable(false);
        infoEditor.setText(this.lexicon.getText("embeddedDeviceFontWizard.step2Info"));
        BEdgePane edgePane = new BEdgePane();
        edgePane.setTop((BWidget)new BWizardHeader(null, this.getTitle(), this.lexicon.getText("embeddedDeviceFontWizard.twoOfTwo")));
        edgePane.setCenter((BWidget)new BBorderPane((BWidget)infoEditor, 10.0, 10.0, 10.0, 10.0));
        this.step2 = edgePane;
    }

    private boolean validateInputs() {
        if (this.systemFontDropDown.getSelectedIndex() == -1) {
            BDialog.error((BWidget)this.wbShell, (Object)this.lexicon.getText("embeddedDeviceFontWizard.fontNameError"));
            return false;
        }
        if (this.getFontSizes() == null) {
            BDialog.error((BWidget)this.wbShell, (Object)this.lexicon.getText("embeddedDeviceFontWizard.fontSizeError"));
            return false;
        }
        if (!(this.plainCheckBox.isSelected() || this.boldCheckBox.isSelected() || this.italicCheckBox.isSelected() || this.boldItalicCheckBox.isSelected())) {
            BDialog.error((BWidget)this.wbShell, (Object)this.lexicon.getText("embeddedDeviceFontWizard.fontStyleError"));
            return false;
        }
        try {
            this.numCodePoints.saveValue();
            return true;
        }
        catch (Exception ex) {
            BDialog.error((BWidget)this.wbShell, (Object)this.lexicon.getText("embeddedDeviceFontWizard.numberOfCharactersError"));
            return false;
        }
    }

    private boolean createMicroFonts() {
        new MicroFontWriter().generateFontFiles(BFileSystem.INSTANCE.pathToLocalFile(this.fontOutputFilePath).toPath(), this.systemFontDropDown.getSelectedItem().toString(), this.getFontSizes(), this.plainCheckBox.isSelected(), this.boldCheckBox.isSelected(), this.italicCheckBox.isSelected(), this.boldItalicCheckBox.isSelected(), this.allCodePointsRadioButton.isSelected() ? 65535 : Integer.parseInt(this.numCodePoints.getCurrentValue().toString()) - 1);
        return true;
    }

    private int[] getFontSizes() {
        try {
            this.systemFontSizes.setText(this.systemFontSizes.getText().trim().replace(" ", ""));
            String[] fontSizeStrings = this.systemFontSizes.getText().split(",");
            int[] fontSizes = new int[fontSizeStrings.length];
            for (int i = 0; i < fontSizes.length; ++i) {
                fontSizes[i] = Integer.parseInt(fontSizeStrings[i]);
            }
            return fontSizes;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private class RadioButtonGroup<T extends ToggleCommand>
    extends ToggleCommandGroup<T> {
        private RadioButtonGroup() {
        }

        public void selected(ToggleCommand toggleCommand) {
            EmbeddedDeviceFontWizard.this.numCodePoints.setEnabled(toggleCommand == EmbeddedDeviceFontWizard.this.someCodePoints);
        }
    }

    private class FileChooser
    extends Command {
        private BImage openIcon;

        public FileChooser(BWidget owner) {
            super(owner, "");
            this.openIcon = BImage.make((String)EmbeddedDeviceFontWizard.this.lexicon.getText("embeddedDeviceFontWizard.openIcon"));
        }

        public CommandArtifact doInvoke() {
            BDirectoryChooser chooser = BDirectoryChooser.make((BWidget)this.getOwner());
            BOrd ord = chooser.show();
            if (ord != null) {
                EmbeddedDeviceFontWizard.this.fontOutputFilePath = ((BIFile)ord.get()).getFilePath();
                EmbeddedDeviceFontWizard.this.fontOutputFilePathTextField.setText(EmbeddedDeviceFontWizard.this.fontOutputFilePath.toString());
            }
            return null;
        }

        public BImage getIcon() {
            return this.openIcon;
        }

        public String getText() {
            return null;
        }
    }
}

