/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.metadata;

import com.tridium.workbench.metadata.BMetadataBrowser;
import javax.baja.data.BIDataValue;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="command", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="navOrds", type="BOrdList", defaultValue="BOrdList.NULL", flags=5), @NiagaraProperty(name="propName", type="String", defaultValue="", flags=5), @NiagaraProperty(name="metadataValue", type="BValue", defaultValue="BString.DEFAULT", flags=5), @NiagaraProperty(name="addOrSet", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="applyDescendants", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="propFlags", type="int", defaultValue="Flags.METADATA", flags=5), @NiagaraProperty(name="propFacets", type="BFacets", defaultValue="BFacets.NULL", flags=5), @NiagaraProperty(name="username", type="String", defaultValue="", flags=5)})
public class BMetadataJob
extends BSimpleJob {
    @Generated
    public static final Property command = BMetadataJob.newProperty((int)5, (int)0, null);
    @Generated
    public static final Property navOrds = BMetadataJob.newProperty((int)5, (BValue)BOrdList.NULL, null);
    @Generated
    public static final Property propName = BMetadataJob.newProperty((int)5, (String)"", null);
    @Generated
    public static final Property metadataValue = BMetadataJob.newProperty((int)5, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property addOrSet = BMetadataJob.newProperty((int)5, (boolean)true, null);
    @Generated
    public static final Property applyDescendants = BMetadataJob.newProperty((int)5, (boolean)true, null);
    @Generated
    public static final Property propFlags = BMetadataJob.newProperty((int)5, (int)16384, null);
    @Generated
    public static final Property propFacets = BMetadataJob.newProperty((int)5, (BValue)BFacets.NULL, null);
    @Generated
    public static final Property username = BMetadataJob.newProperty((int)5, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMetadataJob.class);
    static final Lexicon lex = Lexicon.make(BMetadataBrowser.class);
    static final BIcon icon = BIcon.std((String)"gears.png");
    static final BIcon addIcon = BIcon.make((String)lex.getText("metadataBrowser.commands.slotAdd.icon"));
    static final BIcon editIcon = BIcon.make((String)lex.getText("metadataBrowser.commands.slotEdit.icon"));
    static final BIcon removeIcon = BIcon.make((String)lex.getText("metadataBrowser.commands.slotRemove.icon"));
    static final int ADD_METADATA = 0;
    static final int EDIT_METADATA = 1;
    static final int REMOVE_METADATA = 2;
    BINavNode[] nodes = null;
    volatile boolean canceled = false;

    @Generated
    public int getCommand() {
        return this.getInt(command);
    }

    @Generated
    public void setCommand(int v) {
        this.setInt(command, v, null);
    }

    @Generated
    public BOrdList getNavOrds() {
        return (BOrdList)this.get(navOrds);
    }

    @Generated
    public void setNavOrds(BOrdList v) {
        this.set(navOrds, (BValue)v, null);
    }

    @Generated
    public String getPropName() {
        return this.getString(propName);
    }

    @Generated
    public void setPropName(String v) {
        this.setString(propName, v, null);
    }

    @Generated
    public BValue getMetadataValue() {
        return this.get(metadataValue);
    }

    @Generated
    public void setMetadataValue(BValue v) {
        this.set(metadataValue, v, null);
    }

    @Generated
    public boolean getAddOrSet() {
        return this.getBoolean(addOrSet);
    }

    @Generated
    public void setAddOrSet(boolean v) {
        this.setBoolean(addOrSet, v, null);
    }

    @Generated
    public boolean getApplyDescendants() {
        return this.getBoolean(applyDescendants);
    }

    @Generated
    public void setApplyDescendants(boolean v) {
        this.setBoolean(applyDescendants, v, null);
    }

    @Generated
    public int getPropFlags() {
        return this.getInt(propFlags);
    }

    @Generated
    public void setPropFlags(int v) {
        this.setInt(propFlags, v, null);
    }

    @Generated
    public BFacets getPropFacets() {
        return (BFacets)this.get(propFacets);
    }

    @Generated
    public void setPropFacets(BFacets v) {
        this.set(propFacets, (BValue)v, null);
    }

    @Generated
    public String getUsername() {
        return this.getString(username);
    }

    @Generated
    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMetadataJob() {
    }

    public BMetadataJob(int command, BINavNode[] nodes, String propName, BValue value, boolean addOrSet, boolean applyDescendants, Context cx) {
        this(command, nodes, propName, value, addOrSet, applyDescendants, 16384, null, cx);
    }

    public BMetadataJob(int command, BINavNode[] nodes, String propName, BValue value, boolean addOrSet, boolean applyDescendants, int flags, BFacets facets, Context cx) {
        this.setCommand(command);
        int len = nodes != null ? nodes.length : 0;
        BOrd[] ords = new BOrd[len];
        for (int i = 0; i < len; ++i) {
            ords[i] = nodes[i].getNavOrd().relativizeToSession();
        }
        this.setNavOrds(BOrdList.make((BOrd[])ords));
        if (propName != null) {
            this.setPropName(propName);
        }
        if (value != null) {
            this.setMetadataValue(value.newCopy(true));
        }
        this.setAddOrSet(addOrSet);
        this.setApplyDescendants(applyDescendants);
        this.setPropFlags(flags);
        if (facets != null) {
            this.setPropFacets(facets);
        }
        if (cx != null) {
            BUser user = cx.getUser();
            if (user != null) {
                this.setUsername(user.getUsername());
            } else {
                BObject obj = cx.getFacet("username");
                if (obj instanceof BString) {
                    this.setUsername(((BString)obj).getString());
                }
            }
        }
    }

    public void doCancel(Context cx) {
        this.canceled = true;
        super.doCancel(cx);
    }

    public void run(Context context) throws Exception {
        int len;
        this.retrieveNavNodes();
        int n = len = this.nodes != null ? this.nodes.length : 0;
        if (this.getCommand() < 0 || len < 1) {
            return;
        }
        double progressIncrement = 100.0 / (double)len;
        Exception e = null;
        Context cx = this.makeUserContext(context);
        switch (this.getCommand()) {
            case 0: {
                this.log().message("wbutil", "metadataBrowser.job.addSummary", new String[]{this.getPropName(), this.getMetadataValue().toString(cx)});
                for (int i = 0; i < len; ++i) {
                    Exception ex = this.addMeta(this.nodes[i], progressIncrement * (double)i, progressIncrement * (double)(i + 1), cx);
                    if (this.canceled) {
                        throw new JobCancelException();
                    }
                    if (e != null) continue;
                    e = ex;
                }
                this.log().message("wbutil", "metadataBrowser.job.commandComplete");
                break;
            }
            case 1: {
                this.log().message("wbutil", "metadataBrowser.job.editSummary", new String[]{this.getPropName(), this.getMetadataValue().toString(cx)});
                for (int i = 0; i < len; ++i) {
                    Exception ex = this.editMeta(this.nodes[i], progressIncrement * (double)i, progressIncrement * (double)(i + 1), cx);
                    if (this.canceled) {
                        throw new JobCancelException();
                    }
                    if (e != null) continue;
                    e = ex;
                }
                this.log().message("wbutil", "metadataBrowser.job.commandComplete");
                break;
            }
            case 2: {
                this.log().message("wbutil", "metadataBrowser.job.removeSummary", new String[]{this.getPropName()});
                for (int i = 0; i < len; ++i) {
                    Exception ex = this.deleteMeta(this.nodes[i], progressIncrement * (double)i, progressIncrement * (double)(i + 1), cx);
                    if (this.canceled) {
                        throw new JobCancelException();
                    }
                    if (e != null) continue;
                    e = ex;
                }
                this.log().message("wbutil", "metadataBrowser.job.commandComplete");
            }
        }
        this.progress(100);
        if (e != null) {
            throw e;
        }
    }

    Exception addMeta(BINavNode node, double progressStart, double progressEnd, Context cx) {
        Exception e;
        block19: {
            if (this.canceled) {
                throw new JobCancelException();
            }
            e = null;
            try {
                if (!(node instanceof BIPropertyContainer)) break block19;
                BIPropertyContainer container = (BIPropertyContainer)node;
                Property prop = container.getProperty(this.getPropName());
                BFacets facets = this.getPropFacets().isNull() ? null : this.getPropFacets();
                BUser user = cx != null ? cx.getUser() : null;
                boolean permitted = true;
                if (prop == null) {
                    if (user != null && node instanceof BIProtected) {
                        try {
                            user.check((BIProtected)node, BPermissions.adminWrite);
                        }
                        catch (PermissionException pe) {
                            permitted = false;
                        }
                    }
                    if (permitted) {
                        container.add(this.getPropName(), this.getMetadataValue().newCopy(true), this.getPropFlags() | 0x4000, facets, cx);
                        this.log().success("wbutil", "metadataBrowser.job.added", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)});
                    }
                    break block19;
                }
                if (!this.getAddOrSet() || (container.getFlags((Slot)prop) & 0x4000) == 0) break block19;
                if (user != null && node instanceof BIProtected) {
                    try {
                        if ((container.getFlags((Slot)prop) & 0x100) != 0) {
                            user.check((BIProtected)node, BPermissions.operatorWrite);
                        } else {
                            user.check((BIProtected)node, BPermissions.adminWrite);
                        }
                    }
                    catch (PermissionException pe) {
                        permitted = false;
                    }
                }
                if (permitted) {
                    container.set(prop, this.getMetadataValue().newCopy(true), cx);
                    container.setFlags((Slot)prop, 0x4000 | this.getPropFlags(), cx);
                    if (facets != null && !prop.isFrozen()) {
                        container.setFacets((Slot)prop, facets, cx);
                    }
                    this.log().success("wbutil", "metadataBrowser.job.set", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)});
                }
            }
            catch (DuplicateSlotException dse) {
                this.log().message("wbutil", "metadataBrowser.job.alreadyExists", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)});
            }
            catch (Exception x) {
                this.log().failed("wbutil", "metadataBrowser.job.addFail", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)}, (Throwable)x);
                e = x;
            }
        }
        if (this.getApplyDescendants()) {
            int len;
            BINavNode[] children = this.findChildren(node);
            int n = len = children != null ? children.length : 0;
            if (len > 0) {
                double progressIncrement = (progressEnd - progressStart) / (double)len;
                for (int i = 0; i < children.length; ++i) {
                    if (!this.acceptChild(children[i])) continue;
                    Exception ex = this.addMeta(children[i], progressStart + progressIncrement * (double)i, progressStart + progressIncrement * (double)(i + 1), cx);
                    if (e != null) continue;
                    e = ex;
                }
            }
        }
        this.progress((int)progressEnd);
        return e;
    }

    Exception editMeta(BINavNode node, double progressStart, double progressEnd, Context cx) {
        Exception e;
        block17: {
            if (this.canceled) {
                throw new JobCancelException();
            }
            e = null;
            try {
                if (!(node instanceof BIPropertyContainer)) break block17;
                BIPropertyContainer container = (BIPropertyContainer)node;
                Property prop = container.getProperty(this.getPropName());
                BUser user = cx != null ? cx.getUser() : null;
                boolean permitted = true;
                if (prop != null) {
                    if ((container.getFlags((Slot)prop) & 0x4000) == 0) break block17;
                    if (user != null && node instanceof BIProtected) {
                        try {
                            if ((container.getFlags((Slot)prop) & 0x100) != 0) {
                                user.check((BIProtected)node, BPermissions.operatorWrite);
                            } else {
                                user.check((BIProtected)node, BPermissions.adminWrite);
                            }
                        }
                        catch (PermissionException pe) {
                            permitted = false;
                        }
                    }
                    if (permitted) {
                        container.set(prop, this.getMetadataValue().newCopy(true), cx);
                        container.setFlags((Slot)prop, container.getFlags((Slot)prop) | 0x4000, cx);
                        this.log().success("wbutil", "metadataBrowser.job.set", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)});
                    }
                    break block17;
                }
                if (!this.getAddOrSet()) break block17;
                if (user != null && node instanceof BIProtected) {
                    try {
                        user.check((BIProtected)node, BPermissions.adminWrite);
                    }
                    catch (PermissionException pe) {
                        permitted = false;
                    }
                }
                if (permitted) {
                    container.add(this.getPropName(), this.getMetadataValue().newCopy(true), 16384, null, cx);
                    this.log().success("wbutil", "metadataBrowser.job.added", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)});
                }
            }
            catch (Exception x) {
                this.log().failed("wbutil", "metadataBrowser.job.setFail", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)}, (Throwable)x);
                e = x;
            }
        }
        if (this.getApplyDescendants()) {
            int len;
            BINavNode[] children = this.findChildren(node);
            int n = len = children != null ? children.length : 0;
            if (len > 0) {
                double progressIncrement = (progressEnd - progressStart) / (double)len;
                for (int i = 0; i < children.length; ++i) {
                    if (!this.acceptChild(children[i])) continue;
                    Exception ex = this.editMeta(children[i], progressStart + progressIncrement * (double)i, progressStart + progressIncrement * (double)(i + 1), cx);
                    if (e != null) continue;
                    e = ex;
                }
            }
        }
        this.progress((int)progressEnd);
        return e;
    }

    Exception deleteMeta(BINavNode node, double progressStart, double progressEnd, Context cx) {
        Exception e;
        block11: {
            if (this.canceled) {
                throw new JobCancelException();
            }
            e = null;
            try {
                BIPropertyContainer container;
                Property prop;
                if (!(node instanceof BIPropertyContainer) || (prop = (container = (BIPropertyContainer)node).getProperty(this.getPropName())) == null || (container.getFlags((Slot)prop) & 0x4000) == 0) break block11;
                BUser user = cx != null ? cx.getUser() : null;
                boolean permitted = true;
                if (user != null && node instanceof BIProtected) {
                    try {
                        user.check((BIProtected)node, BPermissions.adminWrite);
                    }
                    catch (PermissionException pe) {
                        permitted = false;
                    }
                }
                if (permitted) {
                    container.remove(this.getPropName(), cx);
                    this.log().success("wbutil", "metadataBrowser.job.removed", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)});
                }
            }
            catch (NoSuchSlotException nsse) {
                this.log().message("wbutil", "metadataBrowser.job.notExists", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)});
            }
            catch (Exception x) {
                this.log().failed("wbutil", "metadataBrowser.job.removeFail", new String[]{this.getPropName(), this.getNodeDisplayString(node, cx)}, (Throwable)x);
                e = x;
            }
        }
        if (this.getApplyDescendants()) {
            int len;
            BINavNode[] children = this.findChildren(node);
            int n = len = children != null ? children.length : 0;
            if (len > 0) {
                double progressIncrement = (progressEnd - progressStart) / (double)len;
                for (int i = 0; i < children.length; ++i) {
                    if (!this.acceptChild(children[i])) continue;
                    Exception ex = this.deleteMeta(children[i], progressStart + progressIncrement * (double)i, progressStart + progressIncrement * (double)(i + 1), cx);
                    if (e != null) continue;
                    e = ex;
                }
            }
        }
        this.progress((int)progressEnd);
        return e;
    }

    String getNodeDisplayString(BINavNode node, Context cx) {
        if (node == null) {
            return null;
        }
        BOrd ord = node.getNavOrd();
        if (ord == null || ord.isNull()) {
            SlotPath path;
            if (node instanceof BComponent && (path = ((BComponent)node).getSlotPath()) != null) {
                return path.toDisplayString();
            }
            if (node instanceof BIPropertyContainer) {
                return ((BIPropertyContainer)node).getDisplayName(cx);
            }
            return null;
        }
        return ord.relativizeToSession().toString(cx);
    }

    boolean acceptChild(BINavNode node) {
        if (node instanceof BComponent && !((BComponent)node).isMounted()) {
            return false;
        }
        int len = this.nodes.length;
        for (int i = 0; i < len; ++i) {
            if (node != this.nodes[i]) continue;
            return false;
        }
        return true;
    }

    BINavNode[] findChildren(BINavNode node) {
        if (node instanceof BComponent) {
            return (BINavNode[])((BComponent)node).getChildComponents();
        }
        return node.getNavChildren();
    }

    BINavNode[] retrieveNavNodes() {
        BOrdList list = this.getNavOrds();
        int len = list.size();
        this.nodes = new BINavNode[len];
        for (int i = 0; i < len; ++i) {
            this.nodes[i] = (BINavNode)list.get(i).get((BObject)this);
        }
        return this.nodes;
    }

    static BPermissions getPermissionsFor(Object object, Context cx) {
        try {
            if (object instanceof BIProtected) {
                return ((BIProtected)object).getPermissions(cx);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BPermissions.all;
    }

    Context makeUserContext(Context cx) {
        String user = this.getUsername();
        if (user == null || user.length() < 1) {
            return cx;
        }
        BUserService userService = BUserService.getService();
        BUser usr = userService.getUser(user);
        if (usr == null) {
            return cx;
        }
        return new MetadataContext(cx, usr);
    }

    public BIcon getIcon() {
        switch (this.getCommand()) {
            case 0: {
                return addIcon;
            }
            case 1: {
                return editIcon;
            }
            case 2: {
                return removeIcon;
            }
        }
        return icon;
    }

    static class MetadataContext
    implements Context {
        BUser user;
        Context cx;

        public MetadataContext(Context cx, BUser user) {
            this.user = user;
            this.cx = user != null ? new BasicContext(cx, BFacets.make((String)"username", (BIDataValue)BString.make((String)user.getUsername()))) : cx;
        }

        public Context getBase() {
            return this.cx;
        }

        public BUser getUser() {
            if (this.user != null) {
                return this.user;
            }
            if (this.cx != null) {
                return this.cx.getUser();
            }
            return null;
        }

        public BFacets getFacets() {
            if (this.cx != null) {
                return this.cx.getFacets();
            }
            return BFacets.NULL;
        }

        public BObject getFacet(String name) {
            return this.getFacets().get(name);
        }

        public String getLanguage() {
            if (this.cx != null) {
                return this.cx.getLanguage();
            }
            if (this.user != null) {
                return this.user.getLanguage();
            }
            return null;
        }
    }
}

