/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors.ord;

import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public final class BOrdSelectFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BOrdSelectFE.class);
    protected BListDropDown dropDown = new BListDropDown();
    public static final String QUERY_ORD_FACET = "queryOrd";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrdSelectFE() {
        this.linkTo(null, (BComponent)this.dropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.setContent((BWidget)new BBorderPane((BWidget)this.dropDown, 2.0, 0.0, 2.0, 0.0));
        this.dropDown.getList().setRenderer((ListRenderer)new Renderer());
    }

    protected void doSetReadonly(boolean readonly) {
        this.dropDown.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context context) {
        BOrd queryOrd = BOrd.NULL;
        try {
            this.dropDown.getList().removeAllItems();
            BComponent base = null;
            BWbShell shell = BWbShell.getWbShell((BWidget)this);
            if (shell != null) {
                base = shell.getActiveOrdTarget().getComponent();
            }
            if (base == null) {
                return;
            }
            if (context == null || context.getFacets() == null) {
                throw new Exception("queryOrd not specified in facets");
            }
            queryOrd = BOrd.make((String)context.getFacets().gets(QUERY_ORD_FACET, queryOrd.toString()));
            BObject res = queryOrd.get((BObject)base);
            if (res instanceof BIDirectory) {
                BIDirectory dir = (BIDirectory)res;
                BIFile[] files = dir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.dropDown.getList().addItem(BImage.make((BIcon)files[i].asObject().getIcon()), (Object)new ListItem(files[i].getFileName(), files[i].getOrdInSession(), null));
                }
            } else if (res instanceof BITable) {
                BITable result = (BITable)queryOrd.get((BObject)base);
                Column[] columns = result.getColumns().list();
                Column iconCol = null;
                Column ordCol = null;
                Column statusCol = null;
                Column nameCol = null;
                Column idCol = null;
                for (int i = 0; i < columns.length; ++i) {
                    String colName = columns[i].getName();
                    if (colName.indexOf("icon") > -1 || colName.indexOf("icon.encodeToString") > -1) {
                        iconCol = columns[i];
                        continue;
                    }
                    if (colName.indexOf("absoluteOrd") > -1 || colName.indexOf("ordInHost") > -1 || colName.indexOf("ordInSession") > -1 || colName.indexOf("ordInSpace") > -1 || colName.indexOf("handleOrd") > -1 || colName.indexOf("slotPathOrd") > -1 || colName.indexOf("navOrd") > -1) {
                        ordCol = columns[i];
                        continue;
                    }
                    if (colName.indexOf("status.encodeToString") > -1) {
                        statusCol = columns[i];
                        continue;
                    }
                    if (colName.indexOf("id") > -1) {
                        idCol = columns[i];
                        continue;
                    }
                    if (colName.indexOf("displayName") > -1) {
                        nameCol = columns[i];
                        continue;
                    }
                    if (colName.indexOf("name") <= -1 || nameCol != null) continue;
                    nameCol = columns[i];
                }
                TableCursor cursor = result.cursor();
                while (cursor.next()) {
                    BImage image = null;
                    if (iconCol != null) {
                        image = BImage.make((String)cursor.cell(iconCol).toString());
                    }
                    if (idCol != null) {
                        image = BImage.make((BIcon)BIcon.std((String)"history.png"));
                        this.dropDown.getList().addItem(image, (Object)new ListItem(cursor.cell(idCol).toString(), BOrd.make((String)("history:" + cursor.cell(idCol).toString())), null));
                        continue;
                    }
                    if (nameCol == null) {
                        throw new Exception("displayName or name not specified in queryOrd");
                    }
                    String name = cursor.cell(nameCol).toString();
                    BStatus status = null;
                    if (statusCol != null) {
                        status = (BStatus)BStatus.DEFAULT.decodeFromString(cursor.cell(statusCol).toString());
                        name = name + " {" + status.flagsToString(context) + "}";
                        if (status.isDisabled() && image != null) {
                            image = image.getDisabledImage();
                        }
                    }
                    if (ordCol == null) {
                        throw new Exception("ORD not specified in queryOrd");
                    }
                    BOrd ord = BOrd.make((String)cursor.cell(ordCol).toString());
                    this.dropDown.getList().addItem(image, (Object)new ListItem(name, ord, status));
                }
            }
            this.selectOrd((BOrd)value);
        }
        catch (Exception e) {
            System.out.println("Error in OrdSelectFE -> " + queryOrd + "...");
            e.printStackTrace();
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        ListItem item = (ListItem)this.dropDown.getList().getSelectedItem();
        BOrd o = BOrd.NULL;
        if (item != null && item.ord != null) {
            o = item.ord;
        }
        return o;
    }

    private boolean selectOrd(BOrd ord) {
        if (ord.isNull()) {
            return false;
        }
        BList list = this.dropDown.getList();
        int newIndex = -1;
        for (int i = 0; i < list.getItemCount(); ++i) {
            ListItem itemObj = (ListItem)list.getItem(i);
            if (itemObj == null || !itemObj.ord.equals((Object)ord)) continue;
            newIndex = i;
            break;
        }
        if (newIndex > -1) {
            list.setSelectedIndex(newIndex);
            return true;
        }
        return false;
    }

    public BOrd[] getOrdsFromList() {
        BOrd[] ords = new BOrd[this.dropDown.getList().getItemCount()];
        for (int i = 0; i < ords.length; ++i) {
            ords[i] = ((ListItem)this.dropDown.getList().getItem(i)).ord;
        }
        return ords;
    }

    public void selectFirstItem() {
        if (this.dropDown.getList().getItemCount() > 0) {
            this.dropDown.getList().setSelectedItem(this.dropDown.getList().getItem(0));
            this.setModified();
        }
    }

    public BOrd getSelectedOrd() {
        BOrd ord = BOrd.NULL;
        ListItem item = (ListItem)this.dropDown.getList().getSelectedItem();
        if (item != null) {
            ord = item.ord;
        }
        return ord;
    }

    public void setSelectedOrd(BOrd ord) {
        if (this.selectOrd(ord)) {
            this.setModified();
        }
    }

    private static class Renderer
    extends ListRenderer {
        private Renderer() {
        }

        public BBrush getBackground(ListRenderer.Item item) {
            ListItem lItem;
            if (item != null && item.value != null && (lItem = (ListItem)item.value).status != null) {
                BColor c = (BColor)lItem.status.getBackgroundColor((BSimple)BColor.black);
                if (c == BColor.black) {
                    return null;
                }
                return c.toBrush();
            }
            return null;
        }
    }

    private static final class ListItem {
        private String label = null;
        private BOrd ord = null;
        private BStatus status = null;

        ListItem(String label, BOrd ord, BStatus status) {
            this.label = label;
            this.ord = ord;
            this.status = status;
        }

        public String toString() {
            return this.label;
        }
    }
}

