/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors.gx;

import com.tridium.workbench.colorchooser.BBrushSwatch;
import com.tridium.workbench.colorchooser.BColorChooser;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"gx:Color"})})
public class BColorFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BColorFE.class);
    private BColor color;
    private BGridPane box;
    private BBrushSwatch swatch = new BBrushSwatch();
    private BLabel label;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BColorFE() {
        this.swatch.setPreferredSize(24.0, 16.0);
        this.swatch.setController(new Controller());
        this.label = new BLabel();
        BGridPane pane = new BGridPane(2);
        pane.setColumnGap(5.0);
        pane.add("swatch", (BValue)new BBorderPane((BWidget)this.swatch, BBorder.inset, BInsets.DEFAULT));
        pane.add("label", (BValue)this.label);
        this.setContent((BWidget)pane);
    }

    protected void doSetReadonly(boolean readonly) {
        this.label.setEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.color = value instanceof BString ? BColor.make((String)((BString)value).getString()) : (BColor)value;
        this.swatch.setBrush(this.color.toBrush());
        this.label.setText(this.color.toString());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (value instanceof BString) {
            return BString.make((String)this.color.encodeToString());
        }
        return this.color;
    }

    class Controller
    extends BBrushSwatch.Controller {
        Controller() {
        }

        @Override
        public void mousePressed(BMouseEvent event) {
            if (BColorFE.this.isReadonly()) {
                return;
            }
            BColor c = BColorChooser.openInDialog((BWidget)BColorFE.this, BColorFE.this.color);
            if (c != null) {
                BColorFE.this.color = c;
                this.swatch.setBrush(BColorFE.this.color.toBrush());
                BColorFE.this.label.setText(BColorFE.this.color.toString());
                BColorFE.this.setModified();
                BColorFE.this.relayout();
            }
        }

        @Override
        public void mouseEntered(BMouseEvent event) {
            if (!BColorFE.this.isReadonly()) {
                this.swatch.setMouseCursor(MouseCursor.dropper);
            }
        }

        @Override
        public void mouseExited(BMouseEvent event) {
            if (!BColorFE.this.isReadonly()) {
                this.swatch.setMouseCursor(MouseCursor.normal);
            }
        }
    }
}

