/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.colorchooser;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.ColorModel;
import java.awt.Color;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Insets;
import javax.baja.gx.PolygonGeom;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

@NiagaraType
public class BHueBar
extends BWidget
implements ColorModel.Agent {
    @Generated
    public static final Type TYPE = Sys.loadType(BHueBar.class);
    private static Insets insets = new Insets(2.0, 2.0, 2.0, 2.0);
    private ColorModel model;
    private BImage image;
    private int arrowWidth = 5;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHueBar() {
        throw new IllegalStateException();
    }

    public BHueBar(ColorModel model) {
        this.model = model;
        model.addAgent(this);
    }

    public void computePreferredSize() {
        this.setPreferredSize(40.0, 300.0);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth() - 1.0 - BHueBar.insets.left - BHueBar.insets.right - (double)this.arrowWidth;
        double h = this.getHeight() - 5.0 - BHueBar.insets.top - BHueBar.insets.bottom;
        if (this.image == null || this.image.getWidth() != w || this.image.getHeight() != h) {
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = BImage.make((double)w, (double)h);
            this.createImage();
        }
    }

    public void paint(Graphics g) {
        if (this.image == null) {
            return;
        }
        double x = BHueBar.insets.left;
        double y = BHueBar.insets.top;
        double w = this.image.getWidth();
        double h = this.image.getHeight();
        if (this.image != null) {
            g.drawImage(this.image, x, y + 2.0);
        }
        g.setBrush(BColor.black);
        g.strokeRect(1.0, 3.0, w + 1.0, h + 1.0);
        g.setBrush(Theme.widget().getControlShadow());
        g.strokeLine(0.0, 2.0, w + 3.0, 2.0);
        g.strokeLine(0.0, 2.0, 0.0, h + 5.0);
        g.setBrush(Theme.widget().getControlHighlight());
        g.strokeLine(w + 3.0, 3.0, w + 3.0, h + 5.0);
        g.strokeLine(1.0, h + 5.0, w + 3.0, h + 5.0);
        double cx = w + 1.0 + BHueBar.insets.left + BHueBar.insets.right;
        double cy = 4.0 + h - (double)this.model.getHue() * h;
        if (this.isEnabled()) {
            double[] px = new double[]{cx, cx + (double)this.arrowWidth, cx + (double)this.arrowWidth};
            double[] py = new double[]{cy, cy - 5.0, cy + 5.0};
            PolygonGeom arrow = new PolygonGeom(px, py, 3);
            g.setBrush(BColor.black);
            g.fill((IGeom)arrow);
        }
    }

    private void createImage() {
        if (this.image == null) {
            return;
        }
        double w = this.image.getWidth();
        double h = this.image.getHeight();
        Graphics g = this.image.getGraphics();
        float hue = this.model.getHue();
        float sat = 1.0f;
        float bri = 1.0f;
        int i = 0;
        while ((double)i <= h) {
            hue = 1.0f - (float)((double)i / h);
            g.setBrush(BColor.make((int)Color.getHSBColor(hue, sat, bri).getRGB()));
            g.strokeLine(0.0, (double)i, w, (double)i);
            ++i;
        }
        g.dispose();
    }

    public void mousePressed(BMouseEvent event) {
        this.doEvent(event);
    }

    public void mouseDragged(BMouseEvent event) {
        this.doEvent(event);
    }

    public void doEvent(BMouseEvent event) {
        float hue = (float)(event.getY() / this.getHeight());
        if (event.getY() <= 0.0) {
            hue = 0.0f;
        }
        if (event.getY() >= this.getHeight()) {
            hue = 1.0f;
        }
        hue = 1.0f - hue;
        this.model.set(hue, this.model.getSat(), this.model.getBri());
        this.repaint();
    }

    @Override
    public void colorChanged() {
        this.repaint();
    }
}

