/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import com.tridium.fox.util.FoxRpcUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.category.BCategoryCheckList;
import com.tridium.workbench.category.CategoryViewSupport;
import java.util.HashMap;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BPermissions;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"baja:Component"}, requiredPermissions="R")})
public class BCategorySheet
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BCategorySheet.class);
    static final Lexicon lex = Lexicon.make(BCategorySheet.class);
    BICategorizable categorizable;
    BCategoryCheckList list;
    InheritToggle inherit = new InheritToggle((BWidget)this);
    Command selectAll = new SelectAllCommand((BWidget)this);
    Command deselectAll = new DeselectAllCommand((BWidget)this);
    Command gotoService = new GotoServiceCommand((BWidget)this);
    BButton refresh = new BButton(UiLexicon.bajaui().getText("commands.refresh.label"));
    BButton save = new BButton(UiLexicon.bajaui().getText("commands.save.label"));
    private CategoryViewSupport viewSupport;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCategorySheet() {
        this.autoRegisterForComponentEvents = false;
        this.viewSupport = new CategoryViewSupport((BWbEditor)this);
        this.list = new BCategoryCheckList(this.viewSupport);
        this.linkTo((BComponent)this.list, (Slot)pluginModified, (Slot)setModified);
        BCheckBox box = new BCheckBox((ToggleCommand)this.inherit);
        box.setFont(Theme.widget().getBoldText());
        BGridPane right = new BGridPane(0);
        right.setValign(BValign.top);
        right.setColumnAlign(BHalign.fill);
        right.add("a", (BValue)box);
        right.add("b", (BValue)new BButton(this.selectAll));
        right.add("c", (BValue)new BButton(this.deselectAll));
        right.add("d", (BValue)new BButton(this.gotoService));
        BGridPane bottom = new BGridPane(3);
        bottom.setUniformColumnWidth(true);
        bottom.setColumnAlign(BHalign.fill);
        bottom.add("refresh", (BValue)this.refresh);
        bottom.add("save", (BValue)this.save);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)this.list);
        pane.setRight((BWidget)right);
        pane.setBottom((BWidget)bottom);
        this.setContent((BWidget)new BTitlePane(lex.getText("category.sheet.title"), (BWidget)pane));
    }

    public void doLoadValue(BObject obj, Context cx) throws Exception {
        BINavNode parent;
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            this.refresh.setCommand(shell.getRefreshCommand(), true, true);
            this.save.setCommand(shell.getSaveCommand(), true, true);
        } else {
            this.refresh.setEnabled(false);
            this.save.setEnabled(false);
        }
        this.categorizable = (BICategorizable)obj;
        BCategoryMask mask = this.categorizable.getCategoryMask();
        BCategoryMask applied = this.categorizable.getAppliedCategoryMask();
        if (this.categorizable instanceof BINavNode && (parent = ((BINavNode)obj).getNavParent()) instanceof BICategorizable) {
            applied = ((BICategorizable)parent).getAppliedCategoryMask();
        }
        this.inherit.setSelected(mask.isNull());
        if (mask.isNull()) {
            mask = applied;
        }
        this.list.load(shell, mask, applied);
    }

    public BObject doSaveValue(BObject obj, Context cx) throws Exception {
        BCategoryMask mask;
        if (this.inherit.isSelected()) {
            mask = BCategoryMask.NULL;
        } else {
            mask = this.list.save();
            if (mask.isNull()) {
                throw new CannotSaveException(lex.getText("category.mustBeInOne"));
            }
        }
        if (this.categorizable instanceof BVirtualComponent) {
            BCategoryService service = (BCategoryService)BOrd.make((BOrd)this.getWbShell().getActiveOrd(), (String)"service:baja:CategoryService").get();
            service.lease(1);
            BOrdToCategoryMap ordMap = service.getOrdMap();
            int len = ordMap.size();
            HashMap<BOrd, BCategoryMask> map = new HashMap<BOrd, BCategoryMask>();
            for (int i = 0; i < len; ++i) {
                map.put(ordMap.getOrd(i), ordMap.getCategoryMask(i));
            }
            BOrd ord = ((BVirtualComponent)this.categorizable).getCategorizableOrd().relativizeToSession();
            if (mask == null || mask.isNull()) {
                map.remove(ord);
            } else {
                map.put(ord, mask);
            }
            Array ords = new Array(BOrd.class);
            Array masks = new Array(BCategoryMask.class);
            for (BOrd o : map.keySet()) {
                BCategoryMask m = (BCategoryMask)map.get(o);
                if (m == null || m.isNull()) continue;
                ords.add((Object)o);
                masks.add((Object)m);
            }
            service.setOrdMap(BOrdToCategoryMap.make((BOrd[])((BOrd[])ords.trim()), (BCategoryMask[])((BCategoryMask[])masks.trim())));
            BCategorySheet.update(service, cx);
        } else {
            ((BComponent)this.categorizable).setCategoryMask(mask, cx);
        }
        return obj;
    }

    static void update(BCategoryService categoryService, Context cx) {
        Version remoteVersion = null;
        try {
            remoteVersion = (Version)((BObject)categoryService.getSession()).fw(404, (Object)"baja", null, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        BPermissions userPermissions = categoryService.getPermissions(cx);
        if (userPermissions.hasOperatorRead() && remoteVersion != null && !remoteVersion.isNull() && remoteVersion.compareTo(new Version("4.8")) >= 0) {
            FoxRpcUtil.doSilentRpc((BISpaceNode)categoryService, (String)"updateRpc", (Object[])new Object[0]);
        } else if (userPermissions.hasAdminInvoke()) {
            try {
                categoryService.update();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class GotoServiceCommand
    extends Command {
        GotoServiceCommand(BWidget owner) {
            super(owner, lex, "category.gotoService");
        }

        public CommandArtifact doInvoke() {
            if (BCategorySheet.this.list.service != null) {
                BCategorySheet.this.getWbShell().hyperlink(BCategorySheet.this.list.service.getNavOrd());
            }
            return null;
        }
    }

    class DeselectAllCommand
    extends Command {
        DeselectAllCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.deselectAll");
        }

        public CommandArtifact doInvoke() {
            BCategorySheet.this.list.deselectAll();
            BCategorySheet.this.setModified();
            return null;
        }
    }

    class SelectAllCommand
    extends Command {
        SelectAllCommand(BWidget owner) {
            super(owner, UiLexicon.bajaui().module, "commands.selectAll");
        }

        public CommandArtifact doInvoke() {
            BCategorySheet.this.list.selectAll();
            BCategorySheet.this.setModified();
            return null;
        }
    }

    class InheritToggle
    extends ToggleCommand {
        InheritToggle(BWidget owner) {
            super(owner, lex, "category.inherit");
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BCategorySheet.this.list.setTrump(sel);
            BCategorySheet.this.setModified();
        }
    }
}

