/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PdfStream
extends PdfObject {
    protected boolean debug = false;
    protected ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
    protected DeflaterOutputStream deflater = this.debug ? new DeflaterOutputStream((OutputStream)this.byteArray, new Deflater(0)) : new DeflaterOutputStream(this.byteArray);

    public PdfStream(PdfDocument parent, int objectId, int generationNum) {
        super(parent, objectId, generationNum);
    }

    public void print(byte b) throws IOException {
        if (this.debug) {
            this.byteArray.write(b);
        } else {
            this.deflater.write(b);
        }
    }

    public void print(byte[] bytes) throws IOException {
        if (this.debug) {
            this.byteArray.write(bytes);
        } else {
            this.deflater.write(bytes);
        }
    }

    public void print(String str) throws IOException {
        if (this.debug) {
            this.byteArray.write(str.getBytes());
        } else {
            this.deflater.write(str.getBytes());
        }
    }

    public void println(String str) throws IOException {
        this.print(str + '\n');
    }

    @Override
    public void toPdf() throws IOException {
        PdfDocument doc = this.getParent();
        if (!this.debug) {
            this.deflater.flush();
            this.deflater.close();
        }
        byte[] data = this.byteArray.toByteArray();
        doc.markOffset(this.getObjectId());
        doc.writeln(this.getObjectId() + " " + this.getGenerationNum() + " obj");
        doc.write("<< /Length " + data.length);
        if (!this.debug) {
            doc.write("/Filter/FlateDecode");
        }
        doc.write(" >>");
        doc.writeln("stream");
        doc.write(data);
        doc.writeln("\nendstream");
        doc.writeln("endobj");
    }
}

