/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pdf.gx;

import com.tridium.pdf.gx.PdfDocument;
import com.tridium.pdf.gx.PdfStream;
import java.io.IOException;

public class PdfImageStream
extends PdfStream {
    private static final byte ALPHA_OPAQUE = -1;
    private static int maskNum;
    private byte[] mask;
    protected int imageWidth;
    protected int imageHeight;
    private int bitsPerComponent = 8;
    private String colorSpace = "DeviceRGB";
    private boolean hasTransparency;

    public PdfImageStream(PdfDocument parent, int objectId, int generationNum) {
        super(parent, objectId, generationNum);
    }

    public void setImageSize(int w, int h) {
        this.imageWidth = w;
        this.imageHeight = h;
    }

    public void setColorSpace(String name) {
        this.colorSpace = name;
    }

    public void setBitsPerComponent(int bits) {
        this.bitsPerComponent = bits;
    }

    public void writePixels(int[] pixels, int w, int h) throws IOException {
        this.mask = new byte[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            int pixel = pixels[i];
            byte alpha = (byte)(pixel >> 24 & 0xFF);
            byte red = (byte)(pixel >> 16 & 0xFF);
            byte green = (byte)(pixel >> 8 & 0xFF);
            byte blue = (byte)(pixel & 0xFF);
            this.print(new byte[]{red, green, blue});
            this.mask[i] = alpha;
            if (alpha == -1) continue;
            this.hasTransparency = true;
        }
        this.println("");
        this.setImageSize(w, h);
    }

    private PdfImageStream createSoftMaskStream() {
        PdfImageStream mask = this.getParent().createImageStream();
        mask.setBitsPerComponent(8);
        mask.setColorSpace("DeviceGray");
        mask.setImageSize(this.imageWidth, this.imageHeight);
        return mask;
    }

    @Override
    public void toPdf() throws IOException {
        this.startObject();
        this.writeImageAttributes();
        if (this.hasTransparency) {
            this.writeSoftMask();
        }
        this.writeStreamData();
        this.endObject();
    }

    private void startObject() {
        PdfDocument doc = this.getParent();
        doc.markOffset(this.getObjectId());
        doc.writeln(this.getObjectId() + " " + this.getGenerationNum() + " obj");
    }

    private void writeImageAttributes() {
        PdfDocument doc = this.getParent();
        doc.write("<< /Type /XObject /Subtype /Image");
        doc.write(" /Width " + this.imageWidth + " /Height " + this.imageHeight);
        doc.write(" /ColorSpace /" + this.colorSpace + " /BitsPerComponent " + this.bitsPerComponent);
    }

    private void writeSoftMask() throws IOException {
        PdfDocument doc = this.getParent();
        PdfImageStream softMask = this.createSoftMaskStream();
        softMask.print(this.mask);
        doc.getCurrentPage().addXObject("SMask" + maskNum++, softMask);
        doc.write(" /SMask " + softMask.getObjectId() + " 0 R");
    }

    private void writeStreamData() throws IOException {
        PdfDocument doc = this.getParent();
        byte[] data = this.consumeStreamData();
        doc.write(" /Length " + data.length);
        doc.writeln(this.debug ? " >>" : " /Filter /FlateDecode >>");
        doc.writeln("stream");
        doc.write(data);
        doc.writeln("\nendstream");
    }

    private void endObject() {
        PdfDocument doc = this.getParent();
        doc.writeln("endobj");
    }

    private byte[] consumeStreamData() throws IOException {
        if (!this.debug) {
            this.deflater.flush();
            this.deflater.close();
        }
        return this.byteArray.toByteArray();
    }
}

