/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ux.util;

import com.tridium.json.JSONObject;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.camera.controlHelper.BCameraControlTimings;
import com.tridium.nvideo.dvr.BVideoDvr;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.camera.BVideoPlaybackChooser;
import com.tridium.videoDriver.camera.control.BIVideoFocusControl;
import com.tridium.videoDriver.camera.control.BIVideoIrisControl;
import com.tridium.videoDriver.camera.control.BIVideoMoveToPresetControl;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.camera.control.BIVideoStorePresetControl;
import com.tridium.videoDriver.camera.control.BIVideoZoomControl;
import com.tridium.videoDriver.dvr.BIVideoDvr;
import com.tridium.videoDriver.enums.BVideoFocusEnum;
import com.tridium.videoDriver.enums.BVideoIrisEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BIVideoEventProvider;
import com.tridium.videoDriver.event.BRetrieveActionParam;
import com.tridium.videoDriver.event.BRetrieveTopicEvent;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.event.BVideoEventRecall;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.box.BIBoxVideoStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BVideoDriverRpc
extends BObject {
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoDriverRpc.class);
    private static int VIDEO_EVENT_TIMEOUT_MILLIS = AccessController.doPrivileged(() -> Integer.getInteger("niagara.videodriver.videoevent.timeout", 20000));

    @Generated
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<String> getCameraList(Context cx) {
        BVideoPlaybackChooser playbackChooser = new BVideoPlaybackChooser();
        BOrdList ordList = playbackChooser.getAllCamerasUsingCache();
        return Arrays.stream(ordList.toArray()).map(eachOrd -> {
            try {
                BIVideoCamera camera = (BIVideoCamera)eachOrd.get((BObject)Sys.getStation(), cx);
                String displayName = BVideoDriverRpc.getCameraDisplayName(camera);
                BComponent comp = (BComponent)camera;
                return SlotPath.escape((String)displayName) + "|" + SlotPath.escape((String)comp.getSlotPath().toString());
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(input -> input != null).collect(Collectors.toList());
    }

    public static String getCameraDisplayName(BIVideoCamera camera) {
        String dvrDescription;
        String displayName = camera.getCameraDescription();
        BIVideoDvr videoCameraDvr = camera.getDvr();
        if (videoCameraDvr != null && (dvrDescription = videoCameraDvr.getDvrDescription()) != null) {
            if (dvrDescription.length() > 43) {
                dvrDescription = dvrDescription.substring(0, 40) + "...";
            }
            displayName = dvrDescription + " - " + displayName;
        }
        return displayName;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static JSONObject getCameraInfo(String ordString, Context cx) {
        BIVideoCamera camera = BVideoDriverRpc.resolveTo(ordString, BIVideoCamera.class, cx);
        return BVideoDriverRpc.getCameraInfo(camera, cx);
    }

    public static JSONObject getCameraInfo(BIVideoCamera camera, Context cx) {
        if (camera == null) {
            throw new IllegalArgumentException("camera required");
        }
        JSONObject obj = new JSONObject();
        boolean irisEnabled = false;
        boolean focusEnabled = false;
        boolean panTiltEnabled = false;
        boolean zoomEnabled = false;
        boolean isTimestampPreferred = false;
        boolean moveToPresetEnabled = false;
        boolean storePresetEnabled = false;
        String storePresetAction = "";
        String moveToPresetAction = "";
        long moveInterval = 1000L;
        long focusInterval = 1000L;
        long irisInterval = 1000L;
        long zoomInterval = 1000L;
        BDynamicEnum presetEnum = BDynamicEnum.DEFAULT;
        if (BVideoDriverRpc.hasAdminInvoke((BIObject)camera, cx)) {
            Action action;
            if (camera instanceof BIVideoIrisControl) {
                irisEnabled = ((BIVideoIrisControl)camera).isIrisEnabled();
            }
            if (camera instanceof BIVideoFocusControl) {
                focusEnabled = ((BIVideoFocusControl)camera).isFocusEnabled();
            }
            if (camera instanceof BIVideoPanTiltControl) {
                panTiltEnabled = ((BIVideoPanTiltControl)camera).isPanTiltEnabled();
            }
            if (camera instanceof BIVideoZoomControl) {
                zoomEnabled = ((BIVideoZoomControl)camera).isZoomEnabled();
            }
            if (camera instanceof BIVideoMoveToPresetControl) {
                moveToPresetEnabled = ((BIVideoMoveToPresetControl)camera).isMoveToPresetEnabled();
                action = ((BIVideoMoveToPresetControl)camera).getMoveToPresetAction();
                if (action != null) {
                    BValue argument;
                    moveToPresetAction = action.getName();
                    if (camera instanceof BComponent && (argument = ((BComponent)camera).getActionParameterDefault(action)) instanceof BDynamicEnum) {
                        presetEnum = (BDynamicEnum)argument;
                    }
                }
            }
            if (camera instanceof BIVideoStorePresetControl) {
                storePresetEnabled = ((BIVideoStorePresetControl)camera).isStorePresetEnabled();
                action = ((BIVideoStorePresetControl)camera).getStorePresetAction();
                if (action != null) {
                    storePresetAction = action.getName();
                }
            }
        }
        if (camera instanceof BIVideoSource) {
            isTimestampPreferred = ((BIVideoSource)camera).isTimestampPreferred();
        }
        if (camera instanceof BDevice) {
            BDevice device = (BDevice)camera;
            if (device.isFatalFault()) {
                throw new IllegalStateException(device.getFaultCause());
            }
            BVideoDvr videoDvr = null;
            for (BComplex parent = device.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BVideoDvr)) continue;
                videoDvr = (BVideoDvr)parent;
                break;
            }
            if (videoDvr != null && videoDvr.isFatalFault()) {
                throw new IllegalStateException(((BDevice)camera).getFaultCause());
            }
        }
        if (camera instanceof BVideoCamera) {
            BCameraControlTimings timings = ((BVideoCamera)camera).getControlTiming();
            moveInterval = timings.getMoveInterval().getMillis();
            focusInterval = timings.getFocusInterval().getMillis();
            irisInterval = timings.getIrisInterval().getMillis();
            zoomInterval = timings.getZoomInterval().getMillis();
        }
        obj.put("irisEnabled", irisEnabled);
        obj.put("focusEnabled", focusEnabled);
        obj.put("panTiltEnabled", panTiltEnabled);
        obj.put("zoomEnabled", zoomEnabled);
        obj.put("moveToPresetEnabled", moveToPresetEnabled);
        obj.put("storePresetEnabled", storePresetEnabled);
        obj.put("isTimestampPreferred", isTimestampPreferred);
        obj.put("moveToPresetAction", (Object)moveToPresetAction);
        obj.put("storePresetAction", (Object)storePresetAction);
        obj.put("displayName", (Object)camera.getCameraDescription());
        obj.put("moveInterval", moveInterval);
        obj.put("focusInterval", focusInterval);
        obj.put("irisInterval", irisInterval);
        obj.put("zoomInterval", zoomInterval);
        try {
            obj.put("presetEnum", (Object)presetEnum.encodeToString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return obj;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void focusControl(String ordString, String focusControlEnumString, Context cx) {
        BIVideoFocusControl camera = BVideoDriverRpc.resolveTo(ordString, BIVideoFocusControl.class, cx);
        BVideoDriverRpc.ensureAdminInvokePermissions((BIObject)camera, cx);
        if (!camera.isFocusEnabled()) {
            throw new IllegalStateException("Focus not enabled");
        }
        camera.focusControl(BVideoFocusEnum.make((String)focusControlEnumString));
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void irisControl(String ordString, String irisControlEnumString, Context cx) {
        BIVideoIrisControl camera = BVideoDriverRpc.resolveTo(ordString, BIVideoIrisControl.class, cx);
        BVideoDriverRpc.ensureAdminInvokePermissions((BIObject)camera, cx);
        if (!camera.isIrisEnabled()) {
            throw new IllegalStateException("Iris not enabled");
        }
        camera.irisControl(BVideoIrisEnum.make((String)irisControlEnumString));
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void move(String ordString, String panTiltControlEnumString, Context cx) {
        BIVideoPanTiltControl camera = BVideoDriverRpc.resolveTo(ordString, BIVideoPanTiltControl.class, cx);
        BVideoDriverRpc.ensureAdminInvokePermissions((BIObject)camera, cx);
        if (!camera.isPanTiltEnabled()) {
            throw new IllegalStateException("Pan/tilt not enabled");
        }
        camera.move(BVideoPanTiltEnum.make((String)panTiltControlEnumString));
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static void zoom(String ordString, String zoomControlEnumString, Context cx) {
        BIVideoZoomControl camera = BVideoDriverRpc.resolveTo(ordString, BIVideoZoomControl.class, cx);
        BVideoDriverRpc.ensureAdminInvokePermissions((BIObject)camera, cx);
        if (!camera.isZoomEnabled()) {
            throw new IllegalStateException("Zoom not enabled");
        }
        camera.zoom(BVideoZoomEnum.make((String)zoomControlEnumString));
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static JSONObject startHlsStream(String ordString, Context cx) {
        BOrd ord = BOrd.make((String)ordString);
        BComponent c = ord.get(null, cx).asComponent();
        String streamUrl = "";
        if (c instanceof BIBoxVideoStream) {
            streamUrl = ((BIBoxVideoStream)c).startLiveStream(c, cx);
        }
        JSONObject obj = new JSONObject();
        obj.put("streamUrl", (Object)streamUrl);
        return obj;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static void stopHlsStream(String ordString, Context cx) {
        BComponent c = BVideoDriverRpc.resolveTo(ordString, BComponent.class, cx);
        if (c instanceof BIBoxVideoStream) {
            ((BIBoxVideoStream)c).stopLiveStream(c, cx);
        }
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.web)})
    public static boolean isFoxVideoStreamPreferred(String ordString, Context cx) {
        BComponent c = BVideoDriverRpc.resolveTo(ordString, BComponent.class, cx);
        if (c instanceof BIVideoSource) {
            return ((BIVideoSource)c).isFoxVideoStreamPreferred();
        }
        return false;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box)})
    public static List<JSONObject> getCameraPlaybackEvents(String ordString, String epicenter, double eventFetchOffsetVector, Context cx) throws Exception {
        BOrd ord = BOrd.make((String)ordString);
        BIVideoEventProvider eventProvider = (BIVideoEventProvider)ord.get((BObject)Sys.getStation(), cx);
        return BVideoDriverRpc.getCameraPlaybackEvents(eventProvider, BAbsTime.make((String)epicenter), (int)eventFetchOffsetVector, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JSONObject> getCameraPlaybackEvents(BIVideoEventProvider eventProvider, BAbsTime epicenter, int eventFetchOffsetVector, Context cx) throws Exception {
        if (eventProvider == null) {
            throw new IllegalArgumentException("BIVideoEventProvider not found to retrieve events");
        }
        BVideoEventRecall eventRecall = eventProvider.getEventRecaller();
        BRetrieveActionParam retrieveActionParam = new BRetrieveActionParam();
        retrieveActionParam.setTimeIndex(epicenter);
        retrieveActionParam.setNumEvents(eventFetchOffsetVector);
        ArrayList eventJSONList = new ArrayList();
        RetrieveStatus status = new RetrieveStatus();
        Subscriber eventsSub = Subscriber.make(event -> {
            if (event.getId() == 5 && event.getSlotName().equals(BVideoEventRecall.retrieveOk.getName())) {
                RetrieveStatus retrieveStatus = status;
                synchronized (retrieveStatus) {
                    BVideoEvent[] events;
                    BRetrieveTopicEvent topicEvent = (BRetrieveTopicEvent)event.getValue();
                    for (BVideoEvent videoEvent : events = topicEvent.getEventsArray()) {
                        JSONObject eventJSON = new JSONObject();
                        eventJSON.put("timeIndex", (Object)videoEvent.getTimestamp().encodeToString());
                        eventJSON.put("description", (Object)videoEvent.getDescription());
                        eventJSONList.add(eventJSON);
                    }
                    status.markComplete();
                    status.notify();
                }
            }
            if (event.getId() == 5 && event.getSlotName().equals(BVideoEventRecall.retrieveFailed.getName())) {
                RetrieveStatus retrieveStatus = status;
                synchronized (retrieveStatus) {
                    BValue eventDataValue = event.getValue();
                    BRetrieveActionParam retrieveAction = (BRetrieveActionParam)eventDataValue;
                    status.markFailure(retrieveAction.getFaultCause().format(null, cx));
                    status.notify();
                }
            }
        });
        eventsSub.subscribe((BComponent)eventRecall);
        eventRecall.retrieveEvents(retrieveActionParam);
        try {
            Object object = status;
            synchronized (object) {
                if (!status.isComplete()) {
                    status.wait(VIDEO_EVENT_TIMEOUT_MILLIS);
                }
            }
            if (status.isFailure()) {
                throw new Exception(status.getErrorMessage());
            }
            if (status.isComplete()) {
                object = eventJSONList;
                return object;
            }
            try {
                throw new LocalizableException("videoDriver", "VideoPlaybackView.BrowseEventsCommand.Timeout");
            }
            catch (InterruptedException e) {
                throw new LocalizableException("videoDriver", "VideoPlaybackView.BrowseEventsCommand.Interrupted");
            }
        }
        finally {
            eventsSub.unsubscribeAll();
        }
    }

    private static <T extends BIObject> T resolveTo(String ord, Class<T> clazz, Context cx) {
        BObject obj = BOrd.make((String)ord).get(null, cx);
        if (!clazz.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("ORD does not point to a " + clazz);
        }
        return (T)obj.as(clazz);
    }

    private static void ensureAdminInvokePermissions(BIObject obj, Context cx) {
        if (!BVideoDriverRpc.hasAdminInvoke(obj, cx)) {
            throw new PermissionException("Admin invoke required");
        }
    }

    private static boolean hasAdminInvoke(BIObject obj, Context cx) {
        if (obj instanceof BIProtected) {
            return ((BIProtected)obj).getPermissions(cx).hasAdminInvoke();
        }
        return true;
    }

    private static class RetrieveStatus {
        private boolean complete = false;
        private boolean failure = false;
        private String errorMessage;

        public void markComplete() {
            this.complete = true;
        }

        public void markFailure(String msg) {
            this.complete = true;
            this.failure = true;
            this.errorMessage = msg;
        }

        public boolean isFailure() {
            return this.failure;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

