/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.demoData.history;

import com.tridium.demoData.history.BDemoFileHistoryExt;
import com.tridium.driver.file.util.CsvParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.baja.collection.AbstractCursor;
import javax.baja.file.BIFile;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Type;

public class CsvFileHistoryCursor
extends AbstractCursor<BTrendRecord> {
    private static final char ONE_CHAR = '\u0000';
    private BTrendRecord currentRecord;
    private String[][] fileContents;
    private SimpleDateFormat dateFormat;
    private Type valueType;
    private BAbsTime currentTime;
    private BRelTime collectionInterval;
    private int index;
    private int endIndex;
    private int timeCol;
    private int valCol;
    private int statusCol;
    private int idCol;
    private Pattern rowId;
    private boolean checkIdentifier;

    public CsvFileHistoryCursor(BIFile file, BDemoFileHistoryExt ext) throws Exception {
        this.currentRecord = (BTrendRecord)ext.getRecordType().getInstance();
        this.valueType = this.currentRecord.getValueProperty().getType();
        this.dateFormat = new SimpleDateFormat(ext.getTimestampFormat());
        this.currentTime = BAbsTime.make((int)2014, (BMonth)BMonth.january, (int)5, (int)0, (int)0, (int)0, (int)0);
        this.collectionInterval = ext.getInterval();
        this.index = ext.getRowStart();
        this.endIndex = 0;
        this.timeCol = ext.getTimestampColumnIndex();
        this.valCol = ext.getValueColumnIndex();
        this.statusCol = ext.getStatusColumnIndex();
        this.idCol = ext.getIdentifierColumnIndex();
        this.rowId = new Pattern(ext.getIdentifierPattern());
        this.checkIdentifier = this.idCol >= 0;
        InputStream in = null;
        BufferedReader fileReader = null;
        try {
            in = file.getInputStream();
            fileReader = new BufferedReader(new InputStreamReader(in));
            CsvParser parser = new CsvParser(fileReader);
            this.fileContents = parser.parseAll();
            this.endIndex = this.fileContents.length;
            if (ext.getRowEnd() >= 0) {
                this.endIndex = Math.min(this.endIndex, ext.getRowEnd() + 1);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean advanceCursor() {
        String valueString;
        String statusString;
        String timestampString;
        block14: {
            while (true) {
                if (this.index >= this.endIndex) {
                    this.currentRecord = null;
                    return false;
                }
                timestampString = null;
                statusString = null;
                if (!this.checkIdentifier) break;
                if (this.rowId.isMatch(this.fileContents[this.index][this.idCol])) {
                    if (this.timeCol >= 0) {
                        timestampString = this.fileContents[this.index][this.timeCol];
                    }
                    valueString = this.fileContents[this.index][this.valCol];
                    if (this.statusCol >= 0) {
                        statusString = this.fileContents[this.index][this.statusCol];
                    }
                    break block14;
                }
                ++this.index;
            }
            if (this.timeCol >= 0) {
                timestampString = this.fileContents[this.index][this.timeCol];
            }
            valueString = this.fileContents[this.index][this.valCol];
            if (this.statusCol >= 0) {
                statusString = this.fileContents[this.index][this.statusCol];
            }
        }
        BAbsTime tstamp = this.timeCol >= 0 && timestampString != null ? BAbsTime.make((long)this.dateFormat.parse(timestampString, new ParsePosition(0)).getTime()) : this.currentTime;
        BStatus status = BStatus.ok;
        if (this.statusCol >= 0 && statusString != null) {
            status = BStatus.make((int)Integer.parseInt(statusString));
        }
        if (this.valueType.is(BINumeric.TYPE)) {
            ((BNumericTrendRecord)this.currentRecord).set(tstamp, Double.valueOf(valueString).doubleValue(), status);
        } else if (this.valueType.is(BIBoolean.TYPE)) {
            boolean boolVal;
            try {
                boolVal = Integer.valueOf(valueString) != 0;
            }
            catch (Exception e) {
                boolVal = Boolean.valueOf(valueString);
            }
            ((BBooleanTrendRecord)this.currentRecord).set(tstamp, boolVal, status);
        } else {
            ((BStringTrendRecord)this.currentRecord).set(tstamp, valueString, status);
        }
        this.currentTime = this.currentTime.add(this.collectionInterval);
        ++this.index;
        return true;
    }

    protected BTrendRecord doGet() {
        return this.currentRecord;
    }

    static class Pattern {
        private char[][] pattern;
        private boolean matchAll;

        public Pattern(String patternString) {
            this.init(patternString.toCharArray());
        }

        private void init(char[] patternStr) {
            this.matchAll = true;
            for (int i = 0; i < patternStr.length; ++i) {
                if (patternStr[i] == '*' || patternStr[i] == '%') continue;
                this.matchAll = false;
                break;
            }
            if (this.matchAll) {
                return;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            StringBuilder buf = new StringBuilder(16);
            while (true) {
                if (i == patternStr.length) {
                    if (buf.length() <= 0) break;
                    v.addElement(buf.toString());
                    break;
                }
                if (patternStr[i] == '\\') {
                    if (buf.length() == 0) {
                        buf.append(' ');
                    }
                    if (i < patternStr.length - 1) {
                        char next = patternStr[i + 1];
                        if (next == '%' || next == '*' || next == '_' || next == '\\') {
                            buf.append(next);
                        } else if (next == 'n') {
                            buf.append('\n');
                        } else if (next == 'r') {
                            buf.append('\r');
                        } else if (next == 't') {
                            buf.append('\t');
                        } else {
                            throw new IllegalArgumentException("Invalid escape sequence: \\" + next);
                        }
                        i += 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid escape sequence: \\");
                }
                if (patternStr[i] == '%' || patternStr[i] == '*' || patternStr[i] == '_') {
                    if (patternStr[i] == '_') {
                        if (buf.length() == 0) {
                            buf.append(' ');
                        }
                        buf.append('\u0000');
                        ++i;
                        continue;
                    }
                    if (buf.length() > 0) {
                        v.addElement(buf.toString());
                    }
                    v.addElement("*");
                    while (i < patternStr.length && (patternStr[i] == '%' || patternStr[i] == '*')) {
                        ++i;
                    }
                    buf.setLength(0);
                    continue;
                }
                if (buf.length() == 0) {
                    buf.append(' ');
                }
                buf.append(patternStr[i++]);
            }
            this.pattern = new char[v.size()][];
            for (int j = 0; j < v.size(); ++j) {
                this.pattern[j] = ((String)v.elementAt(j)).toCharArray();
            }
        }

        public boolean isMatch(String testStr) {
            if (this.matchAll) {
                return true;
            }
            char[] test = testStr.toCharArray();
            int ti = 0;
            int len = test.length;
            if (len == 0) {
                return this.pattern.length == 0;
            }
            boolean afterWildcard = false;
            block0: for (int pi = 0; pi < this.pattern.length; ++pi) {
                if (this.pattern[pi][0] == '*') {
                    if (pi == this.pattern.length - 1) {
                        return true;
                    }
                    afterWildcard = true;
                    continue;
                }
                while (ti < len) {
                    int ei;
                    int start = ti;
                    for (ei = 1; ti < len && ei < this.pattern[pi].length && (this.pattern[pi][ei] == '\u0000' || this.pattern[pi][ei] == test[ti]); ++ti, ++ei) {
                    }
                    if (ei == this.pattern[pi].length) {
                        if (pi == this.pattern.length - 1) {
                            if (ti == len) {
                                return true;
                            }
                            if (afterWildcard) {
                                ti = len - (this.pattern[pi].length - 1);
                                continue;
                            }
                            return false;
                        }
                        afterWildcard = false;
                        continue block0;
                    }
                    if (ti == len) {
                        return false;
                    }
                    if (!afterWildcard) {
                        return false;
                    }
                    ti = start + 1;
                    if (ti != len) continue;
                    return false;
                }
            }
            return false;
        }
    }
}

