/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.demoData.history;

import com.tridium.demoData.history.BDemoFileHistoryExt;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.history.BHistoryDeviceExt;
import javax.baja.driver.history.BHistoryExport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="state", type="BDescriptorState", defaultValue="BDescriptorState.idle", flags=67), @NiagaraProperty(name="demoGenerationStatus", type="String", defaultValue="", flags=67), @NiagaraProperty(name="ordToRdbms", type="BOrd", defaultValue="BOrd.DEFAULT", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"rdb:Rdbms\")")}), @NiagaraProperty(name="numDemoPointsToGenerate", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="generatedPointNamePrefix", type="String", defaultValue="DemoPoint_"), @NiagaraProperty(name="generatedPointNameStartingIndex", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0"), @Facet(name="BFacets.MAX", value="Integer.MAX_VALUE")}), @NiagaraProperty(name="ordToContainerOfGeneratedPoints", type="BOrd", defaultValue="BOrd.make(\"slot:\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:Component\")")}), @NiagaraProperty(name="exportGeneratedPointHistoriesToRdbms", type="boolean", defaultValue="true"), @NiagaraProperty(name="maxConcurrentGenerations", type="int", defaultValue="20", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="50")}), @NiagaraProperty(name="capacityOfLocalHistoryAfterRdbmsArchive", type="BCapacity", defaultValue="BCapacity.makeByRecordCount(500)"), @NiagaraProperty(name="deleteRdbmsHistoryExportAfterRdbmsArchive", type="boolean", defaultValue="true"), @NiagaraProperty(name="demoPointPrototype", type="BUnrestrictedFolder", defaultValue="makeDefaultDemoPointPrototypeFolder()"), @NiagaraProperty(name="useSqlServerBulkCopy", type="boolean", defaultValue="false"), @NiagaraProperty(name="bulkCopyDataFile", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"baja:IFile\"")})})
@NiagaraActions(value={@NiagaraAction(name="generateDemoPointsAndArchiveToRdbms", flags=16), @NiagaraAction(name="interruptDemoDataGeneration", flags=128), @NiagaraAction(name="processIndividualDemoPoint", parameterType="BString", defaultValue="BString.DEFAULT", flags=20)})
public final class BRdbmsDemoDataGenerator
extends BComponent {
    @Generated
    public static final Property state = BRdbmsDemoDataGenerator.newProperty((int)67, (BValue)BDescriptorState.idle, null);
    @Generated
    public static final Property demoGenerationStatus = BRdbmsDemoDataGenerator.newProperty((int)67, (String)"", null);
    @Generated
    public static final Property ordToRdbms = BRdbmsDemoDataGenerator.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"rdb:Rdbms")));
    @Generated
    public static final Property numDemoPointsToGenerate = BRdbmsDemoDataGenerator.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property generatedPointNamePrefix = BRdbmsDemoDataGenerator.newProperty((int)0, (String)"DemoPoint_", null);
    @Generated
    public static final Property generatedPointNameStartingIndex = BRdbmsDemoDataGenerator.newProperty((int)0, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)0), (BFacets)BFacets.make((String)"max", (int)Integer.MAX_VALUE)));
    @Generated
    public static final Property ordToContainerOfGeneratedPoints = BRdbmsDemoDataGenerator.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:Component")));
    @Generated
    public static final Property exportGeneratedPointHistoriesToRdbms = BRdbmsDemoDataGenerator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property maxConcurrentGenerations = BRdbmsDemoDataGenerator.newProperty((int)0, (int)20, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)50)));
    @Generated
    public static final Property capacityOfLocalHistoryAfterRdbmsArchive = BRdbmsDemoDataGenerator.newProperty((int)0, (BValue)BCapacity.makeByRecordCount((int)500), null);
    @Generated
    public static final Property deleteRdbmsHistoryExportAfterRdbmsArchive = BRdbmsDemoDataGenerator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property demoPointPrototype = BRdbmsDemoDataGenerator.newProperty((int)0, (BValue)BRdbmsDemoDataGenerator.makeDefaultDemoPointPrototypeFolder(), null);
    @Generated
    public static final Property useSqlServerBulkCopy = BRdbmsDemoDataGenerator.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property bulkCopyDataFile = BRdbmsDemoDataGenerator.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    @Generated
    public static final Action generateDemoPointsAndArchiveToRdbms = BRdbmsDemoDataGenerator.newAction((int)16, null);
    @Generated
    public static final Action interruptDemoDataGeneration = BRdbmsDemoDataGenerator.newAction((int)128, null);
    @Generated
    public static final Action processIndividualDemoPoint = BRdbmsDemoDataGenerator.newAction((int)20, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsDemoDataGenerator.class);
    private static final Logger LOG = Logger.getLogger("demoData.rdbms");
    private static final Lexicon LEX = Lexicon.make((String)"demoData");
    private static final String LICENSE_EXPIRED = LEX.get("demoStation.expired");
    private static final String NOT_LICENSED = LEX.get("demoStation.notLicensed");
    private static final String STARTING_GENERATION = LEX.get("demoGenerator.starting");
    private static final String MISCONFIGURED_ORDS = LEX.get("demoGenerator.misconfiguredOrds");
    private Queue workerQueue;
    private ThreadPoolWorker worker;
    private boolean fatalFault;
    private final AtomicBoolean isGenerating = new AtomicBoolean();
    private CountDownLatch workCompleteSignal;
    private final Set<String> failedGenerations = ConcurrentHashMap.newKeySet();
    private long generationStartTicks;

    @Generated
    public BDescriptorState getState() {
        return (BDescriptorState)this.get(state);
    }

    @Generated
    public void setState(BDescriptorState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public String getDemoGenerationStatus() {
        return this.getString(demoGenerationStatus);
    }

    @Generated
    public void setDemoGenerationStatus(String v) {
        this.setString(demoGenerationStatus, v, null);
    }

    @Generated
    public BOrd getOrdToRdbms() {
        return (BOrd)this.get(ordToRdbms);
    }

    @Generated
    public void setOrdToRdbms(BOrd v) {
        this.set(ordToRdbms, (BValue)v, null);
    }

    @Generated
    public int getNumDemoPointsToGenerate() {
        return this.getInt(numDemoPointsToGenerate);
    }

    @Generated
    public void setNumDemoPointsToGenerate(int v) {
        this.setInt(numDemoPointsToGenerate, v, null);
    }

    @Generated
    public String getGeneratedPointNamePrefix() {
        return this.getString(generatedPointNamePrefix);
    }

    @Generated
    public void setGeneratedPointNamePrefix(String v) {
        this.setString(generatedPointNamePrefix, v, null);
    }

    @Generated
    public int getGeneratedPointNameStartingIndex() {
        return this.getInt(generatedPointNameStartingIndex);
    }

    @Generated
    public void setGeneratedPointNameStartingIndex(int v) {
        this.setInt(generatedPointNameStartingIndex, v, null);
    }

    @Generated
    public BOrd getOrdToContainerOfGeneratedPoints() {
        return (BOrd)this.get(ordToContainerOfGeneratedPoints);
    }

    @Generated
    public void setOrdToContainerOfGeneratedPoints(BOrd v) {
        this.set(ordToContainerOfGeneratedPoints, (BValue)v, null);
    }

    @Generated
    public boolean getExportGeneratedPointHistoriesToRdbms() {
        return this.getBoolean(exportGeneratedPointHistoriesToRdbms);
    }

    @Generated
    public void setExportGeneratedPointHistoriesToRdbms(boolean v) {
        this.setBoolean(exportGeneratedPointHistoriesToRdbms, v, null);
    }

    @Generated
    public int getMaxConcurrentGenerations() {
        return this.getInt(maxConcurrentGenerations);
    }

    @Generated
    public void setMaxConcurrentGenerations(int v) {
        this.setInt(maxConcurrentGenerations, v, null);
    }

    @Generated
    public BCapacity getCapacityOfLocalHistoryAfterRdbmsArchive() {
        return (BCapacity)this.get(capacityOfLocalHistoryAfterRdbmsArchive);
    }

    @Generated
    public void setCapacityOfLocalHistoryAfterRdbmsArchive(BCapacity v) {
        this.set(capacityOfLocalHistoryAfterRdbmsArchive, (BValue)v, null);
    }

    @Generated
    public boolean getDeleteRdbmsHistoryExportAfterRdbmsArchive() {
        return this.getBoolean(deleteRdbmsHistoryExportAfterRdbmsArchive);
    }

    @Generated
    public void setDeleteRdbmsHistoryExportAfterRdbmsArchive(boolean v) {
        this.setBoolean(deleteRdbmsHistoryExportAfterRdbmsArchive, v, null);
    }

    @Generated
    public BUnrestrictedFolder getDemoPointPrototype() {
        return (BUnrestrictedFolder)this.get(demoPointPrototype);
    }

    @Generated
    public void setDemoPointPrototype(BUnrestrictedFolder v) {
        this.set(demoPointPrototype, (BValue)v, null);
    }

    @Generated
    public boolean getUseSqlServerBulkCopy() {
        return this.getBoolean(useSqlServerBulkCopy);
    }

    @Generated
    public void setUseSqlServerBulkCopy(boolean v) {
        this.setBoolean(useSqlServerBulkCopy, v, null);
    }

    @Generated
    public BOrd getBulkCopyDataFile() {
        return (BOrd)this.get(bulkCopyDataFile);
    }

    @Generated
    public void setBulkCopyDataFile(BOrd v) {
        this.set(bulkCopyDataFile, (BValue)v, null);
    }

    @Generated
    public void generateDemoPointsAndArchiveToRdbms() {
        this.invoke(generateDemoPointsAndArchiveToRdbms, null, null);
    }

    @Generated
    public void interruptDemoDataGeneration() {
        this.invoke(interruptDemoDataGeneration, null, null);
    }

    @Generated
    public void processIndividualDemoPoint(BString parameter) {
        this.invoke(processIndividualDemoPoint, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        String fatalFaultCause = "";
        this.fatalFault = false;
        Feature demoStationFeature = Sys.getLicenseManager().getFeature("tridium", "demoStation");
        if (demoStationFeature == null || demoStationFeature.isExpired()) {
            this.fatalFault = true;
            fatalFaultCause = demoStationFeature != null ? LICENSE_EXPIRED : NOT_LICENSED;
        } else {
            if (this.worker == null || this.workerQueue == null) {
                this.workerQueue = new Queue();
                this.worker = new ThreadPoolWorker((Worker.ITodo)this.workerQueue);
            }
            if (!this.worker.isRunning()) {
                int maxThreads = this.getMaxConcurrentGenerations();
                if (maxThreads != Integer.MAX_VALUE) {
                    ++maxThreads;
                }
                this.worker.setMaxThreads(maxThreads);
                this.worker.start("RdbmsDemoData_" + this.getHandle() + "_Worker");
            }
        }
        this.setDemoGenerationStatus(fatalFaultCause);
    }

    public void stopped() throws Exception {
        if (this.worker != null && this.worker.isRunning()) {
            this.worker.stop();
            this.workerQueue.clear();
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (this.isUnoperational()) {
            return null;
        }
        if (action.equals(generateDemoPointsAndArchiveToRdbms)) {
            if (this.getState() != BDescriptorState.idle || this.workCompleteSignal != null) {
                return null;
            }
            this.setState(BDescriptorState.pending);
        }
        this.workerQueue.enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public void changed(Property p, Context c) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(maxConcurrentGenerations) && this.worker != null) {
            int maxThreads = this.getMaxConcurrentGenerations();
            if (maxThreads != Integer.MAX_VALUE) {
                ++maxThreads;
            }
            this.worker.setMaxThreads(maxThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerateDemoPointsAndArchiveToRdbms(Context cx) {
        try {
            int numPoints;
            if (this.isUnoperational()) {
                return;
            }
            this.isGenerating.set(true);
            this.setState(BDescriptorState.inProgress);
            this.setDemoGenerationStatus(STARTING_GENERATION);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Starting demo data generation at: " + BAbsTime.now());
            }
            this.generationStartTicks = Clock.ticks();
            this.getDemoPointContainer(cx);
            if (this.getExportGeneratedPointHistoriesToRdbms()) {
                this.getRdbms(cx);
            }
            if ((numPoints = this.getNumDemoPointsToGenerate()) > 0) {
                this.workCompleteSignal = new CountDownLatch(numPoints);
                this.failedGenerations.clear();
                String pointNamePrefix = SlotPath.escape((String)this.getGeneratedPointNamePrefix());
                int startingIdx = this.getGeneratedPointNameStartingIndex();
                for (int i = 0; i < numPoints; ++i) {
                    this.invoke(processIndividualDemoPoint, (BValue)BString.make((String)(pointNamePrefix + (startingIdx + i))), cx);
                }
                this.workCompleteSignal.await();
            }
            if (this.isGenerating.get()) {
                int failures = this.failedGenerations.size();
                String msg = LEX.getText("demoGenerator.complete", new Object[]{numPoints - failures, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()});
                this.setDemoGenerationStatus(msg);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, msg);
                }
                if (!this.failedGenerations.isEmpty() && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "The following demo points failed generation: " + this.failedGenerations);
                }
            }
        }
        catch (ClassCastException | IllegalStateException | UnresolvedException | PermissionException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Container Of Generated Points or RDBMS is not usable", e);
            }
            this.setDemoGenerationStatus(MISCONFIGURED_ORDS);
        }
        catch (InterruptedException ie) {
            int numPoints = this.getNumDemoPointsToGenerate();
            int failures = this.failedGenerations.size();
            long remainingPoints = this.workCompleteSignal != null ? this.workCompleteSignal.getCount() : (long)numPoints;
            String msg = LEX.getText("demoGenerator.interrupted", new Object[]{(long)numPoints - remainingPoints - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()});
            this.setDemoGenerationStatus(msg);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, msg, ie);
            }
            if (failures > 0 && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "The following demo points failed generation before interruption: " + this.failedGenerations);
            }
        }
        finally {
            this.isGenerating.set(false);
            this.workCompleteSignal = null;
            this.failedGenerations.clear();
            this.generationStartTicks = 0L;
            this.setState(BDescriptorState.idle);
        }
    }

    public void doInterruptDemoDataGeneration(Context cx) {
        this.isGenerating.set(false);
        if (!this.isUnoperational()) {
            int failures = this.failedGenerations.size();
            int numPoints = this.getNumDemoPointsToGenerate();
            long remainingPoints = this.workCompleteSignal != null ? this.workCompleteSignal.getCount() : (long)numPoints;
            String msg = LEX.getText("demoGenerator.interrupted", new Object[]{(long)numPoints - remainingPoints - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()});
            this.setDemoGenerationStatus(msg);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, msg);
            }
            if (failures > 0 && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "The following demo points failed generation before interruption: " + this.failedGenerations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doProcessIndividualDemoPoint(BString pointName, Context cx) {
        block66: {
            BComponent rdbms;
            BDemoFileHistoryExt demoExt;
            String demoPointName;
            long start;
            boolean failedGeneration;
            block62: {
                block63: {
                    BControlPoint demoPoint;
                    BComponent target;
                    block60: {
                        block61: {
                            block58: {
                                block59: {
                                    BControlPoint[] prototypeChildren;
                                    block56: {
                                        block57: {
                                            failedGeneration = false;
                                            if (!this.isUnoperational() && this.isGenerating.get()) break block56;
                                            if (this.workCompleteSignal == null) return;
                                            if (!failedGeneration) break block57;
                                            this.failedGenerations.add(pointName.getString());
                                        }
                                        int failures = this.failedGenerations.size();
                                        this.workCompleteSignal.countDown();
                                        if (this.isUnoperational() || !this.isGenerating.get()) return;
                                        int numPoints = this.getNumDemoPointsToGenerate();
                                        this.setDemoGenerationStatus(LEX.getText("demoGenerator.progress", new Object[]{(long)numPoints - this.workCompleteSignal.getCount() - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()}));
                                        return;
                                    }
                                    start = Clock.ticks();
                                    target = this.getDemoPointContainer(cx);
                                    demoPointName = pointName.getString();
                                    if (target.getProperty(demoPointName) != null) {
                                        target.remove(demoPointName);
                                    }
                                    if ((prototypeChildren = (BControlPoint[])this.getDemoPointPrototype().getChildren(BControlPoint.class)) != null && prototypeChildren.length > 0) {
                                        demoPoint = (BControlPoint)prototypeChildren[0].newCopy(true);
                                        break block58;
                                    }
                                    if (LOG.isLoggable(Level.FINER)) {
                                        LOG.log(Level.FINER, "No prototype demo point is available for generation. Generation skipped.");
                                    }
                                    if (this.workCompleteSignal == null) return;
                                    if (!failedGeneration) break block59;
                                    this.failedGenerations.add(pointName.getString());
                                }
                                int failures = this.failedGenerations.size();
                                this.workCompleteSignal.countDown();
                                if (this.isUnoperational() || !this.isGenerating.get()) return;
                                int numPoints = this.getNumDemoPointsToGenerate();
                                this.setDemoGenerationStatus(LEX.getText("demoGenerator.progress", new Object[]{(long)numPoints - this.workCompleteSignal.getCount() - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()}));
                                return;
                            }
                            BDemoFileHistoryExt[] demoExts = (BDemoFileHistoryExt[])demoPoint.getChildren(BDemoFileHistoryExt.class);
                            if (demoExts != null && demoExts.length > 0) {
                                demoExt = demoExts[0];
                                break block60;
                            }
                            if (LOG.isLoggable(Level.FINER)) {
                                LOG.log(Level.FINER, "The prototype demo point is missing a DemoFileHistoryExt. Generation skipped.");
                            }
                            if (this.workCompleteSignal == null) return;
                            if (!failedGeneration) break block61;
                            this.failedGenerations.add(pointName.getString());
                        }
                        int failures = this.failedGenerations.size();
                        this.workCompleteSignal.countDown();
                        if (this.isUnoperational() || !this.isGenerating.get()) return;
                        int numPoints = this.getNumDemoPointsToGenerate();
                        this.setDemoGenerationStatus(LEX.getText("demoGenerator.progress", new Object[]{(long)numPoints - this.workCompleteSignal.getCount() - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()}));
                        return;
                    }
                    rdbms = null;
                    if (this.getExportGeneratedPointHistoriesToRdbms()) {
                        rdbms = this.getRdbms(cx);
                    }
                    demoExt.rdbmsDemoMode.set(rdbms != null);
                    if (rdbms == null) {
                        demoExt.getHistoryConfig().setCapacity(this.getCapacityOfLocalHistoryAfterRdbmsArchive());
                    } else if (this.getUseSqlServerBulkCopy()) {
                        demoExt.getHistoryConfig().setCapacity(BCapacity.makeByRecordCount((int)0));
                    }
                    target.add(demoPointName, (BValue)demoPoint);
                    demoExt.setEnabled(true);
                    if (!this.getUseSqlServerBulkCopy()) {
                        demoExt.doRegenerateHistoricalData();
                    }
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.log(Level.FINER, "Created demo point and history named '" + pointName + "' in " + BRelTime.make((long)(Clock.ticks() - start)).toString());
                    }
                    if (this.isGenerating.get()) break block62;
                    demoExt.rdbmsDemoMode.set(false);
                    demoExt.getHistoryConfig().setCapacity(this.getCapacityOfLocalHistoryAfterRdbmsArchive());
                    if (this.getUseSqlServerBulkCopy()) {
                        demoExt.regenerateHistoricalData();
                    }
                    if (this.workCompleteSignal == null) return;
                    if (!failedGeneration) break block63;
                    this.failedGenerations.add(pointName.getString());
                }
                int failures = this.failedGenerations.size();
                this.workCompleteSignal.countDown();
                if (this.isUnoperational() || !this.isGenerating.get()) return;
                int numPoints = this.getNumDemoPointsToGenerate();
                this.setDemoGenerationStatus(LEX.getText("demoGenerator.progress", new Object[]{(long)numPoints - this.workCompleteSignal.getCount() - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()}));
                return;
            }
            try {
                block64: {
                    block65: {
                        String historyExportName;
                        if (rdbms == null) break block64;
                        start = Clock.ticks();
                        BHistoryDeviceExt historyDeviceExt = (BHistoryDeviceExt)rdbms.get("histories");
                        BHistoryExport historyExport = (BHistoryExport)historyDeviceExt.get(historyExportName = demoPointName + "_DemoRdbmsHistoryExport");
                        if (historyExport == null) {
                            historyExport = (BHistoryExport)historyDeviceExt.getExportDescriptorType().getInstance();
                            historyDeviceExt.add(historyExportName, (BValue)historyExport);
                        }
                        historyExport.setHistoryId(demoExt.getHistoryConfig().getId());
                        historyExport.setExecutionTime(new BTimeTrigger((BTriggerMode)BManualTriggerMode.DEFAULT));
                        historyExport.setEnabled(true);
                        historyExport.doExecute();
                        if (historyExport.isFault()) {
                            failedGeneration = true;
                        }
                        File dataFile = null;
                        Class<?> bulkCsvClass = null;
                        Object bulkCsvFile = null;
                        Class<?> bulkCopyClass = null;
                        Object bulkCopy = null;
                        try {
                            String filePath;
                            if (!this.getUseSqlServerBulkCopy()) break block65;
                            if (!BAbsTime.NULL.equals((Object)historyExport.get("lastTimestamp"))) {
                                throw new IllegalStateException("Bulk Copy not allowed when previous exported data exists for history");
                            }
                            if (((BEnum)rdbms.get("exportMode")).getOrdinal() == 1) {
                                dataFile = this.generateDataFile(demoPointName, demoExt.getHistoryConfig().getId().encodeToString());
                                filePath = dataFile.getCanonicalPath();
                            } else {
                                File localFile = BFileSystem.INSTANCE.pathToLocalFile(((BIFile)this.getBulkCopyDataFile().get((BObject)this)).getFilePath());
                                filePath = localFile.getCanonicalPath();
                            }
                            bulkCsvClass = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord");
                            bulkCsvFile = bulkCsvClass.getDeclaredConstructor(String.class, Boolean.TYPE).newInstance(filePath, false);
                            Class rdbmsClass = RdbmsTypeHolder.RDBMS_TYPE.getTypeClass();
                            String historyTableName = (String)RdbmsTypeHolder.RDB_ARCHIVE_HISTORY_PROVIDER_CLASS.getDeclaredMethod("getArchiveHistoryTableName", rdbmsClass, BHistoryConfig.class).invoke(null, rdbms, demoExt.getHistoryConfig());
                            try (Connection conn = (Connection)rdbmsClass.getDeclaredMethod("getConnection", new Class[0]).invoke((Object)rdbms, new Object[0]);){
                                conn.setAutoCommit(false);
                                DatabaseMetaData metadata = conn.getMetaData();
                                ResultSet resultSet = metadata.getColumns(null, null, historyTableName, null);
                                int idx = 1;
                                Method addColMeta = bulkCsvClass.getDeclaredMethod("addColumnMetadata", Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                                while (resultSet.next()) {
                                    addColMeta.invoke(bulkCsvFile, idx++, resultSet.getString("COLUMN_NAME"), resultSet.getInt("DATA_TYPE"), 0, 0);
                                }
                                bulkCopyClass = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerBulkCopy");
                                bulkCopy = bulkCopyClass.getDeclaredConstructor(Connection.class).newInstance((Connection)conn.unwrap(Class.forName("com.microsoft.sqlserver.jdbc.SQLServerConnection")));
                                bulkCopyClass.getDeclaredMethod("setDestinationTableName", String.class).invoke(bulkCopy, historyTableName);
                                bulkCopyClass.getDeclaredMethod("writeToServer", Class.forName("com.microsoft.sqlserver.jdbc.ISQLServerBulkData")).invoke(bulkCopy, bulkCsvFile);
                                bulkCsvClass.getDeclaredMethod("close", new Class[0]).invoke(bulkCsvFile, new Object[0]);
                                bulkCsvFile = null;
                                bulkCopyClass.getDeclaredMethod("close", new Class[0]).invoke(bulkCopy, new Object[0]);
                                bulkCopy = null;
                                conn.commit();
                            }
                        }
                        finally {
                            if (this.getDeleteRdbmsHistoryExportAfterRdbmsArchive()) {
                                historyDeviceExt.remove((BComplex)historyExport);
                            }
                            if (bulkCsvFile != null) {
                                bulkCsvClass.getDeclaredMethod("close", new Class[0]).invoke(bulkCsvFile, new Object[0]);
                            }
                            if (bulkCopy != null) {
                                bulkCopyClass.getDeclaredMethod("close", new Class[0]).invoke(bulkCopy, new Object[0]);
                            }
                            if (dataFile != null) {
                                for (int k = 0; k < 20 && !dataFile.delete(); ++k) {
                                    Thread.sleep(500L);
                                }
                            }
                        }
                    }
                    if (LOG.isLoggable(Level.FINER)) {
                        if (failedGeneration) {
                            LOG.log(Level.FINER, "Failed to export history to RDBMS for demo point named '" + pointName + "' in " + BRelTime.make((long)(Clock.ticks() - start)).toString());
                        } else {
                            LOG.log(Level.FINER, "Exported history to RDBMS for demo point named '" + pointName + "' in " + BRelTime.make((long)(Clock.ticks() - start)).toString());
                        }
                    }
                    break block64;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    finally {
                        demoExt.rdbmsDemoMode.set(false);
                        demoExt.getHistoryConfig().setCapacity(this.getCapacityOfLocalHistoryAfterRdbmsArchive());
                        if (this.getUseSqlServerBulkCopy()) {
                            demoExt.regenerateHistoricalData();
                        }
                    }
                }
                if (this.workCompleteSignal == null) return;
                if (!failedGeneration) break block66;
                this.failedGenerations.add(pointName.getString());
            }
            catch (Exception e) {
                block67: {
                    try {
                        failedGeneration = true;
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "Failed to generate demo point: " + pointName, e);
                        }
                        if (this.workCompleteSignal == null) return;
                        if (!failedGeneration) break block67;
                        this.failedGenerations.add(pointName.getString());
                    }
                    catch (Throwable throwable) {
                        if (this.workCompleteSignal == null) throw throwable;
                        if (failedGeneration) {
                            this.failedGenerations.add(pointName.getString());
                        }
                        int failures = this.failedGenerations.size();
                        this.workCompleteSignal.countDown();
                        if (this.isUnoperational() || !this.isGenerating.get()) throw throwable;
                        int numPoints = this.getNumDemoPointsToGenerate();
                        this.setDemoGenerationStatus(LEX.getText("demoGenerator.progress", new Object[]{(long)numPoints - this.workCompleteSignal.getCount() - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()}));
                        throw throwable;
                    }
                }
                int failures = this.failedGenerations.size();
                this.workCompleteSignal.countDown();
                if (this.isUnoperational() || !this.isGenerating.get()) return;
                int numPoints = this.getNumDemoPointsToGenerate();
                this.setDemoGenerationStatus(LEX.getText("demoGenerator.progress", new Object[]{(long)numPoints - this.workCompleteSignal.getCount() - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()}));
                return;
            }
        }
        int failures = this.failedGenerations.size();
        this.workCompleteSignal.countDown();
        if (this.isUnoperational() || !this.isGenerating.get()) return;
        int numPoints = this.getNumDemoPointsToGenerate();
        this.setDemoGenerationStatus(LEX.getText("demoGenerator.progress", new Object[]{(long)numPoints - this.workCompleteSignal.getCount() - (long)failures, numPoints, failures, BRelTime.make((long)(Clock.ticks() - this.generationStartTicks)).toString()}));
        return;
    }

    private static BUnrestrictedFolder makeDefaultDemoPointPrototypeFolder() {
        BUnrestrictedFolder folder = new BUnrestrictedFolder();
        BNumericWritable point = new BNumericWritable();
        folder.add("DemoConsumptionPoint_kWh", (BValue)point);
        point.setFacets(BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"kilowatt hour"), (int)1));
        BDemoFileHistoryExt demoExt = new BDemoFileHistoryExt();
        point.add("DemoFileHistoryExt", (BValue)demoExt);
        demoExt.setEnabled(false);
        demoExt.setHistoryStartDate(BDate.make((int)(BAbsTime.now().getYear() - 5), (BMonth)BMonth.january, (int)1));
        demoExt.getHistoryConfig().setCapacity(BCapacity.UNLIMITED);
        demoExt.setTemplateFile(BOrd.make((String)"module://demoData/rc/ConsumptionTemplate.csv"));
        return folder;
    }

    private File generateDataFile(String demoPointName, String historyId) throws IOException {
        File templateFile = BFileSystem.INSTANCE.pathToLocalFile(((BIFile)this.getBulkCopyDataFile().get((BObject)this)).getFilePath());
        Path templatePath = Paths.get(templateFile.getCanonicalPath(), new String[0]);
        FilePath dataFilePath = new FilePath("^tempDataFile_" + demoPointName + ".csv");
        BFileSystem.INSTANCE.makeFile(dataFilePath, null);
        File dataFile = BFileSystem.INSTANCE.pathToLocalFile(dataFilePath);
        Path dataPath = Paths.get(dataFile.getCanonicalPath(), new String[0]);
        Stream<String> lines = Files.lines(templatePath).map(line -> line.replaceAll("\\?", historyId));
        Files.write(dataPath, lines::iterator, new OpenOption[0]);
        lines.close();
        return dataFile;
    }

    private boolean isUnoperational() {
        return !this.isRunning() || this.fatalFault || this.worker == null || this.workerQueue == null || !this.worker.isRunning();
    }

    private BComponent getDemoPointContainer(Context cx) {
        BComponent target = this.getOrdToContainerOfGeneratedPoints().get((BObject)this, cx).asComponent();
        if (cx != null && cx.getUser() != null) {
            cx.getUser().check((BIProtected)target, BPermissions.adminWrite);
        }
        return target;
    }

    private BComponent getRdbms(Context cx) {
        BComponent rdbms = this.getOrdToRdbms().get((BObject)this, cx).asComponent();
        if (cx != null && cx.getUser() != null) {
            cx.getUser().check((BIProtected)rdbms, BPermissions.adminWrite);
        }
        if (RdbmsTypeHolder.RDBMS_TYPE == null || !rdbms.getType().is(RdbmsTypeHolder.RDBMS_TYPE)) {
            throw new IllegalStateException("Configured ORD to RDBMS does not resolve to a valid type: " + rdbms.getType());
        }
        BDevice rdbmsDevice = (BDevice)rdbms;
        if (rdbmsDevice.isDisabled() || rdbmsDevice.isDown() || rdbmsDevice.isFault()) {
            throw new IllegalStateException("Configured RDBMS is not available: " + rdbmsDevice.getStatus());
        }
        return rdbms;
    }

    private static final class RdbmsTypeHolder {
        public static final Type RDBMS_TYPE;
        public static final Class<?> RDB_ARCHIVE_HISTORY_PROVIDER_CLASS;

        private RdbmsTypeHolder() {
        }

        static {
            Class typeClass;
            Type type;
            try {
                type = Sys.getType((String)"rdb:Rdbms");
            }
            catch (Exception e) {
                type = null;
            }
            RDBMS_TYPE = type;
            try {
                typeClass = Sys.getType((String)"rdb:RdbArchiveHistoryProvider").getTypeClass();
            }
            catch (Exception e) {
                typeClass = null;
            }
            RDB_ARCHIVE_HISTORY_PROVIDER_CLASS = typeClass;
        }
    }
}

