/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.ext;

import javax.baja.history.ext.BActivePeriod;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="daysOfWeek", type="BDaysOfWeekBits", defaultValue="BDaysOfWeekBits.ALL"), @NiagaraProperty(name="timeRange", type="BTimeRange", defaultValue="new BTimeRange()")})
public final class BBasicActivePeriod
extends BActivePeriod {
    @Generated
    public static final Property daysOfWeek = BBasicActivePeriod.newProperty((int)0, (BValue)BDaysOfWeekBits.ALL, null);
    @Generated
    public static final Property timeRange = BBasicActivePeriod.newProperty((int)0, (BValue)new BTimeRange(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBasicActivePeriod.class);

    @Generated
    public BDaysOfWeekBits getDaysOfWeek() {
        return (BDaysOfWeekBits)this.get(daysOfWeek);
    }

    @Generated
    public void setDaysOfWeek(BDaysOfWeekBits v) {
        this.set(daysOfWeek, (BValue)v, null);
    }

    @Generated
    public BTimeRange getTimeRange() {
        return (BTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBasicActivePeriod() {
    }

    public BBasicActivePeriod(BDaysOfWeekBits daysOfWeek, BTimeRange timeRange) {
        this.setDaysOfWeek(daysOfWeek);
        this.setTimeRange(timeRange);
    }

    @Override
    public boolean isAlwaysActive() {
        return this.getDaysOfWeek().isEveryDay() && this.getTimeRange().isAllDay();
    }

    @Override
    public boolean isNeverActive() {
        return this.getDaysOfWeek().isEmpty();
    }

    @Override
    public BAbsTime getActiveStart(BAbsTime time) {
        if (!this.isActive(time)) {
            return null;
        }
        if (this.isAlwaysActive()) {
            return BAbsTime.make((BAbsTime)time, (BTime)BTime.make((int)0, (int)0, (int)0, (int)0));
        }
        return BAbsTime.make((BAbsTime)time, (BTime)this.getTimeRange().getStartTime());
    }

    @Override
    public BAbsTime getActiveEnd(BAbsTime time) {
        if (!this.isActive(time)) {
            return null;
        }
        if (this.isAlwaysActive()) {
            return null;
        }
        BTime endTime = this.getTimeRange().getEndTime();
        if (endTime.getTimeOfDayMillis() == 0L) {
            time = time.nextDay();
        }
        return BAbsTime.make((BAbsTime)time, (BTime)endTime);
    }

    @Override
    public BAbsTime getNextActive(BAbsTime time) {
        if (this.isAlwaysActive()) {
            return null;
        }
        if (this.isNeverActive()) {
            return null;
        }
        BDaysOfWeekBits daysOfWeek = this.getDaysOfWeek();
        BTimeRange timeRange = this.getTimeRange();
        if (this.getDaysOfWeek().includes(time) && BTime.make((BAbsTime)time).isBefore(timeRange.getStartTime())) {
            return BAbsTime.make((BAbsTime)time, (BTime)timeRange.getStartTime());
        }
        BAbsTime day = time.nextDay();
        while (!daysOfWeek.includes(day.getWeekday())) {
            day = day.nextDay();
        }
        return BAbsTime.make((BAbsTime)day, (BTime)timeRange.getStartTime());
    }

    @Override
    public BAbsTime getNextInactive(BAbsTime time) {
        if (this.isAlwaysActive()) {
            return null;
        }
        if (this.isNeverActive()) {
            return null;
        }
        BDaysOfWeekBits daysOfWeek = this.getDaysOfWeek();
        BTimeRange timeRange = this.getTimeRange();
        if (daysOfWeek.includes(time)) {
            long endMillis = timeRange.getEndTime().getTimeOfDayMillis();
            if (endMillis == 0L) {
                return BAbsTime.make((BAbsTime)time.nextDay(), (BTime)timeRange.getEndTime());
            }
            long timeMillis = time.getTimeOfDayMillis();
            if (timeMillis < endMillis) {
                return BAbsTime.make((BAbsTime)time, (BTime)timeRange.getEndTime());
            }
        }
        BAbsTime day = time.nextDay();
        while (!daysOfWeek.includes(day.getWeekday())) {
            day = day.nextDay();
        }
        BTime endTime = timeRange.getEndTime();
        if (endTime.getTimeOfDayMillis() == 0L) {
            day = day.nextDay();
        }
        return BAbsTime.make((BAbsTime)day, (BTime)timeRange.getEndTime());
    }

    @Override
    public boolean isActive(BAbsTime timestamp) {
        BTimeRange invalidRange;
        if (!this.getDaysOfWeek().includes(timestamp.getWeekday())) {
            return false;
        }
        return !(this.getTimeRange().getStartTime().isAfter(this.getTimeRange().getEndTime()) ? (invalidRange = new BTimeRange(this.getTimeRange().getEndTime(), this.getTimeRange().getStartTime())).includes(timestamp) : !this.getTimeRange().includes(timestamp));
    }
}

