/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BTrendFlags
extends BBitString {
    public static final byte START = 1;
    public static final byte OUT_OF_ORDER = 2;
    public static final byte HIDDEN = 4;
    public static final byte MODIFIED = 8;
    public static final byte INTERPOLATED = 16;
    public static final byte RESERVED_0 = 32;
    public static final byte RESERVED_1 = 64;
    public static final byte RESERVED_2 = -128;
    public static final BTrendFlags start = new BTrendFlags(1);
    public static final BTrendFlags outOfOrder = new BTrendFlags(2);
    public static final BTrendFlags hidden = new BTrendFlags(4);
    public static final BTrendFlags modified = new BTrendFlags(8);
    public static final BTrendFlags interpolated = new BTrendFlags(16);
    public static final BTrendFlags DEFAULT = new BTrendFlags(0);
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;
    private byte bits;

    public byte getBits() {
        return this.bits;
    }

    public BTrendFlags set(int ordinal, boolean newState) {
        byte newBits = this.getBits();
        newBits = newState ? (byte)(newBits | (byte)(0xFF & ordinal)) : (byte)(newBits & ~((byte)(0xFF & ordinal)));
        return BTrendFlags.make(newBits);
    }

    public static BTrendFlags make() {
        return DEFAULT;
    }

    public static BTrendFlags make(int bits) {
        if (bits == 0) {
            return DEFAULT;
        }
        return (BTrendFlags)new BTrendFlags((byte)(0xFF & bits)).intern();
    }

    public static BTrendFlags make(byte bits) {
        if (bits == 0) {
            return DEFAULT;
        }
        return (BTrendFlags)new BTrendFlags(bits).intern();
    }

    private BTrendFlags() {
        this.bits = 0;
    }

    private BTrendFlags(byte bits) {
        this.bits = bits;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return new int[]{1, 2, 4, 8, 16};
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        byte mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask = (byte)(mask | (byte)(0xFF & ordinals[i]));
        }
        return BTrendFlags.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public String getEmptyTag() {
        return "none";
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BTrendFlags) {
            return ((BTrendFlags)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeByte(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return new BTrendFlags(in.readByte()).intern();
    }

    public String encodeToString() {
        return Integer.toString(0xFF & this.bits, 16);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            int i = Integer.parseInt(s, 16);
            byte b = (byte)(i & 0xFF);
            if (b == 0) {
                return DEFAULT;
            }
            return new BTrendFlags(b).intern();
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public BIDataValue toDataValue() {
        return BInteger.make((int)(this.bits & 0xFF));
    }

    public String toString(Context cx) {
        if (this.bits == 0) {
            return "{ }";
        }
        StringBuilder s = new StringBuilder();
        s.append('{');
        boolean first = true;
        if (this.getBit(1)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(1, cx));
        }
        if (this.getBit(2)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(2, cx));
        }
        if (this.getBit(4)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(4, cx));
        }
        if (this.getBit(8)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(8, cx));
        }
        if (this.getBit(16)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(16, cx));
        }
        if (this.getBit(32)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(32, cx));
        }
        if (this.getBit(64)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(64, cx));
        }
        if (this.getBit(-128)) {
            if (!first) {
                s.append(",");
            }
            first = false;
            s.append(support.getDisplayTag(-128, cx));
        }
        s.append('}');
        return s.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "start");
        support.add(2, "outOfOrder");
        support.add(4, "hidden");
        support.add(8, "modified");
        support.add(16, "interpolated");
        support.add(32, "reserved0");
        support.add(64, "reserved1");
        support.add(-128, "reserved2");
        TYPE = Sys.loadType(BTrendFlags.class);
    }
}

