/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.IOException;
import javax.baja.history.BCapacity;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySchema;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStorageType;
import javax.baja.history.HistoryException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="id", type="BHistoryId", defaultValue="BHistoryId.NULL", flags=329), @NiagaraProperty(name="historyName", type="String", defaultValue="", flags=6), @NiagaraProperty(name="source", type="BOrdList", defaultValue="BOrdList.NULL", flags=265), @NiagaraProperty(name="sourceHandle", type="BOrd", defaultValue="BOrd.NULL", flags=4), @NiagaraProperty(name="timeZone", type="BTimeZone", defaultValue="BTimeZone.NULL", flags=65), @NiagaraProperty(name="recordType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1), @NiagaraProperty(name="schema", type="BHistorySchema", defaultValue="BHistorySchema.DEFAULT", flags=5), @NiagaraProperty(name="capacity", type="BCapacity", defaultValue="BCapacity.makeByRecordCount(500)"), @NiagaraProperty(name="fullPolicy", type="BFullPolicy", defaultValue="BFullPolicy.roll"), @NiagaraProperty(name="storageType", type="BStorageType", defaultValue="BStorageType.file", flags=4), @NiagaraProperty(name="interval", type="BCollectionInterval", defaultValue="BCollectionInterval.IRREGULAR", flags=257), @NiagaraProperty(name="systemTags", type="BNameList", defaultValue="BNameList.NULL")})
public class BHistoryConfig
extends BComponent {
    @Generated
    public static final Property id = BHistoryConfig.newProperty((int)329, (BValue)BHistoryId.NULL, null);
    @Generated
    public static final Property historyName = BHistoryConfig.newProperty((int)6, (String)"", null);
    @Generated
    public static final Property source = BHistoryConfig.newProperty((int)265, (BValue)BOrdList.NULL, null);
    @Generated
    public static final Property sourceHandle = BHistoryConfig.newProperty((int)4, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property timeZone = BHistoryConfig.newProperty((int)65, (BValue)BTimeZone.NULL, null);
    @Generated
    public static final Property recordType = BHistoryConfig.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property schema = BHistoryConfig.newProperty((int)5, (BValue)BHistorySchema.DEFAULT, null);
    @Generated
    public static final Property capacity = BHistoryConfig.newProperty((int)0, (BValue)BCapacity.makeByRecordCount(500), null);
    @Generated
    public static final Property fullPolicy = BHistoryConfig.newProperty((int)0, (BValue)BFullPolicy.roll, null);
    @Generated
    public static final Property storageType = BHistoryConfig.newProperty((int)4, (BValue)BStorageType.file, null);
    @Generated
    public static final Property interval = BHistoryConfig.newProperty((int)257, (BValue)BCollectionInterval.IRREGULAR, null);
    @Generated
    public static final Property systemTags = BHistoryConfig.newProperty((int)0, (BValue)BNameList.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryConfig.class);
    private int recordSize = -1;
    private BHistoryRecord prototype;

    @Generated
    public BHistoryId getId() {
        return (BHistoryId)this.get(id);
    }

    @Generated
    public void setId(BHistoryId v) {
        this.set(id, (BValue)v, null);
    }

    @Generated
    public String getHistoryName() {
        return this.getString(historyName);
    }

    @Generated
    public void setHistoryName(String v) {
        this.setString(historyName, v, null);
    }

    @Generated
    public BOrdList getSource() {
        return (BOrdList)this.get(source);
    }

    @Generated
    public void setSource(BOrdList v) {
        this.set(source, (BValue)v, null);
    }

    @Generated
    public BOrd getSourceHandle() {
        return (BOrd)this.get(sourceHandle);
    }

    @Generated
    public void setSourceHandle(BOrd v) {
        this.set(sourceHandle, (BValue)v, null);
    }

    @Generated
    public BTimeZone getTimeZone() {
        return (BTimeZone)this.get(timeZone);
    }

    @Generated
    public void setTimeZone(BTimeZone v) {
        this.set(timeZone, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getRecordType() {
        return (BTypeSpec)this.get(recordType);
    }

    @Generated
    public void setRecordType(BTypeSpec v) {
        this.set(recordType, (BValue)v, null);
    }

    @Generated
    public BHistorySchema getSchema() {
        return (BHistorySchema)this.get(schema);
    }

    @Generated
    public void setSchema(BHistorySchema v) {
        this.set(schema, (BValue)v, null);
    }

    @Generated
    public BCapacity getCapacity() {
        return (BCapacity)this.get(capacity);
    }

    @Generated
    public void setCapacity(BCapacity v) {
        this.set(capacity, (BValue)v, null);
    }

    @Generated
    public BFullPolicy getFullPolicy() {
        return (BFullPolicy)this.get(fullPolicy);
    }

    @Generated
    public void setFullPolicy(BFullPolicy v) {
        this.set(fullPolicy, (BValue)v, null);
    }

    @Generated
    public BStorageType getStorageType() {
        return (BStorageType)this.get(storageType);
    }

    @Generated
    public void setStorageType(BStorageType v) {
        this.set(storageType, (BValue)v, null);
    }

    @Generated
    public BCollectionInterval getInterval() {
        return (BCollectionInterval)this.get(interval);
    }

    @Generated
    public void setInterval(BCollectionInterval v) {
        this.set(interval, (BValue)v, null);
    }

    @Generated
    public BNameList getSystemTags() {
        return (BNameList)this.get(systemTags);
    }

    @Generated
    public void setSystemTags(BNameList v) {
        this.set(systemTags, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryConfig() {
    }

    public BHistoryConfig(BHistoryId id, BTypeSpec recType) {
        this.setId(id);
        this.setRecordType(recType);
        this.setSchema(BHistoryConfig.makeRecord(recType, 2).getSchema());
    }

    public BHistoryConfig(BCapacity capacity, BFullPolicy fullPolicy) {
        this.setCapacity(capacity);
        this.setFullPolicy(fullPolicy);
    }

    public BHistoryConfig(BHistoryId id, BTypeSpec recordType, BCapacity capacity) {
        this.setId(id);
        this.setRecordType(recordType);
        this.setSchema(BHistoryConfig.makeRecord(recordType, 2).getSchema());
        this.setCapacity(capacity);
    }

    public Type getColumnType(String name) {
        try {
            BHistoryRecord rec = this.makeRecord();
            Property prop = rec.getProperty(name);
            if (prop == null) {
                return null;
            }
            return prop.getDefaultValue().getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public BHistoryRecord makeRecord() throws HistoryException {
        return this.makeRecord(2);
    }

    public BHistoryRecord makeRecord(int version) throws HistoryException {
        BTypeSpec recordType = this.getRecordType();
        try {
            return BHistoryConfig.makeRecord(recordType, version);
        }
        catch (TypeNotFoundException ex) {
            if (recordType.getTypeName().equals("FloatTrendRecord")) {
                this.setRecordType(BNumericTrendRecord.TYPE.getTypeSpec());
                return new BNumericTrendRecord();
            }
            throw ex;
        }
    }

    private static BHistoryRecord makeRecord(BTypeSpec typeSpec, int version) {
        Type recordType = typeSpec.getResolvedType();
        BHistoryRecord record = (BHistoryRecord)recordType.getInstance();
        record.setHistoryVersion(version);
        return record;
    }

    public BObject makePrototype() {
        try {
            return this.makeRecord();
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public int getRecordSize() throws IOException, HistoryException {
        if (this.recordSize == -1) {
            try {
                BHistoryRecord rec = this.makeRecord();
                if (!rec.isFixedSize()) {
                    throw new UnsupportedOperationException("A fixed record size cannot be determined for a history with variable length records.");
                }
                this.recordSize = rec.getRecordSize();
            }
            catch (ModuleException e) {
                throw new HistoryException(e.getMessage(), e);
            }
            catch (TypeException e) {
                throw new HistoryException(e.getMessage(), e);
            }
        }
        return this.recordSize;
    }

    public void changed(Property p, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (p == recordType && this.getSchema().equals((Object)BHistorySchema.DEFAULT)) {
            this.setSchema(this.makeRecord().getSchema());
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BIHistorySource) {
            ((BIHistorySource)parent).historyConfigChanged(this, p);
        }
    }

    public void added(Property p, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BIHistorySource) {
            ((BIHistorySource)parent).historyConfigChanged(this, p);
        }
    }

    public void removed(Property p, BValue value, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BIHistorySource) {
            ((BIHistorySource)parent).historyConfigChanged(this, p);
        }
    }

    public void renamed(Property p, String oldName, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BIHistorySource) {
            ((BIHistorySource)parent).historyConfigChanged(this, p);
        }
    }

    public void flagsChanged(Slot slot, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (!slot.isProperty()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BIHistorySource) {
            ((BIHistorySource)parent).historyConfigChanged(this, slot.asProperty());
        }
    }

    public void facetsChanged(Slot slot, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (!slot.isProperty()) {
            return;
        }
        BComplex parent = this.getParent();
        if (parent instanceof BIHistorySource) {
            ((BIHistorySource)parent).historyConfigChanged(this, slot.asProperty());
        }
    }

    public String toString(Context cx) {
        StringBuilder out = new StringBuilder();
        out.append(interval.getDefaultDisplayName(cx) + ": " + (Object)((Object)this.getInterval())).append(", ");
        out.append(recordType.getDefaultDisplayName(cx) + ": ");
        out.append(this.getRecordType().isNull() ? "null" : this.getRecordType().getResolvedType().getDisplayName(cx).toLowerCase()).append(", ");
        out.append(capacity.getDefaultDisplayName(cx) + ": " + (Object)((Object)this.getCapacity())).append(", ");
        out.append(fullPolicy.getDefaultDisplayName(cx) + ": " + (Object)((Object)this.getFullPolicy()));
        return out.toString();
    }
}

