/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
public final class BCapacity
extends BSimple {
    private static final int RESTRICT_NONE = 0;
    private static final int RESTRICT_RECORD_COUNT = 1;
    private static final int RESTRICT_STORAGE_SIZE = 2;
    public static final BCapacity UNLIMITED;
    public static final BCapacity DEFAULT;
    public static final Type TYPE;
    private static final LexiconText unlimitedTxt;
    private static final LexiconText recordsTxt;
    public static final BFacets recordCountFacets;
    private int restrictBy;
    private long max;
    private int hashCode = -1;

    public static BCapacity makeByRecordCount(int maxRecords) {
        return (BCapacity)new BCapacity(1, maxRecords).intern();
    }

    public static BCapacity makeByStorageSize(long maxSize) {
        return (BCapacity)new BCapacity(2, maxSize).intern();
    }

    public static BCapacity makeUnlimited() {
        return UNLIMITED;
    }

    private BCapacity(int restrictBy, long max) {
        this.restrictBy = restrictBy;
        this.max = max;
    }

    public boolean isUnlimited() {
        return this.restrictBy == 0;
    }

    public boolean isByRecordCount() {
        return this.restrictBy == 1;
    }

    public boolean isByStorageSize() {
        return this.restrictBy == 2;
    }

    public int getMaxRecords() {
        if (this.restrictBy == 0) {
            return -1;
        }
        if (this.restrictBy == 2) {
            throw new IllegalStateException("Capacity is not restricted by record count.");
        }
        if (this.max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.max;
    }

    public long getMaxStorage() {
        if (this.restrictBy == 0) {
            return -1L;
        }
        if (this.restrictBy == 1) {
            throw new IllegalStateException("Capacity is not restricted by storage size.");
        }
        return this.max;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + (long)this.restrictBy;
            hash = hash * 37L + this.max;
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BCapacity)) {
            return false;
        }
        BCapacity other = (BCapacity)((Object)o);
        return this.restrictBy == other.restrictBy && this.max == other.max;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.restrictBy);
        out.writeLong(this.max);
    }

    public BObject decode(DataInput in) throws IOException {
        int restrictBy = in.readInt();
        long max = in.readLong();
        return new BCapacity(restrictBy, max).intern();
    }

    public String encodeToString() {
        StringBuilder s = new StringBuilder(16);
        s.append(this.restrictBy);
        s.append(':');
        s.append(this.max);
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int colon = s.indexOf(58);
        int restrictBy = Integer.parseInt(s.substring(0, colon));
        long max = Long.parseLong(s.substring(colon + 1));
        return new BCapacity(restrictBy, max).intern();
    }

    public String toString(Context cx) {
        if (this.restrictBy == 0) {
            return unlimitedTxt.getText(cx);
        }
        if (this.restrictBy == 1) {
            return Long.toString(this.max) + " " + recordsTxt.getText(cx);
        }
        if (this.restrictBy == 2) {
            return Long.toString(this.max / 1024L) + " KB";
        }
        return Long.toString(this.max);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = UNLIMITED = new BCapacity(0, 0L);
        TYPE = Sys.loadType(BCapacity.class);
        unlimitedTxt = LexiconText.make((String)"history", (String)"unlimited");
        recordsTxt = LexiconText.make((String)"history", (String)"records");
        recordCountFacets = BFacets.make((String[])new String[]{"min", "max"}, (BIDataValue[])new BIDataValue[]{BDouble.make((double)0.0), BDouble.POSITIVE_INFINITY});
    }
}

