/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="value", type="boolean", defaultValue="false", flags=8)
public class BBooleanTrendRecord
extends BTrendRecord
implements BIEnum,
BIBoolean,
BIStatus {
    @Generated
    public static final Property value = BBooleanTrendRecord.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBooleanTrendRecord.class);

    @Generated
    public boolean getValue() {
        return this.getBoolean(value);
    }

    @Generated
    public void setValue(boolean v) {
        this.setBoolean(value, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    BBooleanTrendRecord(BAbsTime timestamp, boolean value, BStatus status) {
        super(timestamp, status);
        this.setValue(value);
    }

    public BBooleanTrendRecord() {
    }

    @Override
    public Property getValueProperty() {
        return value;
    }

    public BEnum getEnum() {
        return BBoolean.make((boolean)this.getValue());
    }

    public BFacets getEnumFacets() {
        return BBoolean.make((boolean)this.getValue()).getEnumFacets();
    }

    public boolean getBoolean() {
        return this.getValue();
    }

    public BFacets getBooleanFacets() {
        return BFacets.NULL;
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }

    public BBooleanTrendRecord set(BAbsTime timestamp, boolean value, BStatus status) {
        this.setTimestamp(timestamp);
        this.setTrendFlags(BTrendFlags.DEFAULT);
        this.setValue(value);
        this.setStatus(status);
        return this;
    }

    @Override
    public void doReadTrend(DataInput in) throws IOException {
        this.setValue(in.readBoolean());
    }

    @Override
    public void doWriteTrend(DataOutput out) throws IOException {
        out.writeBoolean(this.getValue());
    }

    @Override
    public String toString(Context ctx) {
        StringBuilder s = new StringBuilder(32);
        s.append(super.toString(ctx));
        s.append(" ");
        s.append(this.getValue());
        s.append(' ');
        s.append(this.getStatus());
        return s.toString();
    }
}

