/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.io;

import com.tridium.history.collection.ColumnSpec;
import com.tridium.history.io.HistoryOutput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;

public class RecordOutput
extends HistoryOutput {
    private BFacets tableFacets;
    private ColumnSpec[] specs;

    public RecordOutput(DataOutput out) {
        super(out);
    }

    public RecordOutput(BHistoryConfig cfg, DataOutput out, Context cx) {
        super(out);
        this.specs = RecordOutput.getColumnSpecs(cfg, cx);
    }

    public RecordOutput(BITable<?> table, DataOutput out, Context cx) {
        super(out);
        this.tableFacets = table.getTableFacets();
        this.specs = RecordOutput.getColumnSpecs(table, cx);
    }

    public RecordOutput(BITable<?> table, Type recType, DataOutput out, Context cx) {
        super(recType, out);
        this.tableFacets = table.getTableFacets();
        this.specs = RecordOutput.getColumnSpecs(table, cx);
    }

    @Override
    protected void doWriteHeader(DataOutput out) throws IOException {
        if (this.tableFacets == null) {
            BFacets.NULL.encode(out);
        } else {
            this.tableFacets.encode(out);
        }
        if (this.specs == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.specs.length);
        for (int i = 0; i < this.specs.length; ++i) {
            this.specs[i].write(out);
        }
    }

    @Override
    protected void doWrite(DataOutput out, BObject o) throws IOException {
        ((BHistoryRecord)o).write(out);
    }

    public static ColumnSpec[] getColumnSpecs(BHistoryConfig cfg, Context cx) {
        BHistoryRecord rec = cfg.makeRecord();
        Property[] props = rec.getPropertiesArray();
        ColumnSpec[] list = new ColumnSpec[props.length];
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            BFacets facets = cfg.getSlotFacets((Slot)prop);
            BFacets moreFacets = null;
            try {
                moreFacets = (BFacets)cfg.get(prop.getName() + "Facets");
            }
            catch (Exception exception) {
                // empty catch block
            }
            facets = BFacets.make((BFacets)facets, moreFacets);
            list[i] = new ColumnSpec(prop.getName(), prop.getDefaultDisplayName(cx), facets);
        }
        return list;
    }

    public static ColumnSpec[] getColumnSpecs(BITable<?> table, Context cx) {
        ColumnList columns = table.getColumns();
        int colCount = columns.size();
        ColumnSpec[] list = new ColumnSpec[colCount];
        for (int i = 0; i < colCount; ++i) {
            Column col = columns.get(i);
            BFacets facets = col.getFacets();
            if (facets == null) {
                facets = BFacets.NULL;
            }
            list[i] = new ColumnSpec(col.getName(), col.getDisplayName(cx), facets);
        }
        return list;
    }
}

