/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Page;
import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordSpec;
import com.tridium.history.file.recstore.RecordStore;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;

public class RecordStoreDescendingCursor
extends HistoryCursor {
    private Page page;
    private int startBlock;
    private BAbsTime end;
    private ReadBlock readBlock;
    private BHistoryRecord[] recordCache;
    private int recordIndex = -1;

    public RecordStoreDescendingCursor(RecordStore store, BHistoryConfig config, RecordSpec start, BAbsTime end, Context cx) {
        super(config, config.makeRecord(), cx);
        this.page = start.page;
        this.startBlock = start.block;
        this.end = end;
        this.readBlock = new ReadBlock(store.getHeader().getBlockSize());
        this.recordCache = new BHistoryRecord[(int)Math.ceil(store.getPageSize() / store.getBlockSize())];
    }

    @Override
    protected boolean doNext(BHistoryRecord iteratorRec) {
        try {
            if (this.recordIndex == -1) {
                if (this.page == null) {
                    return false;
                }
                this.recordIndex = this.page.getRecordCount() - 1;
                this.readBlock.init(this.page, this.page.getFirst());
                for (int i = 0; i < this.page.getRecordCount(); ++i) {
                    this.recordCache[i] = (BHistoryRecord)iteratorRec.read(this.readBlock).newCopy();
                    this.readBlock.nextBlock();
                    if (this.readBlock.getPageBlock() <= this.startBlock) continue;
                    this.recordIndex = i;
                    break;
                }
            }
            if (this.end != null && !this.end.isNull() && this.recordCache[this.recordIndex].getTimestamp().isBefore(this.end)) {
                return false;
            }
            if (this.recordCache[this.recordIndex] == null) {
                return false;
            }
            iteratorRec.copyFrom((BComplex)this.recordCache[this.recordIndex]);
            --this.recordIndex;
            if (this.recordIndex == -1) {
                this.page = this.page.prevPage();
                this.startBlock = this.recordCache.length;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

