/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.recstore.RecordStore;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRecordStoreHistoryTable
extends BFileHistoryTable {
    @Generated
    public static final Type TYPE = Sys.loadType(BRecordStoreHistoryTable.class);
    private RecordStore store;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRecordStoreHistoryTable() {
    }

    public BRecordStoreHistoryTable(BHistoryConfig config) {
        super(config);
    }

    @Override
    protected void createDataSection() throws IOException {
        BHistoryConfig config = this.getConfig();
        BHistoryRecord rec = config.makeRecord(this.getVersion());
        int blockSize = this.computeBlockSize(rec);
        int pageBlocks = 4096 / blockSize;
        RecordStore store = new RecordStore(config, this, blockSize, pageBlocks, this.getVersion());
    }

    private int computeBlockSize(BHistoryRecord rec) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(128);
            DataOutputStream out = new DataOutputStream(bytes);
            rec.write(out);
            int len = bytes.size();
            if (len > 64) {
                return len;
            }
            return 64;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 64;
        }
    }

    @Override
    protected void openDataSection() throws IOException {
        this.store = new RecordStore(this.getConfig(), this, this.getVersion());
    }

    @Override
    protected boolean flushData() throws IOException {
        return this.store.flush();
    }

    @Override
    protected void closeData() {
    }

    @Override
    protected boolean deleteData() {
        return true;
    }

    @Override
    protected int doGetRecordCount() throws IOException, HistoryException {
        return this.store.getRecordCount();
    }

    @Override
    protected BAbsTime doGetFirstTimestamp() throws IOException, HistoryException {
        return this.store.getFirstTimestamp();
    }

    @Override
    protected BAbsTime doGetLastTimestamp() throws IOException {
        return this.store.getLastTimestamp();
    }

    @Override
    protected BHistoryRecord doGetLastRecord() throws IOException {
        return this.store.getLastRecord();
    }

    @Override
    protected boolean doAppend(BHistoryRecord newRecord) throws IOException {
        try {
            BFullPolicy fullPolicy;
            int maxRecords;
            int recordCount = this.store.getRecordCount();
            BCapacity capacity = this.getConfig().getCapacity();
            if (capacity.isByRecordCount() && recordCount == (maxRecords = capacity.getMaxRecords()) && (fullPolicy = this.getConfig().getFullPolicy()) == BFullPolicy.stop) {
                return false;
            }
            this.store.append(newRecord);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void doUpdate(BHistoryRecord oldRecord, BHistoryRecord newRecord) throws IOException {
        this.store.update(oldRecord, newRecord);
    }

    @Override
    protected Cursor<BHistoryRecord> doTimeQuery(BAbsTime start, BAbsTime end, boolean descending) throws IOException {
        if (!descending) {
            return this.store.query(start, end);
        }
        return this.store.queryDesc(start, end);
    }

    @Override
    public Spy getTableSpy() {
        return new RecordStoreHistoryTableSpy(this);
    }

    @Override
    public int getPageWriteCount() {
        return this.store.getPageWriteCount();
    }

    @Override
    public int getHeaderWriteCount() {
        return this.store.getHeaderWriteCount();
    }

    @Override
    public int getTotalRecordAppends() {
        return this.store.getTotalRecordAppends();
    }

    public class RecordStoreHistoryTableSpy
    extends Spy {
        BRecordStoreHistoryTable table;

        public RecordStoreHistoryTableSpy(BRecordStoreHistoryTable table) {
            this.table = table;
        }

        public void write(SpyWriter out) throws Exception {
            BRecordStoreHistoryTable.this.store.spy(out);
        }
    }
}

