/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.file.VersionMismatchException;
import com.tridium.history.file.fixed.Page;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;

public class Header {
    public static final int SIZE = 64;
    private int version = 1;
    private int pageSize;
    private int recSize;
    private int capacity;
    private int maxPages;
    private int pageCount;
    private int recsPerPage;
    private int firstPage = -1;
    private int lastPage = -1;
    private boolean dirty;
    private static final int BYTES_PER_INTEGER = 4;
    private static final int VERSION_FIELDS = 7;
    private byte[] readHeader = new byte[28];
    private byte[] writeHeader = new byte[28];
    private static final int VERSION = 0;
    private static final int PAGE_SIZE = 1;
    private static final int PAGE_COUNT = 2;
    private static final int REC_SIZE = 3;
    private static final int CAPACITY = 4;
    private static final int FIRST_PAGE = 5;
    private static final int LAST_PAGE = 6;

    public Header() {
        this.dirty = true;
    }

    public Header(int pageSize, int recSize, int capacity) {
        this.pageSize = pageSize;
        this.recSize = recSize;
        this.capacity = capacity;
        this.recsPerPage = Page.computeRecordsPerPage(pageSize, recSize);
        this.maxPages = Header.computeMaxPages(capacity, this.recsPerPage);
        this.dirty = true;
    }

    public static int computeMaxPages(int capacity, int recsPerPage) {
        int max = capacity / recsPerPage;
        if (capacity % recsPerPage != 0) {
            ++max;
        }
        return ++max;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int getVersion() {
        return this.version;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getRecordSize() {
        return this.recSize;
    }

    public int getRecordsPerPage() {
        return this.recsPerPage;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
        this.dirty = true;
    }

    public int incrementPageCount() {
        ++this.pageCount;
        this.dirty = true;
        return this.pageCount;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(int firstPage) {
        this.firstPage = firstPage;
        this.dirty = true;
    }

    public int getNextFirstPage() {
        return (this.firstPage + 1) % this.maxPages;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(int lastPage) {
        this.lastPage = lastPage;
        this.dirty = true;
    }

    public int getNextLastPage() {
        return (this.lastPage + 1) % this.maxPages;
    }

    public int previous(int pageIndex) {
        if (pageIndex == -1) {
            return -1;
        }
        int i = pageIndex - 1;
        if (i < 0) {
            i = this.pageCount - 1;
        }
        return i;
    }

    public int next(int pageIndex) {
        if (pageIndex == -1) {
            return -1;
        }
        int i = pageIndex + 1;
        if (i == this.pageCount) {
            i = 0;
        }
        return i;
    }

    public void read(DataInput in) throws IOException {
        in.readFully(this.readHeader, 0, this.readHeader.length);
        this.version = this.getHeader(0);
        if (this.version != 1) {
            throw new VersionMismatchException(1, this.version);
        }
        this.pageSize = this.getHeader(1);
        this.pageCount = this.getHeader(2);
        this.recSize = this.getHeader(3);
        this.capacity = this.getHeader(4);
        this.firstPage = this.getHeader(5);
        this.lastPage = this.getHeader(6);
        this.recsPerPage = Page.computeRecordsPerPage(this.pageSize, this.recSize);
        this.maxPages = Header.computeMaxPages(this.capacity, this.recsPerPage);
        this.dirty = false;
    }

    public void write(DataOutput out) throws IOException {
        this.setHeader(0, this.version);
        this.setHeader(1, this.pageSize);
        this.setHeader(2, this.pageCount);
        this.setHeader(3, this.recSize);
        this.setHeader(4, this.capacity);
        this.setHeader(5, this.firstPage);
        this.setHeader(6, this.lastPage);
        out.write(this.writeHeader, 0, this.writeHeader.length);
        this.dirty = false;
    }

    public void dump(PrintWriter out) {
        out.println("version    : " + this.version);
        out.println("pageSize   : " + this.pageSize);
        out.println("recSize    : " + this.recSize);
        out.println("capacity   : " + this.capacity);
        out.println("maxPages   : " + this.maxPages);
        out.println("pageCount  : " + this.pageCount);
        out.println("recsPerPage: " + this.recsPerPage);
        out.println("firstPage  : " + this.firstPage);
        out.println("lastPage   : " + this.lastPage);
        out.flush();
    }

    public String toString() {
        return "Header: firstPage=" + this.firstPage + " lastPage=" + this.lastPage + " pageCount=" + this.pageCount;
    }

    private int getHeader(int field) {
        int idx = field * 4;
        return (0xFF & this.readHeader[idx]) << 24 | (0xFF & this.readHeader[idx + 1]) << 16 | (0xFF & this.readHeader[idx + 2]) << 8 | 0xFF & this.readHeader[idx + 3];
    }

    private void setHeader(int field, int value) {
        int idx = field * 4;
        this.writeHeader[idx] = (byte)(0xFF & value >> 24);
        this.writeHeader[idx + 1] = (byte)(0xFF & value >> 16);
        this.writeHeader[idx + 2] = (byte)(0xFF & value >> 8);
        this.writeHeader[idx + 3] = (byte)(0xFF & value);
    }
}

