/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file;

import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.history.file.HybridHistoryCursor;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;

class ModifiedContextHistoryCursor
extends HistoryCursor {
    final BHistoryDatabase db;
    final BAbsTime firstLocalTimestamp;
    final boolean descending;
    final HistoryCursor localCursor;
    Context modifiedContext;
    private boolean includeArchiveData;

    ModifiedContextHistoryCursor(BHistoryDatabase db, HistoryCursor localCursor, BAbsTime firstLocalTimestamp, boolean descending) {
        super(localCursor.getConfig(), (BHistoryRecord)localCursor.get(), localCursor.getContext());
        this.db = db;
        this.localCursor = localCursor;
        this.firstLocalTimestamp = firstLocalTimestamp;
        this.descending = descending;
    }

    @Override
    public void setConnectionContext(Context connectionCx) {
        this.localCursor.setConnectionContext(connectionCx);
        this.includeArchiveData = !HistoryQuery.excludeArchiveData(connectionCx);
    }

    @Override
    public Context getContext() {
        if (this.modifiedContext == null) {
            this.modifiedContext = this.localCursor.getContext();
            if (this.includeArchiveData) {
                BHistoryRecord preRec = BHistoryTimeQuery.getPreRecFromContext(this.modifiedContext);
                BHistoryRecord postRec = BHistoryTimeQuery.getPostRecFromContext(this.modifiedContext);
                Optional<Object> lastArchiveRecord = Optional.empty();
                try (HistorySpaceConnection conn = this.db.getConnection(null);){
                    lastArchiveRecord = BHistoryTimeQuery.getLastRecordInRange(conn.getHistory(this.getConfig().getId()), null, this.firstLocalTimestamp.subtract(BFileHistoryTable.ONE_MILLISECOND), false, null);
                }
                if (lastArchiveRecord.isPresent()) {
                    if (this.descending) {
                        postRec = (BHistoryRecord)lastArchiveRecord.get();
                    } else {
                        preRec = (BHistoryRecord)lastArchiveRecord.get();
                    }
                    try {
                        this.modifiedContext = new BasicContext(this.modifiedContext, HistoryCursor.makeBoundaryRecordFacets(preRec, postRec));
                    }
                    catch (Exception e) {
                        HybridHistoryCursor.LOG.log(Level.WARNING, "Failed to create context with pre/post records.", e);
                    }
                }
            }
            if (this.modifiedContext == null) {
                this.modifiedContext = new BasicContext();
            }
        }
        return this.modifiedContext;
    }

    @Override
    protected boolean doNext(BHistoryRecord iteratorRec) {
        return this.localCursor.next();
    }

    @Override
    protected BHistoryRecord doGet() {
        return (BHistoryRecord)this.localCursor.get();
    }
}

