/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file;

import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.file.ArchiveHistoryWorkbenchNotifier;
import com.tridium.util.EmptyCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BArchiveHistoryProvider;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

class HybridHistoryCursor
extends HistoryCursor {
    static final Logger LOG = Logger.getLogger("history.archiveProvider");
    private static final Cursor<BHistoryRecord> EMPTY_CURSOR = new EmptyCursor(null);
    private final Cursor<BHistoryRecord> localCursor;
    private final BAbsTime archiveStart;
    private final BAbsTime archiveEnd;
    private final boolean descending;
    private final boolean emptyLocalHistory;
    private final BHistoryRecord firstLocalRecord;
    private BArchiveHistoryProvider archiveHistoryProvider;
    private Context connectionCx;
    private Cursor<BHistoryRecord> archiveCursor;
    private boolean drainedFirstCursor;
    private boolean iterationStarted;
    private boolean includeArchiveData = true;

    HybridHistoryCursor(BHistoryConfig config, Cursor<BHistoryRecord> localCursor, BAbsTime archiveStart, BAbsTime archiveEnd, boolean descending, boolean emptyLocalHistory, BHistoryRecord firstLocalRecord) {
        super(config, null, null);
        this.localCursor = localCursor;
        this.archiveStart = archiveStart;
        this.archiveEnd = archiveEnd;
        this.descending = descending;
        this.emptyLocalHistory = emptyLocalHistory;
        this.firstLocalRecord = firstLocalRecord;
    }

    @Override
    public void setConnectionContext(Context connectionCx) {
        if (this.iterationStarted) {
            throw new IllegalStateException("Cannot set the connection Context because iteration of the Cursor has already started.");
        }
        this.connectionCx = connectionCx;
        this.includeArchiveData = !HistoryQuery.excludeArchiveData(connectionCx);
    }

    @Override
    public Context getContext() {
        Context cx = this.localCursor.getContext();
        Context archiveCx = null;
        if (this.includeArchiveData && this.getArchiveCursor() != null) {
            archiveCx = this.getArchiveCursor().getContext();
        }
        if (archiveCx != null) {
            BHistoryRecord preRec;
            BHistoryRecord postRec;
            if (HistoryCursor.archiveLimitExceeded(archiveCx)) {
                cx = HistoryCursor.makeArchiveLimitExceededContext(cx);
            }
            if (this.descending) {
                postRec = BHistoryTimeQuery.getPostRecFromContext(archiveCx);
                BHistoryRecord archivePreRec = BHistoryTimeQuery.getPreRecFromContext(archiveCx);
                preRec = this.firstLocalRecord != null ? (archivePreRec != null ? archivePreRec : this.firstLocalRecord) : (this.emptyLocalHistory && archivePreRec != null ? archivePreRec : BHistoryTimeQuery.getPreRecFromContext(cx));
            } else {
                preRec = BHistoryTimeQuery.getPreRecFromContext(archiveCx);
                BHistoryRecord archivePostRec = BHistoryTimeQuery.getPostRecFromContext(archiveCx);
                postRec = this.firstLocalRecord != null ? (archivePostRec != null ? archivePostRec : this.firstLocalRecord) : (this.emptyLocalHistory && archivePostRec != null ? archivePostRec : BHistoryTimeQuery.getPostRecFromContext(cx));
            }
            try {
                cx = new BasicContext(cx, HistoryCursor.makeBoundaryRecordFacets(preRec, postRec));
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to create context for HybridHistoryCursor", e);
            }
        }
        return cx;
    }

    @Override
    protected boolean doNext(BHistoryRecord iteratorRec) {
        boolean hasNext;
        if (!this.iterationStarted) {
            ArchiveHistoryWorkbenchNotifier.getInstance().extendPendingDelayedNotification(this.connectionCx);
        }
        this.iterationStarted = true;
        if (this.drainedFirstCursor) {
            hasNext = this.getLastCursor().next();
        } else if (this.getFirstCursor().next()) {
            hasNext = true;
        } else {
            this.drainedFirstCursor = true;
            ArchiveHistoryWorkbenchNotifier.getInstance().extendPendingDelayedNotification(this.connectionCx);
            hasNext = this.getLastCursor().next();
        }
        if (!hasNext && this.archiveCursor != null) {
            Context cx = this.archiveCursor.getContext();
            ArchiveHistoryWorkbenchNotifier.getInstance().checkForExceededArchiveLimitNotification(this.archiveHistoryProvider, this.connectionCx, this.getConfig(), cx, this.archiveStart, this.archiveEnd);
            if (LOG.isLoggable(Level.FINE) && HistoryCursor.archiveLimitExceeded(cx)) {
                String id = this.getConfig() != null ? Objects.toString((Object)this.getConfig().getId()) : "unknown";
                String limit = this.archiveHistoryProvider != null ? Objects.toString(this.archiveHistoryProvider.computeArchiveQueryLimit(this.connectionCx)) : "unknown";
                String pathToProvider = this.archiveHistoryProvider != null ? this.archiveHistoryProvider.toPathString() : "unknown";
                LOG.fine("Exceeded the specified archive query limit (limit = " + limit + ") for a history query that tapped the '" + pathToProvider + "' archive history provider. Results are truncated for archive history query with parameters id = " + id + ", query start = " + this.archiveStart + ", query end = " + this.archiveEnd + ", descending = " + this.descending);
            }
        }
        return hasNext;
    }

    @Override
    public BHistoryRecord doGet() {
        if (this.drainedFirstCursor) {
            return (BHistoryRecord)this.getLastCursor().get();
        }
        return (BHistoryRecord)this.getFirstCursor().get();
    }

    protected void closeCursor() {
        try {
            this.localCursor.close();
        }
        finally {
            if (this.archiveCursor != null) {
                this.archiveCursor.close();
            }
        }
    }

    private Cursor<BHistoryRecord> getFirstCursor() {
        if (this.descending) {
            return this.localCursor;
        }
        return this.getArchiveCursor();
    }

    private Cursor<BHistoryRecord> getLastCursor() {
        if (this.descending) {
            return this.getArchiveCursor();
        }
        if (this.firstLocalRecord == null) {
            return this.localCursor;
        }
        return EMPTY_CURSOR;
    }

    private Cursor<BHistoryRecord> getArchiveCursor() {
        if (this.archiveCursor == null) {
            if (!this.includeArchiveData) {
                this.archiveCursor = EMPTY_CURSOR;
            } else {
                Exception ex;
                block12: {
                    ex = null;
                    try {
                        Optional<Object> recordCursor;
                        BHistoryService historyService;
                        List<BArchiveHistoryProvider> providers;
                        Optional service = Sys.findService((Type)BHistoryService.TYPE);
                        if (!service.isPresent() || (providers = (historyService = (BHistoryService)((Object)service.get())).getArchiveHistoryProviders().listProviders(true)).isEmpty()) break block12;
                        ArrayList<BArchiveHistoryProvider> quickMatchesChecked = new ArrayList<BArchiveHistoryProvider>();
                        for (BArchiveHistoryProvider provider : providers) {
                            block13: {
                                if (!provider.isOperational() || !provider.isLikelyToContainArchivedHistory(this.getConfig(), this.connectionCx)) continue;
                                quickMatchesChecked.add(provider);
                                try {
                                    recordCursor = provider.timeQuery(this.getConfig(), this.archiveStart, this.archiveEnd, this.descending, this.connectionCx);
                                }
                                catch (Exception e) {
                                    recordCursor = Optional.empty();
                                    if (ex != null) break block13;
                                    ex = e;
                                }
                            }
                            if (!recordCursor.isPresent()) continue;
                            this.archiveCursor = (Cursor)recordCursor.get();
                            this.archiveHistoryProvider = provider;
                            return this.archiveCursor;
                        }
                        if (quickMatchesChecked.size() >= providers.size()) break block12;
                        for (BArchiveHistoryProvider provider : providers) {
                            block14: {
                                if (!provider.isOperational() || quickMatchesChecked.contains((Object)provider)) continue;
                                try {
                                    recordCursor = provider.timeQuery(this.getConfig(), this.archiveStart, this.archiveEnd, this.descending, this.connectionCx);
                                }
                                catch (Exception e) {
                                    recordCursor = Optional.empty();
                                    if (ex != null) break block14;
                                    ex = e;
                                }
                            }
                            if (!recordCursor.isPresent()) continue;
                            this.archiveCursor = (Cursor)recordCursor.get();
                            this.archiveHistoryProvider = provider;
                            return this.archiveCursor;
                        }
                    }
                    catch (Exception e) {
                        if (ex != null) break block12;
                        ex = e;
                    }
                }
                this.archiveHistoryProvider = null;
                this.archiveCursor = EMPTY_CURSOR;
                if (ex != null) {
                    String id = this.getConfig() != null ? Objects.toString((Object)this.getConfig().getId()) : "unknown";
                    LOG.log(Level.WARNING, ex, () -> "Failed to query archive history data for id = " + id + ", query start = " + this.archiveStart + ", query end = " + this.archiveEnd + ", descending = " + this.descending);
                }
            }
        }
        return this.archiveCursor;
    }
}

