/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.BFoxService;
import com.tridium.history.BHistory;
import com.tridium.history.file.HybridHistoryCursor;
import com.tridium.nre.util.CacheMap;
import com.tridium.nre.util.tuple.Pair;
import com.tridium.session.SessionManager;
import com.tridium.sys.Nre;
import com.tridium.util.ContextThread;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BArchiveHistoryProvider;
import javax.baja.history.db.BArchiveLimitNotificationBehavior;
import javax.baja.job.BJobService;
import javax.baja.space.BComponentSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeSubscriber;
import javax.baja.util.BNotification;
import javax.baja.util.Lexicon;

public final class ArchiveHistoryWorkbenchNotifier
implements Runnable,
BFoxService.FoxServerConnectionListener {
    private static final Object LOCK = new Object();
    private static final int NOTIFICATION_BATCH_SIZE = 8;
    private static final long THREAD_LINGER_TICKS = 60000L;
    private static final long TWO_TICKS = 2000L;
    private static final Integer CACHE_SIZE = AccessController.doPrivileged(() -> Integer.getInteger("niagara.history.archiveExceededNotificationCacheSize", 1000));
    private static volatile ArchiveHistoryWorkbenchNotifier instance;
    private final Map<BString, DelayedNotificationInfo> delayedNotificationMap = new ConcurrentHashMap<BString, DelayedNotificationInfo>();
    private final Map<String, Pair<BAbsTime, BAbsTime>> notificationCache = Collections.synchronizedMap(new CacheMap(CACHE_SIZE.intValue()));
    private volatile boolean isAlive;
    private volatile long keepAliveTicks;
    private volatile BFoxService foxService;
    private volatile ArchiveHistoryProviderTypeSubscriber providerTypeSubscriber;

    private ArchiveHistoryWorkbenchNotifier() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchiveHistoryWorkbenchNotifier getInstance() {
        ArchiveHistoryWorkbenchNotifier result = instance;
        if (result == null) {
            Object object = LOCK;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    instance = result = new ArchiveHistoryWorkbenchNotifier();
                }
            }
        }
        return result;
    }

    public static boolean isSingletonLoaded() {
        return instance != null;
    }

    void checkForExceededArchiveLimitNotification(BArchiveHistoryProvider provider, Context connectionCx, BHistoryConfig config, Context archiveCursorCx, BAbsTime requestedStart, BAbsTime requestedEnd) {
        block10: {
            Thread currentThread;
            if (provider == null || !HistoryCursor.archiveLimitExceeded(archiveCursorCx)) {
                return;
            }
            BArchiveLimitNotificationBehavior notificationBehavior = provider.getArchiveLimitNotifications();
            if (notificationBehavior.equals((Object)BArchiveLimitNotificationBehavior.neverNotify)) {
                return;
            }
            BString foxSessionId = ArchiveHistoryWorkbenchNotifier.getStringContextFacet(connectionCx, "foxSessionId");
            if (foxSessionId == null && (currentThread = Thread.currentThread()) instanceof ContextThread) {
                foxSessionId = ArchiveHistoryWorkbenchNotifier.getStringContextFacet(((ContextThread)currentThread).getContext(), "foxSessionId");
            }
            if (foxSessionId == null) {
                return;
            }
            String foxSessionIdStr = foxSessionId.toString();
            try {
                Thread currentThread2;
                FoxSession session = (FoxSession)SessionManager.getNiagaraSession((String)foxSessionIdStr, FoxSession.class);
                if (session == null || session.getRemoteHello().getString("station.name", null) != null || "Station".equals(session.getRemoteHello().getString("app.name", ""))) {
                    return;
                }
                Context cx = connectionCx;
                BString uuid = ArchiveHistoryWorkbenchNotifier.getStringContextFacet(connectionCx, "foxRemoteVmUuid");
                if (uuid == null && (currentThread2 = Thread.currentThread()) instanceof ContextThread) {
                    cx = ((ContextThread)currentThread2).getContext();
                    uuid = ArchiveHistoryWorkbenchNotifier.getStringContextFacet(cx, "foxRemoteVmUuid");
                }
                if (uuid == null) {
                    return;
                }
                BHistoryId id = config.getId();
                boolean isOncePerSession = notificationBehavior.equals((Object)BArchiveLimitNotificationBehavior.notifyOncePerQueryRangePerSession);
                if (!isOncePerSession || this.checkNewNotification(provider, foxSessionIdStr, id, requestedStart, requestedEnd)) {
                    this.keepAliveTicks = Clock.ticks();
                    Context context = cx;
                    this.delayedNotificationMap.compute(uuid, (key, info) -> {
                        if (info == null) {
                            return new DelayedNotificationInfo(Thread.currentThread(), Clock.ticks(), 2000L, id, isOncePerSession, context);
                        }
                        info.idsAndFrequency.put(id, isOncePerSession);
                        info.extendDelay(2000L);
                        return info;
                    });
                    this.checkNotificationThreadRunning();
                }
            }
            catch (Throwable t) {
                if (!HybridHistoryCursor.LOG.isLoggable(Level.WARNING)) break block10;
                HybridHistoryCursor.LOG.log(Level.WARNING, "An unexpected exception occurred while processing notifications for recent history queries that exceeded the archive limit.", t);
            }
        }
    }

    void extendPendingDelayedNotification(Context connectionCx) {
        this.extendPendingDelayedNotification(connectionCx, 2000L);
    }

    void extendPendingDelayedNotification(Context context, long delayTicks) {
        Thread currentThread;
        if (delayTicks <= 0L || this.delayedNotificationMap.isEmpty()) {
            return;
        }
        BString uuid = ArchiveHistoryWorkbenchNotifier.getStringContextFacet(context, "foxRemoteVmUuid");
        if (uuid == null && (currentThread = Thread.currentThread()) instanceof ContextThread) {
            uuid = ArchiveHistoryWorkbenchNotifier.getStringContextFacet(((ContextThread)currentThread).getContext(), "foxRemoteVmUuid");
        }
        if (uuid != null) {
            this.delayedNotificationMap.computeIfPresent(uuid, (key, info) -> {
                info.extendDelay(delayTicks);
                return info;
            });
        }
    }

    private boolean checkNewNotification(BArchiveHistoryProvider provider, String foxSessionId, BHistoryId id, BAbsTime requestedStart, BAbsTime requestedEnd) {
        boolean isNew;
        this.checkFoxServiceRegistration();
        this.checkTypeSubscriberRegistration(provider);
        String key = foxSessionId + '_' + id.encodeToString() + '_' + provider.getHandle();
        Pair<BAbsTime, BAbsTime> startEndPair = this.notificationCache.get(key);
        boolean bl = isNew = startEndPair == null || requestedStart != null && (startEndPair.getFirst() == null || requestedStart.isAfter((BAbsTime)startEndPair.getFirst())) || requestedEnd != null && (startEndPair.getSecond() == null || requestedEnd.isBefore((BAbsTime)startEndPair.getSecond()));
        if (isNew) {
            this.notificationCache.put(key, (Pair<BAbsTime, BAbsTime>)new Pair((Object)requestedStart, (Object)requestedEnd));
        }
        return isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotificationThreadRunning() {
        boolean initThread;
        ArchiveHistoryWorkbenchNotifier archiveHistoryWorkbenchNotifier = this;
        synchronized (archiveHistoryWorkbenchNotifier) {
            initThread = !this.isAlive;
        }
        if (initThread) {
            if (Sys.findService((Type)BJobService.TYPE).isPresent()) {
                archiveHistoryWorkbenchNotifier = this;
                synchronized (archiveHistoryWorkbenchNotifier) {
                    block11: {
                        if (!this.isAlive) {
                            this.isAlive = true;
                            try {
                                Thread thread = new Thread(Nre.mainThreadGroup, this, "ArchiveHistoryWorkbenchNotifier");
                                thread.setDaemon(true);
                                thread.start();
                            }
                            catch (RuntimeException e) {
                                this.isAlive = false;
                                this.delayedNotificationMap.clear();
                                if (!HybridHistoryCursor.LOG.isLoggable(Level.WARNING)) break block11;
                                HybridHistoryCursor.LOG.log(Level.WARNING, "An unexpected exception occurred while attempting to start a thread for processing notifications for recent history queries that exceeded the archive limit.", e);
                            }
                        }
                    }
                }
            }
            this.delayedNotificationMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.keepAliveTicks = Clock.ticks();
        while (true) {
            ArchiveHistoryWorkbenchNotifier archiveHistoryWorkbenchNotifier;
            ArchiveHistoryWorkbenchNotifier archiveHistoryWorkbenchNotifier2 = this;
            synchronized (archiveHistoryWorkbenchNotifier2) {
                if (!this.isAlive) {
                    break;
                }
            }
            try {
                BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
                this.delayedNotificationMap.forEach((uuid, info) -> {
                    if (info.timeRemaining() <= 0L) {
                        info = this.delayedNotificationMap.remove(uuid);
                        Lexicon lex = Lexicon.make((String)"history", (Context)info.cx);
                        String stationName = Sys.getStation() != null ? Sys.getStation().getStationName() : "";
                        BString notificationTitle = BString.make((String)lex.getText("archiveHistoryProvider.limitNotificationTitle", new Object[]{stationName}));
                        String notificationOncePerSession = "\n\n" + lex.getText("archiveHistoryProvider.limitNotificationOncePerSession");
                        StringBuilder msgArgument = null;
                        BNotification notification = null;
                        int batchCounter = 0;
                        boolean showOncePerSession = false;
                        ArrayList<BNotification> notificationList = new ArrayList<BNotification>();
                        for (Map.Entry<BHistoryId, Boolean> entry : info.idsAndFrequency.entrySet()) {
                            ++batchCounter;
                            if (notification == null) {
                                notification = new BNotification();
                                notification.add("title", (BValue)notificationTitle);
                                msgArgument = new StringBuilder();
                                notificationList.add(notification);
                            }
                            if (entry.getValue().booleanValue()) {
                                showOncePerSession = true;
                                msgArgument.append("\n* ");
                            } else {
                                msgArgument.append("\n   ");
                            }
                            msgArgument.append(ArchiveHistoryWorkbenchNotifier.getHistoryIdDisplayString(entry.getKey(), info.cx));
                            if (batchCounter < 8) continue;
                            StringBuilder notificationMsg = new StringBuilder(lex.getText("archiveHistoryProvider.limitNotificationMessage", new Object[]{msgArgument.toString()}));
                            if (showOncePerSession) {
                                notificationMsg.append(notificationOncePerSession);
                            }
                            notification.add("message", (BValue)BString.make((String)notificationMsg.toString()));
                            notification.add("vmUuid", (BValue)uuid);
                            notification = null;
                            batchCounter = 0;
                            showOncePerSession = false;
                        }
                        if (notification != null) {
                            StringBuilder notificationMsg = new StringBuilder(lex.getText("archiveHistoryProvider.limitNotificationMessage", new Object[]{msgArgument.toString()}));
                            if (showOncePerSession) {
                                notificationMsg.append(notificationOncePerSession);
                            }
                            notification.add("message", (BValue)BString.make((String)notificationMsg.toString()));
                            notification.add("vmUuid", (BValue)uuid);
                        }
                        Collections.reverse(notificationList);
                        notificationList.forEach(notif -> jobService.fireNotification(notif));
                    }
                    this.keepAliveTicks = Clock.ticks();
                });
                if (Clock.ticks() - this.keepAliveTicks > 60000L) {
                    archiveHistoryWorkbenchNotifier = this;
                    synchronized (archiveHistoryWorkbenchNotifier) {
                        if (Clock.ticks() - this.keepAliveTicks > 60000L) {
                            this.isAlive = false;
                            break;
                        }
                    }
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (ServiceNotFoundException snfe) {
                if (Sys.getStation() != null && Sys.getStation().isRunning() && HybridHistoryCursor.LOG.isLoggable(Level.WARNING)) {
                    HybridHistoryCursor.LOG.warning("Notifications for recent history queries that exceeded the archive limit cannot be sent because the JobService is not available.");
                }
                this.delayedNotificationMap.clear();
                this.notificationCache.clear();
                archiveHistoryWorkbenchNotifier = this;
                synchronized (archiveHistoryWorkbenchNotifier) {
                    this.isAlive = false;
                }
            }
            catch (InterruptedException snfe) {
                continue;
            }
            catch (Throwable t) {
                if (Sys.getStation() != null && Sys.getStation().isRunning() && HybridHistoryCursor.LOG.isLoggable(Level.WARNING)) {
                    HybridHistoryCursor.LOG.log(Level.WARNING, "An unexpected exception occurred while processing notifications for recent history queries that exceeded the archive limit.", t);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private static BString getStringContextFacet(Context context, String facetKey) {
        BObject uuid;
        if (context != null && (uuid = context.getFacet(facetKey)) instanceof BString) {
            return (BString)uuid;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getHistoryIdDisplayString(BHistoryId id, Context cx) {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            try (HistorySpaceConnection conn = service.getDatabase().getConnection(null);){
                Context context = cx == null ? BHistory.FULL_DISPLAY_NAME_CX : new BasicContext(cx, BHistory.FULL_DISPLAY_NAME_CX.getFacets());
                String string = conn.getHistory(id).getNavDisplayName(context);
                return string;
            }
        }
        catch (Exception exception) {
            return id.encodeToString();
        }
    }

    public void serverConnectionClosed(BFoxServerConnection connection, Throwable cause) {
        block2: {
            try {
                this.notificationCache.entrySet().removeIf(entry -> {
                    String key = (String)entry.getKey();
                    int separatorIdx = key.indexOf(95);
                    if (separatorIdx >= 0) {
                        String sessionId = key.substring(0, separatorIdx);
                        return SessionManager.getNiagaraSession((String)sessionId, FoxSession.class) == null;
                    }
                    return false;
                });
            }
            catch (Throwable t) {
                if (!HybridHistoryCursor.LOG.isLoggable(Level.WARNING)) break block2;
                HybridHistoryCursor.LOG.log(Level.WARNING, "Unexpected exception while cleaning archive history limit notification cache", t);
            }
        }
    }

    private void checkFoxServiceRegistration() {
        if (this.foxService == null || this.foxService.getComponentSpace() == null || !this.foxService.isRunning()) {
            try {
                this.foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
                this.foxService.registerServerConnectionListener((BFoxService.FoxServerConnectionListener)this);
            }
            catch (Throwable t) {
                this.foxService = null;
            }
        }
    }

    private void checkTypeSubscriberRegistration(BArchiveHistoryProvider provider) {
        if (this.providerTypeSubscriber == null) {
            this.providerTypeSubscriber = new ArchiveHistoryProviderTypeSubscriber(provider.getComponentSpace(), this);
            this.providerTypeSubscriber.setMask(BComponentEventMask.make((int[])new int[]{20, 0}));
            this.providerTypeSubscriber.subscribe(BArchiveHistoryProvider.TYPE, null);
        }
    }

    public void spy(SpyWriter out) throws IOException {
        out.startProps();
        out.trTitle((Object)"Archive History Workbench Notifier", 2);
        out.prop((Object)"Thread Active", this.isAlive);
        out.prop((Object)"Current Delayed Notification Count", this.delayedNotificationMap.size());
        out.prop((Object)"Current Cache Size of Previous Notifications", this.notificationCache.size());
        out.prop((Object)"Max Cache Size of Previous Notifications", (Object)CACHE_SIZE);
        if (this.keepAliveTicks > 0L) {
            out.prop((Object)"Time Since Last Activity", (Object)BRelTime.toString((long)(Clock.ticks() - this.keepAliveTicks)));
        }
        out.endProps();
    }

    private static class ArchiveHistoryProviderTypeSubscriber
    extends TypeSubscriber {
        private final ArchiveHistoryWorkbenchNotifier notifier;

        ArchiveHistoryProviderTypeSubscriber(BComponentSpace space, ArchiveHistoryWorkbenchNotifier notifier) {
            super(space);
            this.notifier = notifier;
        }

        public void event(BComponentEvent event) {
            block5: {
                int id = event.getId();
                BComponent comp = event.getSourceComponent();
                if (comp == null) {
                    return;
                }
                Object handle = comp.getHandle();
                if (handle == null) {
                    return;
                }
                if (id == 20 || id == 0 && (BArchiveHistoryProvider.maxArchiveResultsPerQuery.equals(event.getSlot()) || BArchiveHistoryProvider.archiveLimitNotifications.equals(event.getSlot()) || BArchiveHistoryProvider.enabled.equals(event.getSlot()))) {
                    try {
                        this.notifier.notificationCache.entrySet().removeIf(entry -> {
                            String key = (String)entry.getKey();
                            int separatorIdx = key.lastIndexOf(95);
                            if (separatorIdx >= 0) {
                                String cachedHandle = key.substring(separatorIdx + 1);
                                return handle.equals(cachedHandle);
                            }
                            return false;
                        });
                    }
                    catch (Throwable t) {
                        if (!HybridHistoryCursor.LOG.isLoggable(Level.WARNING)) break block5;
                        HybridHistoryCursor.LOG.log(Level.WARNING, "Unexpected exception while cleaning archive history limit notification cache", t);
                    }
                }
            }
        }
    }

    private static class DelayedNotificationInfo {
        WeakReference<Thread> initiatingThread;
        long startTicks;
        long delayTicks;
        final Map<BHistoryId, Boolean> idsAndFrequency = new LinkedHashMap<BHistoryId, Boolean>();
        Context cx;

        DelayedNotificationInfo(Thread initiatingThread, long startTicks, long delayTicks, BHistoryId id, boolean isOncePerSession, Context cx) {
            this.initiatingThread = new WeakReference<Thread>(initiatingThread);
            this.startTicks = startTicks;
            this.delayTicks = delayTicks;
            this.idsAndFrequency.put(id, isOncePerSession);
            this.cx = cx;
        }

        void extendDelay(long delayTicks) {
            Thread initialThread;
            Thread currentThread = Thread.currentThread();
            if (currentThread == (initialThread = (Thread)this.initiatingThread.get())) {
                this.startTicks = Clock.ticks();
                this.delayTicks = delayTicks;
            } else if (delayTicks > this.timeRemaining()) {
                this.initiatingThread = new WeakReference<Thread>(currentThread);
                this.startTicks = Clock.ticks();
                this.delayTicks = delayTicks;
            }
        }

        long timeRemaining() {
            return this.delayTicks - (Clock.ticks() - this.startTicks);
        }
    }
}

