/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.exporters;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.file.exporters.BITableToHtml;
import com.tridium.history.BHistory;
import com.tridium.history.exporters.BHistoryToCsv;
import com.tridium.history.util.HistoryUtil;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"history:History"})})
@NiagaraProperties(value={@NiagaraProperty(name="timeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT"), @NiagaraProperty(name="delta", type="boolean", defaultValue="false"), @NiagaraProperty(name="includeNonDefaultQueryParamsInHeader", type="boolean", defaultValue="true")})
public class BHistoryToHtml
extends BITableToHtml {
    @Generated
    public static final Property timeRange = BHistoryToHtml.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Property delta = BHistoryToHtml.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property includeNonDefaultQueryParamsInHeader = BHistoryToHtml.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryToHtml.class);
    private static final LexiconText TITLE_WITH_SINGLE_PARAM = LexiconText.make((String)"history", (String)"historyToHtml.titleWithSingleParam");
    private static final LexiconText TITLE_WITH_DOUBLE_PARAM = LexiconText.make((String)"history", (String)"historyToHtml.titleWithDoubleParam");

    @Generated
    public BDynamicTimeRange getTimeRange() {
        return (BDynamicTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BDynamicTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public boolean getDelta() {
        return this.getBoolean(delta);
    }

    @Generated
    public void setDelta(boolean v) {
        this.setBoolean(delta, v, null);
    }

    @Generated
    public boolean getIncludeNonDefaultQueryParamsInHeader() {
        return this.getBoolean(includeNonDefaultQueryParamsInHeader);
    }

    @Generated
    public void setIncludeNonDefaultQueryParamsInHeader(boolean v) {
        this.setBoolean(includeNonDefaultQueryParamsInHeader, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BTextFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "html";
    }

    public String getTitle(ExportOp op) {
        boolean defaultParams;
        BHistory history = (BHistory)op.get();
        String title = "history:" + history.getNavDisplayName((Context)new BasicContext((Context)op, BHistory.FULL_DISPLAY_NAME_CX.getFacets()));
        BDynamicTimeRange range = this.getTimeRange();
        boolean isDelta = this.getDelta();
        boolean bl = defaultParams = range.equals((Object)BDynamicTimeRange.DEFAULT) && !isDelta;
        if (!defaultParams && this.getIncludeNonDefaultQueryParamsInHeader()) {
            title = !range.equals((Object)BDynamicTimeRange.DEFAULT) && isDelta ? TITLE_WITH_DOUBLE_PARAM.getHtmlSafeText((Context)op, new Object[]{title, HistoryUtil.getRangeStr(range, (Context)op), BHistoryToCsv.DELTA_MODE.getText((Context)op)}) : (isDelta ? TITLE_WITH_SINGLE_PARAM.getHtmlSafeText((Context)op, new Object[]{title, BHistoryToCsv.DELTA_MODE.getText((Context)op)}) : TITLE_WITH_SINGLE_PARAM.getHtmlSafeText((Context)op, new Object[]{title, HistoryUtil.getRangeStr(range, (Context)op)}));
        }
        return title;
    }

    public void export(ExportOp op) throws Exception {
        BHistory history = (BHistory)op.get();
        BDynamicTimeRange range = this.getTimeRange();
        boolean isDelta = this.getDelta();
        if (range.equals((Object)BDynamicTimeRange.DEFAULT) && !isDelta) {
            this.export(history, op);
        } else {
            this.export(BHistoryToCsv.getHistoryQuery(history, range, isDelta, (Context)op), op);
        }
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 407 && BHistoryToCsv.HistoryToTablePdfHolder.HISTORY_TO_TABLE_PDF != null) {
            BHistoryToCsv.HistoryToTablePdfHolder.HISTORY_TO_TABLE_PDF.fw(407, a, b, c, d);
        }
        return super.fw(x, a, b, c, d);
    }
}

