/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import javax.baja.collection.AbstractCursor;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.sys.Context;

public class LocalDbCursor
extends AbstractCursor<BHistoryId> {
    private final BHistoryDatabase db;
    private final Context context;
    private BHistoryDevice[] devices;
    private int deviceIndex;
    private BIHistory[] histories;
    private int historyIndex;
    private BHistoryId current;
    private boolean done;

    public LocalDbCursor(BHistoryDatabase db, Context context) {
        this.db = db;
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    protected boolean advanceCursor() {
        if (this.done) {
            return false;
        }
        if (this.devices == null) {
            this.devices = this.db.listDevices();
            this.deviceIndex = 0;
            if (this.deviceIndex == this.devices.length) {
                this.done = true;
                return false;
            }
            this.histories = this.db.listHistories(this.devices[this.deviceIndex]);
            this.historyIndex = -1;
        }
        ++this.historyIndex;
        while (this.deviceIndex < this.devices.length && this.historyIndex == this.histories.length) {
            ++this.deviceIndex;
            if (this.deviceIndex == this.devices.length) continue;
            this.histories = this.db.listHistories(this.devices[this.deviceIndex]);
            this.historyIndex = 0;
        }
        if (this.deviceIndex == this.devices.length) {
            this.done = true;
            this.current = null;
            return false;
        }
        this.current = this.histories[this.historyIndex].getId();
        return true;
    }

    protected BHistoryId doGet() {
        return this.current;
    }
}

