/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.db.BHistoryDbTable;
import com.tridium.history.db.BLocalDbHistory;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.db.TableHandle;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.sys.Nre;
import com.tridium.sys.metrics.Metrics;
import java.io.File;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BStorageType;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public class LocalDbConnection
extends HistoryDatabaseConnection {
    private BLocalHistoryDatabase localDb;
    private Context cx;

    LocalDbConnection(BLocalHistoryDatabase db, Context cx) {
        this.localDb = db;
        this.cx = cx;
    }

    @Override
    public BHistoryDatabase getHistoryDatabase() {
        return this.localDb;
    }

    @Override
    public boolean exists(BHistoryId id) {
        this.localDb.checkOpen();
        return this.localDb.getConfig(id) != null;
    }

    @Override
    public BIHistory getHistory(BHistoryId historyId) {
        this.localDb.checkOpen();
        if (!this.exists(historyId)) {
            return null;
        }
        return new BLocalDbHistory(this.localDb, historyId, this.cx);
    }

    @Override
    public int getRecordCount(BIHistory history) throws HistoryException {
        return this.getTableHandle(history).getRecordCount();
    }

    @Override
    public BAbsTime getFirstTimestamp(BIHistory history) throws HistoryException {
        return this.getTableHandle(history).getFirstTimestamp();
    }

    @Override
    public BAbsTime getLastTimestamp(BIHistory history) throws HistoryException {
        return this.getTableHandle(history).getLastTimestamp();
    }

    @Override
    public BHistoryRecord getLastRecord(BIHistory history) throws HistoryException {
        return this.getTableHandle(history).getLastRecord();
    }

    @Override
    public void append(BIHistory history, BIHistoryRecordSet newRecords) throws HistoryException {
        this.getTableHandle(history).append(newRecords);
        if (this.localDb.hasHistoryEventListeners()) {
            this.localDb.fireHistoryEvent(BHistoryEvent.makeAppended(history.getId(), newRecords));
        }
    }

    @Override
    public void update(BIHistory history, BHistoryRecord record) throws HistoryException {
        if (record instanceof BTrendRecord) {
            BTrendRecord trec = (BTrendRecord)record;
            BTrendFlags inFlags = trec.getTrendFlags();
            trec.setTrendFlags(inFlags.set(8, true));
        }
        Auditor auditor = Nre.auditor;
        BHistoryRecord oldRecord = null;
        String userName = null;
        if (auditor != null && this.cx != null && this.cx.getUser() != null) {
            userName = this.cx.getUser().getUsername();
        }
        if (userName != null) {
            oldRecord = history.getConfig().makeRecord();
        }
        this.getTableHandle(history).update(oldRecord, record);
        if (oldRecord != null) {
            auditor.audit(new AuditEvent("Changed", "history:" + history.getId().encodeToString(), "Update " + record.getTimestamp().toString((Context)BHistoryRecord.TIMESTAMP_FACETS), oldRecord.toDataSummary(this.cx), record.toDataSummary(this.cx), userName));
        }
        if (this.localDb.hasHistoryEventListeners()) {
            this.localDb.fireHistoryEvent(BHistoryEvent.makeUpdated(history.getId(), record));
        }
    }

    @Override
    public Cursor<BHistoryRecord> scan(BIHistory history) throws HistoryException {
        return this.scan(history, false);
    }

    @Override
    public Cursor<BHistoryRecord> scan(BIHistory history, boolean descending) throws HistoryException {
        Cursor<BHistoryRecord> cursor = this.getTableHandle(history).scan(descending);
        if (cursor instanceof HistoryCursor) {
            ((HistoryCursor)cursor).setConnectionContext(this.cx);
        }
        return cursor;
    }

    @Override
    public BITable<BHistoryRecord> timeQuery(BIHistory history, BAbsTime startTime, BAbsTime endTime) throws HistoryException {
        return this.timeQuery(history, startTime, endTime, false);
    }

    @Override
    public BITable<BHistoryRecord> timeQuery(BIHistory history, BAbsTime startTime, BAbsTime endTime, boolean descending) throws HistoryException {
        return new BHistoryTimeQuery((BLocalDbHistory)history, startTime, endTime, descending, this.cx);
    }

    @Override
    public void flush(BIHistory history) {
        this.getTableHandle(history).flush();
    }

    @Override
    protected final void doCreateHistory(BHistoryConfig config) {
        BHistoryId id = config.getId();
        if (!Metrics.incrementHistory((String)id.getDeviceName(), (String)id.getHistoryName())) {
            BComplex comp = config.getParent();
            if (comp == null || comp instanceof BHistoryExt && !((BHistoryExt)comp).getFaultCause().contains("Exceeded Global Capacity history limit.")) {
                log.severe("Exceeded Global Capacity history limit.");
            }
            throw new HistoryException("Exceeded Global Capacity history limit.");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating history for " + (Object)((Object)id) + "...");
        }
        if (this.exists(id)) {
            throw new DuplicateHistoryException(id);
        }
        config = (BHistoryConfig)config.newCopy(true);
        BFileHistoryTable table = null;
        if (config.getStorageType() == BStorageType.file) {
            table = BFileHistoryTable.make(this.localDb, config, this.localDb.isLocal(id));
        } else {
            log.warning("Unsupported storage type: " + (Object)((Object)config.getStorageType()) + ", using file storage.");
            table = BFileHistoryTable.make(this.localDb, config, this.localDb.isLocal(id));
        }
        try {
            table.open();
        }
        catch (Exception e) {
            try {
                table.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new HistoryException(e);
        }
        table.close();
        this.localDb.getConfigIndex().add(id, config);
        if (log.isLoggable(Level.FINE)) {
            log.fine("History created for " + (Object)((Object)id) + ".");
        }
    }

    @Override
    public void recreateHistory(BHistoryConfig newConfig, boolean saveOld) {
        newConfig = (BHistoryConfig)newConfig.newCopy(true);
        this.localDb.checkOpen();
        if (!this.exists(newConfig.getId())) {
            this.createHistory(newConfig);
            return;
        }
        BHistoryDbTable origTable = this.getTable(newConfig.getId());
        TableHandle origHandle = origTable.getTableHandle();
        if (saveOld) {
            BHistoryId origId = newConfig.getId();
            String baseName = origId.getHistoryName();
            int index = 0;
            BHistoryId newId = BHistoryId.make(origId.getDeviceName(), baseName + "_cfg0");
            while (this.exists(newId)) {
                newId = BHistoryId.make(newId.getDeviceName(), baseName + "_cfg" + ++index);
            }
            this.renameHistory(origId, newId.getHistoryName());
            origTable.close();
        } else {
            this.deleteHistory(newConfig.getId());
        }
        this.createHistory(newConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doDeleteHistory(BHistoryId id) {
        BPermissions permissions;
        BIHistory history = this.getHistory(id);
        if (history != null && !(permissions = history.getPermissions(this.cx)).hasAdminWrite()) {
            throw new PermissionException("User does not have permission to delete history " + (Object)((Object)id));
        }
        Object object = this.localDb.getTableCache();
        synchronized (object) {
            Auditor auditor;
            File dirToRemove;
            BIHistory[] histories;
            BHistoryDevice histDev;
            BHistoryDbTable table = this.localDb.getTable(id);
            if (table == null) {
                File f = this.localDb.getFile(id, false);
                if (!f.exists()) {
                    throw new HistoryNotFoundException(id);
                }
                if (!f.delete()) {
                    throw new HistoryException("Cannot delete history " + (Object)((Object)id) + ".");
                }
            } else {
                table.close();
                table.delete();
                this.localDb.removeTable(id);
            }
            this.localDb.getConfigIndex().remove(id);
            String devName = id.getDeviceName();
            if (devName != null && (histDev = this.localDb.getDevice(devName)) != null && ((histories = this.localDb.getConfigIndex().listHistories(histDev, false)) == null || histories.length < 1) && (dirToRemove = this.localDb.getDeviceDirectory(devName)) != null) {
                this.localDb.deleteDirectory(dirToRemove);
                this.localDb.getConfigIndex().removeDevice(devName);
                BOrd parentOrd = BOrd.make((String)"local:|history:");
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)parentOrd, (String)devName, null));
            }
            if (this.getHistoryDatabase().hasHistoryEventListeners()) {
                this.getHistoryDatabase().fireHistoryEvent(BHistoryEvent.makeDeleted(id));
            }
            BOrd parentOrd = BOrd.make((String)("local:|history:/" + id.getDeviceName()));
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)parentOrd, (String)id.getHistoryName(), null));
            if (this.cx != null && (auditor = Nre.auditor) != null) {
                String userName = "";
                if (this.cx != null && this.cx.getUser() != null) {
                    userName = this.cx.getUser().getUsername();
                }
                auditor.audit(new AuditEvent("Removed", "history:" + id.encodeToString(), "", "", "", userName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRenameHistory(BHistoryId oldId, String historyName) {
        this.localDb.checkOpen();
        Object object = this.localDb.getTableCache();
        synchronized (object) {
            BHistoryDbTable table = this.getTable(oldId);
            if (table == null) {
                throw new HistoryNotFoundException(oldId);
            }
            Object object2 = table.getTableLock();
            synchronized (object2) {
                table.close();
                BHistoryId fNewId = BHistoryId.make(oldId.getDeviceName(), historyName);
                File fOldFile = this.localDb.getFile(oldId, false);
                File fNewFile = this.localDb.getFile(fNewId, true);
                boolean renamed = AccessController.doPrivileged(() -> fOldFile.renameTo(fNewFile));
                if (renamed) {
                    table.delete();
                    AccessController.doPrivileged(() -> {
                        BFileHistoryTable.setId(fNewFile, fNewId);
                        return null;
                    });
                    this.localDb.getConfigIndex().remove(oldId);
                    this.localDb.getConfigIndex().add(fNewId, this.getTable(fNewId).getConfig());
                    return;
                }
            }
            table = this.getTable(oldId);
            if (table == null) {
                throw new HistoryNotFoundException(oldId);
            }
            table.renameHistory(historyName);
        }
    }

    @Override
    public void clearAllRecords(BHistoryId id) {
        BPermissions permissions;
        BIHistory history = this.getHistory(id);
        if (history != null && !(permissions = history.getPermissions(this.cx)).hasAdminWrite()) {
            throw new PermissionException("User does not have permission to clear all records from history " + (Object)((Object)id));
        }
        BHistoryDbTable table = this.getTable(id);
        if (table == null) {
            throw new HistoryNotFoundException(id);
        }
        int oldCount = table.getRecordCount();
        table.clear();
        Auditor auditor = Nre.auditor;
        if (auditor != null) {
            String userName = "";
            if (this.cx != null && this.cx.getUser() != null) {
                userName = this.cx.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "history:" + id.encodeToString(), "Clear", Integer.toString(oldCount) + " records", Integer.toString(table.getRecordCount()) + " records", userName));
        }
        if (this.localDb.hasHistoryEventListeners()) {
            this.localDb.fireHistoryEvent(BHistoryEvent.makeClearedAll(id));
        }
    }

    @Override
    public void clearOldRecords(BHistoryId id, BAbsTime before) {
        BPermissions permissions;
        BIHistory history = this.getHistory(id);
        if (history != null && !(permissions = history.getPermissions(this.cx)).hasAdminWrite()) {
            throw new PermissionException("User does not have permission to clear old records from history " + (Object)((Object)id));
        }
        BHistoryDbTable table = this.getTable(id);
        if (table == null) {
            throw new HistoryNotFoundException(id);
        }
        int oldCount = table.getRecordCount();
        table.clear(before);
        Auditor auditor = Nre.auditor;
        if (auditor != null) {
            String userName = "";
            if (this.cx != null && this.cx.getUser() != null) {
                userName = this.cx.getUser().getUsername();
            }
            auditor.audit(new AuditEvent("Invoked", "history:" + id.encodeToString(), "Clear before " + before.toString((Context)BHistoryRecord.TIMESTAMP_FACETS), Integer.toString(oldCount) + " records", Integer.toString(table.getRecordCount()) + " records", userName));
        }
        if (this.localDb.hasHistoryEventListeners()) {
            this.localDb.fireHistoryEvent(BHistoryEvent.makeClearedOld(id, before));
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void resizeHistory(BHistoryId id, BCapacity capacity, BFullPolicy fullPolicy) {
        this.localDb.checkOpen();
        BHistoryDbTable table = this.getTable(id);
        if (table == null) {
            throw new HistoryNotFoundException(id);
        }
        table.resize(capacity, fullPolicy);
        if (this.localDb.hasHistoryEventListeners()) {
            this.localDb.fireHistoryEvent(BHistoryEvent.makeResized(id, capacity, fullPolicy));
        }
    }

    private TableHandle getTableHandle(BIHistory history) throws HistoryException {
        if (history == null) {
            throw new HistoryException("Cannot get table handle for null history");
        }
        if (history instanceof BLocalDbHistory) {
            return ((BLocalDbHistory)history).getTable();
        }
        throw new HistoryException((Object)((Object)history.getId()) + " is not a BLocalDbHistory");
    }

    private BHistoryDbTable getTable(BHistoryId id) {
        return this.localDb.getTable(id);
    }
}

