/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.collection;

import com.tridium.history.collection.ColumnSpec;
import com.tridium.history.collection.PathColumn;
import com.tridium.history.collection.PropertyColumn;
import java.util.ArrayList;
import java.util.HashMap;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.timezone.BTimeZone;

public class HistoryColumns
implements ColumnList {
    private ArrayList<Column> list;
    private HashMap<String, Column> table;

    public static HistoryColumns getColumns(BHistoryConfig config) {
        BHistoryRecord rec = config.makeRecord();
        Property[] props = rec.getPropertiesArray();
        HistoryColumns columns = new HistoryColumns(props.length);
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            BFacets facets = null;
            try {
                facets = (BFacets)config.get(prop.getName() + "Facets");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (prop.getType() == BAbsTime.TYPE) {
                BTimeZone timeZone = config.getTimeZone();
                if ((facets = facets != null ? BFacets.make((BFacets)facets, (String)"TimeZone", (BIDataValue)timeZone) : BFacets.make((String)"TimeZone", (BIDataValue)timeZone)).get("showSeconds") == null) {
                    facets = BFacets.make((BFacets)facets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
                }
            }
            columns.addColumn(new PropertyColumn(props[i], null, facets));
        }
        return columns;
    }

    public static HistoryColumns getColumns(BStruct rec, ColumnSpec[] specs) {
        HistoryColumns columns = new HistoryColumns(specs.length);
        for (int i = 0; i < specs.length; ++i) {
            BFacets facets = specs[i].facets;
            String colName = specs[i].name;
            if (colName.indexOf(46) == -1) {
                Property prop = rec.getProperty(specs[i].name);
                if (prop != null) {
                    columns.addColumn(new PropertyColumn(prop, specs[i].displayName, facets));
                    continue;
                }
                columns.addColumn(new PathColumn((BObject)rec, colName, specs[i].displayName, facets));
                continue;
            }
            columns.addColumn(new PathColumn((BObject)rec, colName, specs[i].displayName, facets));
        }
        return columns;
    }

    public HistoryColumns(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
        this.table = new HashMap();
    }

    public void addColumn(Column column) {
        this.list.add(column);
        this.table.put(column.getName(), column);
        if (this.list.size() != this.table.size()) {
            throw new BajaRuntimeException("Duplicate column: " + column.getName());
        }
    }

    public int size() {
        return this.list.size();
    }

    public Column get(int index) {
        return this.list.get(index);
    }

    public Column get(String name) {
        return this.table.get(name);
    }

    public int indexOf(String name) {
        int count = this.list.size();
        for (int i = 0; i < count; ++i) {
            if (!this.list.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public Column[] list() {
        return this.list.toArray(new Column[0]);
    }
}

