/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public class HistoryConfigChange {
    public static final int PROPERTY_ADDED = 0;
    public static final int PROPERTY_REMOVED = 1;
    public static final int PROPERTY_CHANGED = 2;
    private Property oldProp;
    private BValue oldValue;
    private Property newProp;
    private BValue newValue;
    private int changeType;

    public static HistoryConfigChange makeAdded(Property newProp, BValue newValue) {
        return new HistoryConfigChange(null, null, newProp, newValue, 0);
    }

    public static HistoryConfigChange makeRemoved(Property oldProp, BValue oldValue) {
        return new HistoryConfigChange(oldProp, oldValue, null, null, 1);
    }

    public static HistoryConfigChange makeChanged(Property oldProp, BValue oldValue, Property newProp, BValue newValue) {
        return new HistoryConfigChange(oldProp, oldValue, newProp, newValue, 2);
    }

    private HistoryConfigChange(Property oldProp, BValue oldValue, Property newProp, BValue newValue, int changeType) {
        this.oldProp = oldProp;
        this.oldValue = oldValue;
        this.newProp = newProp;
        this.newValue = newValue;
        this.changeType = changeType;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public Property getOldProperty() {
        return this.oldProp;
    }

    public BValue getOldValue() {
        return this.oldValue;
    }

    public Property getNewProperty() {
        return this.newProp;
    }

    public BValue getNewValue() {
        return this.newValue;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(32);
        switch (this.changeType) {
            case 0: {
                s.append("added ").append(this.newProp);
                break;
            }
            case 1: {
                s.append("removed ").append(this.oldProp);
                break;
            }
            case 2: {
                s.append("changed ");
                s.append(this.oldProp).append('=').append(this.oldValue);
                s.append(" -> ");
                s.append(this.newProp).append('=').append(this.newValue);
            }
        }
        return s.toString();
    }
}

