/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.AbstractCursor;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BRolloverValue;
import javax.baja.history.HistoryCursor;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public class DeltaCursor
extends AbstractCursor<BHistoryRecord> {
    private static final Logger LOG = Logger.getLogger("history");
    private static final String PRE_HISTORY_REC_FACET = "historyCursorPreRec";
    private static final String POST_HISTORY_REC_FACET = "historyCursorPostRec";
    private final Cursor<BHistoryRecord> cursor;
    private final BRolloverValue minValue;
    private final BRolloverValue maxValue;
    private final BNumericTrendRecord referenceRecord;
    private final BIHistory history;
    private final Context cx;
    private BHistoryRecord iteratorRec;
    private boolean firstRecord = true;
    private double lastValue = Double.NaN;
    private BStatus lastStatus = BStatus.DEFAULT;
    private volatile Context cursorContext;

    public DeltaCursor(Cursor<BHistoryRecord> cursor, BRolloverValue minValue, BRolloverValue maxValue, BNumericTrendRecord referenceRecord, BIHistory history, Context cx) {
        this.cursor = cursor;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.referenceRecord = referenceRecord;
        this.history = history;
        this.cx = cx;
    }

    public Context getContext() {
        if (this.cursorContext != null) {
            return this.cursorContext;
        }
        Context origContext = this.cursor.getContext();
        BHistoryRecord preRec = DeltaCursor.toDeltaRecord(BHistoryTimeQuery.getPreRecFromContext(origContext), this.history, this.cx);
        BHistoryRecord postRec = DeltaCursor.toDeltaRecord(BHistoryTimeQuery.getPostRecFromContext(origContext), this.history, this.cx);
        try {
            this.cursorContext = new DeltaCursorContext(origContext, HistoryCursor.makeBoundaryRecordFacets(preRec, postRec));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to create context for DeltaCursor", e);
        }
        return this.cursorContext;
    }

    private static BHistoryRecord toDeltaRecord(BHistoryRecord record, BIHistory history, Context context) {
        if (record instanceof BNumericTrendRecord) {
            BNumericTrendRecord recordBefore = BHistoryDeltaQuery.getReferenceRecord(history, record.getTimestamp(), context);
            if (recordBefore == null) {
                return null;
            }
            BNumericTrendRecord numericRec = (BNumericTrendRecord)record;
            BNumericTrendRecord replacementRec = (BNumericTrendRecord)record.newCopy(true);
            replacementRec.setValue(numericRec.getValue() - recordBefore.getValue());
            BStatus status = BStatus.make((int)(numericRec.getStatus().getBits() | recordBefore.getStatus().getBits()), (BFacets)BFacets.make((BFacets)recordBefore.getStatus().getFacets(), (BFacets)numericRec.getStatus().getFacets()));
            replacementRec.setStatus(status);
            return replacementRec;
        }
        return record;
    }

    protected boolean advanceCursor() {
        boolean retVal = this.cursor.next();
        if (retVal) {
            BHistoryRecord obj = (BHistoryRecord)this.cursor.get();
            if (obj instanceof BNumericTrendRecord) {
                double deltaVal;
                BNumericTrendRecord rec = (BNumericTrendRecord)obj;
                double val = rec.getValue();
                BStatus stat = rec.getStatus();
                if (this.firstRecord) {
                    this.firstRecord = false;
                    if (this.referenceRecord == null) {
                        this.lastValue = val;
                        this.lastStatus = stat;
                        return this.next();
                    }
                    this.lastValue = this.referenceRecord.getValue();
                    this.lastStatus = this.referenceRecord.getStatus();
                }
                if (this.maxValue != null && !this.maxValue.getUnspecified() && val < this.lastValue) {
                    double min = 0.0;
                    if (this.minValue != null && !this.minValue.getUnspecified()) {
                        min = this.minValue.getValue();
                    }
                    deltaVal = this.maxValue.getValue() - this.lastValue + val - min;
                } else {
                    deltaVal = val - this.lastValue;
                }
                BStatus status = BStatus.make((int)(stat.getBits() | this.lastStatus.getBits()), (BFacets)BFacets.make((BFacets)this.lastStatus.getFacets(), (BFacets)stat.getFacets()));
                if (!Double.isNaN(val)) {
                    this.lastValue = val;
                    this.lastStatus = stat;
                }
                rec.setValue(deltaVal);
                rec.setStatus(status);
                this.iteratorRec = rec;
            } else if (obj instanceof BHistoryRecord) {
                this.iteratorRec = obj;
            } else {
                retVal = false;
            }
        }
        return retVal;
    }

    public boolean nextComponent() {
        return false;
    }

    protected BHistoryRecord doGet() {
        return this.iteratorRec;
    }

    protected void closeCursor() {
        this.cursor.close();
    }

    private static class DeltaCursorContext
    extends BasicContext {
        public DeltaCursorContext(Context base, BFacets boundaryRecordFacets) {
            super(base, boundaryRecordFacets);
            BFacets baseFacets;
            if (base != null && (baseFacets = base.getFacets()) != null) {
                BFacets boundaryFacets;
                BFacets bFacets = boundaryFacets = boundaryRecordFacets != null ? boundaryRecordFacets : BFacets.NULL;
                if (baseFacets.get(DeltaCursor.PRE_HISTORY_REC_FACET) != null && boundaryFacets.get(DeltaCursor.PRE_HISTORY_REC_FACET) == null) {
                    this.facets = BFacets.makeRemove((BFacets)this.facets, (String)DeltaCursor.PRE_HISTORY_REC_FACET);
                }
                if (baseFacets.get(DeltaCursor.POST_HISTORY_REC_FACET) != null && boundaryFacets.get(DeltaCursor.POST_HISTORY_REC_FACET) == null) {
                    this.facets = BFacets.makeRemove((BFacets)this.facets, (String)DeltaCursor.POST_HISTORY_REC_FACET);
                }
            }
        }
    }
}

