/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import javax.baja.history.BHistoryService;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BHistoryExtStatusJob
extends BJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryExtStatusJob.class);
    private static final int BATCH_SIZE = 20;
    BHistoryService historyService;
    BVector extOrds;
    boolean enableExt;
    boolean canceled = false;
    JobThread thread;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryExtStatusJob(BHistoryService historyService, BVector extOrds, boolean enableExt) {
        this.historyService = historyService;
        this.extOrds = extOrds;
        this.enableExt = enableExt;
    }

    public BHistoryExtStatusJob() {
    }

    public void doRun(Context cx) {
        this.thread = new JobThread(this.toPathString(), cx);
        this.thread.start();
    }

    public void run(Context cx) throws Exception {
        if (this.historyService == null) {
            throw new IllegalStateException("Must submit thru HistoryService.enable/disableExtensions()");
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        boolean success = true;
        String enableText = this.enableExt ? "Enabling" : "Disabling";
        this.log().start(enableText + " Selected History Extensions");
        int iteration = 0;
        int total = this.extOrds.getSlotCount();
        if (total <= 0) {
            total = 1;
        }
        SlotCursor c = this.extOrds.getProperties();
        while (c.next(BOrd.class)) {
            if (iteration % 20 == 0) {
                this.progress((int)((float)iteration / (float)total * 100.0f));
            }
            ++iteration;
            BOrd extOrd = (BOrd)c.get();
            BHistoryExt ext = null;
            try {
                ext = (BHistoryExt)extOrd.resolve((BObject)this.historyService).get();
                if (ext.getEnabled() != this.enableExt) {
                    ext.setEnabled(this.enableExt);
                }
            }
            catch (Exception ex) {
                this.log().failed("  Encountered Problem " + enableText + " " + (ext != null ? ext.getName() : "an unknown history extension.  "), (Throwable)ex);
                success = false;
            }
            if (!this.canceled) continue;
            break;
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        if (success) {
            this.log().success(enableText + " Selected History Extensions Complete");
        } else {
            this.log().failed("Encountered Problems " + enableText + " Selected History Extensions");
        }
    }

    public void doCancel(Context cx) {
        this.canceled = true;
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    class JobThread
    extends Thread {
        Context cx;

        JobThread(String name, Context cx) {
            super(name);
            this.cx = cx;
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                BHistoryExtStatusJob.this.run(this.cx);
                BHistoryExtStatusJob.this.success();
            }
            catch (Throwable e) {
                BHistoryExtStatusJob.this.failed(e);
            }
        }
    }
}

