/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.signing;

import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BSelfSignedDialog;
import com.tridium.program.ui.signing.BCodeSigningOptions;
import com.tridium.workbench.fieldeditors.BWbCertificateAliasFE;
import java.security.AccessController;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="createButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BCertificateNotSelectedDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BCertificateNotSelectedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action createButtonPressed = BCertificateNotSelectedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BCertificateNotSelectedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action setModified = BCertificateNotSelectedDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateNotSelectedDialog.class);
    private String result;
    private BButton okButton;
    private BButton createButton;
    private BButton cancelButton;
    private BWbCertificateAliasFE aliasFe;
    protected static final Lexicon lex = Lexicon.make((String)"program");

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void createButtonPressed(BWidgetEvent parameter) {
        this.invoke(createButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertificateNotSelectedDialog(BWidget owner) throws Exception {
        super(owner, lex.getText("program.certNotSelected.title"), true);
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    public static String show(BWidget owner) throws Exception {
        BCertificateNotSelectedDialog dialog = new BCertificateNotSelectedDialog(owner);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BWidget buildDialog() throws Exception {
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.buildHeader());
        pane.setCenter(this.buildContent());
        pane.setBottom(this.buildButtonPane());
        return pane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(null, lex.getText("program.certNotSelected.title"), lex.get("program.certNotSelected.description"));
    }

    private BWidget buildContent() {
        this.aliasFe = new BWbCertificateAliasFE();
        this.aliasFe.loadValue((BObject)BString.make((String)BCodeSigningOptions.make().getSigningCert()));
        BGridPane grid = new BGridPane(2);
        grid.setColumnAlign(BHalign.center);
        grid.setHalign(BHalign.center);
        grid.setColumnGap(5.0);
        grid.add(null, (BValue)new BLabel(lex.getText("program.certNotSelected.alias")));
        grid.add(null, (BValue)this.aliasFe);
        return new BBorderPane((BWidget)grid, 7.0, 7.0, 7.0, 7.0);
    }

    private BWidget buildButtonPane() throws Exception {
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.createButton = new BButton(lex.getText("program.certNotSelected.create"));
        String alias = ((BString)this.aliasFe.saveValue()).getString();
        this.okButton.setEnabled(alias != null && !alias.isEmpty());
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.linkTo("linkC", (BComponent)this.createButton, (Slot)BButton.actionPerformed, (Slot)createButtonPressed);
        this.linkTo("linkD", (BComponent)this.aliasFe, (Slot)BWbPlugin.setModified, (Slot)setModified);
        BGridPane buttonPane = new BGridPane(3);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        buttonPane.add(null, (BValue)this.okButton);
        buttonPane.add(null, (BValue)this.createButton);
        buttonPane.add(null, (BValue)this.cancelButton);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 7.0, 7.0);
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        this.result = ((BString)this.aliasFe.saveValue()).getString();
        this.close();
    }

    public void doCreateButtonPressed(BWidgetEvent event) throws Exception {
        CoreCryptoManager ccm = AccessController.doPrivileged(() -> {
            try {
                return CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
            }
            catch (Exception e) {
                return null;
            }
        });
        this.setContent((BWidget)new BLabel(lex.getText("program.certNotSelected.generating")));
        BSelfSignedDialog dialog = new BSelfSignedDialog((BWidget)this, ccm.getKeyStore());
        dialog.setKeyPurpose(KeyPurpose.CODE_SIGNING_CERT);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        BCertsTable.CertGenRequest req = dialog.getResult((ICoreCryptoManager)ccm);
        if (req == null) {
            this.result = null;
            this.close();
            return;
        }
        new Thread(new CertGenMonitor(ccm, req)).start();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) throws Exception {
        String alias = ((BString)this.aliasFe.saveValue()).getString();
        this.okButton.setEnabled(alias != null && !alias.isEmpty());
    }

    public String getResult() {
        return this.result;
    }

    private class CertGenMonitor
    implements Runnable {
        private final CoreCryptoManager ccm;
        private final BCertsTable.CertGenRequest req;

        public CertGenMonitor(CoreCryptoManager ccm, BCertsTable.CertGenRequest req) {
            this.ccm = ccm;
            this.req = req;
        }

        @Override
        public void run() {
            BCertificateNotSelectedDialog.this.enterBusy();
            while (true) {
                int status;
                if ((status = this.ccm.getCertGenerationStatus(this.req.getRequestId())) == -1) {
                    BCertificateNotSelectedDialog.this.result = null;
                    break;
                }
                if (status == 2) {
                    BCertificateNotSelectedDialog.this.result = this.req.getAlias();
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            BCertificateNotSelectedDialog.this.exitBusy();
            BCertificateNotSelectedDialog.this.close();
        }
    }
}

