/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui;

import com.tridium.util.EscUtil;
import java.util.ArrayList;
import java.util.List;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="labelMargin", type="double", defaultValue="10d"), @NiagaraProperty(name="rowGap", type="double", defaultValue="8d"), @NiagaraProperty(name="indent", type="double", defaultValue="0d")})
@NiagaraAction(name="handleEditorModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BFieldSheet
extends BWbEditor {
    @Generated
    public static final Property labelMargin = BFieldSheet.newProperty((int)0, (double)10.0, null);
    @Generated
    public static final Property rowGap = BFieldSheet.newProperty((int)0, (double)8.0, null);
    @Generated
    public static final Property indent = BFieldSheet.newProperty((int)0, (double)0.0, null);
    @Generated
    public static final Action handleEditorModified = BFieldSheet.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFieldSheet.class);
    public static final String FORCE_SHOW = "fieldSheetShow";
    static final BColor dividerColor = BColor.make((int)0xBBBBBB);
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    boolean showModified;
    private List<Field> fields;
    private double[] divs;

    @Generated
    public double getLabelMargin() {
        return this.getDouble(labelMargin);
    }

    @Generated
    public void setLabelMargin(double v) {
        this.setDouble(labelMargin, v, null);
    }

    @Generated
    public double getRowGap() {
        return this.getDouble(rowGap);
    }

    @Generated
    public void setRowGap(double v) {
        this.setDouble(rowGap, v, null);
    }

    @Generated
    public double getIndent() {
        return this.getDouble(indent);
    }

    @Generated
    public void setIndent(double v) {
        this.setDouble(indent, v, null);
    }

    @Generated
    public void handleEditorModified(BWidgetEvent parameter) {
        this.invoke(handleEditorModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFieldSheet() {
        this(true);
    }

    public BFieldSheet(boolean showModified) {
        this.showModified = showModified;
    }

    public void doLoadValue(BObject o, Context cx) {
        BComponent obj = (BComponent)o;
        Property[] props = obj.getPropertiesArray();
        this.fields = new ArrayList<Field>();
        for (int i = 0; i < props.length; ++i) {
            Property prop = props[i];
            if (Flags.isHidden((BComplex)obj, (Slot)prop) || prop.isDynamic() && !prop.getFacets().getb(FORCE_SHOW, false)) continue;
            BValue propValue = obj.get(prop);
            BWbFieldEditor ed = BWbFieldEditor.makeFor((BObject)propValue, (Context)prop.getFacets());
            ed.setReadonly((prop.getDefaultFlags() & 1) != 0);
            ed.loadValue((BObject)propValue, (Context)new BasicContext(cx, prop.getFacets()));
            String ordList = prop.getFacets().gets("iconOverride", null);
            BImage icon = ordList != null ? BImage.make((BIcon)BIcon.make((String)ordList)) : BImage.make((BIcon)propValue.getIcon());
            if (icon == null) {
                icon = defaultIcon;
            }
            Field f = new Field(prop, new BLabel(icon, EscUtil.slot.unescape(prop.getName())), ed);
            f.icon = icon;
            this.add("label" + i, (BValue)f.label);
            this.add("editor" + i, (BValue)f.editor);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.setModified, (Slot)setModified);
            this.linkTo((BComponent)f.editor, (Slot)BWbFieldEditor.setModified, (Slot)handleEditorModified);
            this.fields.add(f);
        }
        this.divs = new double[this.fields.size()];
    }

    public BObject doSaveValue(BObject o, Context cx) throws Exception {
        BComponent obj = (BComponent)o;
        for (Field f : this.fields) {
            if (!f.editor.isModified()) continue;
            obj.set(f.prop, (BValue)f.editor.saveValue((BObject)obj.get(f.prop), cx));
        }
        for (Field field : this.fields) {
            field.editor.clearModified();
        }
        this.handleEditorModified(null);
        this.clearModified();
        return obj;
    }

    public void computePreferredSize() {
        if (this.fields == null) {
            this.setPreferredSize(0.0, 0.0);
            return;
        }
        double maxLabel = 0.0;
        double maxEditor = 0.0;
        double ph = 0.0;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = this.fields.get(i);
            f.label.computePreferredSize();
            f.editor.computePreferredSize();
            if (i == 0) {
                maxLabel = f.label.getPreferredWidth();
                maxEditor = f.editor.getPreferredWidth();
            } else {
                maxLabel = Math.max(maxLabel, f.label.getPreferredWidth());
                maxEditor = Math.max(maxEditor, f.editor.getPreferredWidth());
            }
            if (i != 0) {
                ph += this.getRowGap();
            }
            ph += Math.max(f.label.getPreferredHeight(), f.editor.getPreferredHeight());
        }
        this.setPreferredSize(this.getIndent() + maxLabel + maxEditor + this.getLabelMargin(), ph);
    }

    public void doLayout(BWidget[] kids) {
        if (this.fields == null) {
            return;
        }
        double labelWidth = 0.0;
        int fc = this.fields.size();
        for (int i = 0; i < fc; ++i) {
            Field f = this.fields.get(i);
            f.label.computePreferredSize();
            f.editor.computePreferredSize();
            labelWidth = i == 0 ? f.label.getPreferredWidth() : Math.max(labelWidth, f.label.getPreferredWidth());
        }
        double y = 0.0;
        double indent = this.getIndent();
        for (int i = 0; i < fc; ++i) {
            Field field = this.fields.get(i);
            double rowHeight = Math.max(field.label.getPreferredHeight(), field.editor.getPreferredHeight());
            field.label.setBounds(indent, y + (rowHeight - field.label.getPreferredHeight()) / 2.0, field.label.getPreferredWidth(), rowHeight);
            field.editor.setBounds(indent + labelWidth + this.getLabelMargin(), y + (rowHeight - field.editor.getPreferredHeight()) / 2.0, field.editor.getPreferredWidth(), rowHeight);
            this.divs[i] = y += rowHeight + this.getRowGap();
        }
    }

    public void paint(Graphics g) {
        this.paintChildren(g);
        for (double div : this.divs) {
            double y = div - this.getRowGap() / 2.0;
            g.setBrush(dividerColor);
            g.strokeLine(0.0, y, this.getWidth(), y);
        }
    }

    public void doHandleEditorModified(BWidgetEvent event) {
        if (!this.showModified) {
            return;
        }
        for (Field f : this.fields) {
            if (f.editor.isModified()) {
                f.label.setImage(f.icon.getHighlightedImage());
                continue;
            }
            f.label.setImage(f.icon);
        }
        this.repaint();
    }

    private class Field {
        public Property prop;
        public BLabel label;
        public BWbFieldEditor editor;
        public BImage icon;

        public Field(Property prop, BLabel label, BWbFieldEditor editor) {
            this.prop = prop;
            this.label = label;
            this.editor = editor;
        }
    }
}

