/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.rest.requests;

import com.tridium.awsUtils.AwsUtils;
import com.tridium.awsUtils.auth.AwsAccessCredentials;
import com.tridium.awsUtils.auth.AwsAuthUtils;
import com.tridium.awsUtils.rest.requests.IAwsHttpRequestFactory;
import com.tridium.awsUtils.rest.requests.IAwsRequest;
import com.tridium.nre.auth.GlibcSha256CryptAlgorithmBundle;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import javax.baja.nre.util.TextUtil;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;

public class AwsV4SignedHttpRequestFactory
implements IAwsHttpRequestFactory {
    private static final Clock CLOCK = Clock.systemUTC();
    private static final String AWS_4_REQUEST = "aws4_request";
    private static final String AWS_4 = "AWS4";
    private static final String algorithm = "AWS4-HMAC-SHA256";
    private static final String AWS_HOSTNAME_PROP = "aws.service.hostname";
    private static final String AWS_HOSTNAME = AccessController.doPrivileged(() -> System.getProperty(AWS_HOSTNAME_PROP, "amazonaws.com"));
    private final IAwsRequest request;
    private final AwsAccessCredentials credentials;

    public AwsV4SignedHttpRequestFactory(AwsAccessCredentials credentials, IAwsRequest request) {
        this.credentials = credentials;
        this.request = request;
    }

    @Override
    public Request buildRequest() throws IOException {
        String region = AwsUtils.sanitizeRegionForUrl(this.credentials.getRegion());
        String host = this.request.getServiceHostPrefix() + '.' + region + '.' + AWS_HOSTNAME;
        String endpoint = "https://" + host;
        StringBuilder fullUrlBuilder = new StringBuilder(endpoint).append(this.request.getRequestPath());
        if (!this.request.getCanonicalQueryString().isEmpty()) {
            fullUrlBuilder.append('?');
        }
        String fullUrl = fullUrlBuilder.append(this.request.getCanonicalQueryString()).toString();
        AwsV4SignedHttpRequestFactory.trace("fullUrl: " + fullUrl);
        OffsetDateTime utc = OffsetDateTime.now(CLOCK);
        String amzdate = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").format(utc);
        String dateStamp = DateTimeFormatter.ofPattern("yyyyMMdd").format(utc);
        String canonicalHeaders = "host:" + host + '\n' + "x-amz-date:" + amzdate + '\n';
        String signedHeaders = "host;x-amz-date";
        Request.Builder requestBuilder = new Request.Builder().url(fullUrl).header("host", host).header("x-amz-date", amzdate);
        try {
            String canonicalRequest = this.buildCanonicalRequest(canonicalHeaders, signedHeaders);
            String credentialScope = dateStamp + '/' + region + '/' + this.request.getService() + '/' + AWS_4_REQUEST;
            String stringToSign = AwsV4SignedHttpRequestFactory.buildStringToSign(canonicalRequest, amzdate, credentialScope);
            byte[] signingKey = AwsV4SignedHttpRequestFactory.getSignatureKey(this.credentials.getAccessKey().asString(true), dateStamp, region, this.request.getService());
            byte[] signatureBytes = AwsV4SignedHttpRequestFactory.hmac(signingKey, stringToSign.getBytes(StandardCharsets.UTF_8));
            String signature = TextUtil.bytesToHexString((byte[])signatureBytes);
            String authHeader = this.buildAuthorizationHeader(credentialScope, signedHeaders, signature);
            requestBuilder.header("Authorization", authHeader);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new IOException("Failed to build AWS request", e);
        }
        if ("POST".equals(this.request.getMethod())) {
            String payload = this.request.getPayload();
            requestBuilder.post(RequestBody.create((String)payload, (MediaType)MediaType.parse((String)payload)));
        } else {
            requestBuilder.get();
        }
        return requestBuilder.build();
    }

    private String buildCanonicalRequest(String canonicalHeaders, String signedHeaders) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String payloadHash = AwsV4SignedHttpRequestFactory.hashSha256(this.request.getPayload());
        String canonicalRequest = this.request.getMethod() + '\n' + this.request.getRequestPath() + '\n' + this.request.getCanonicalQueryString() + '\n' + canonicalHeaders + '\n' + signedHeaders + '\n' + payloadHash;
        AwsV4SignedHttpRequestFactory.trace("Canonical Request String: '" + canonicalRequest + '\'');
        return canonicalRequest;
    }

    private static String buildStringToSign(String canonicalRequest, String amzdate, String credentialScope) throws NoSuchAlgorithmException {
        String hashedRequest = AwsV4SignedHttpRequestFactory.hashSha256(canonicalRequest);
        String stringToSign = algorithm + '\n' + amzdate + '\n' + credentialScope + '\n' + hashedRequest;
        AwsV4SignedHttpRequestFactory.trace("String to sign: '" + stringToSign + '\'');
        return stringToSign;
    }

    private static byte[] getSignatureKey(String key, String dateStamp, String region, String service) throws UnsupportedEncodingException {
        byte[] secret = (AWS_4 + key).getBytes(StandardCharsets.UTF_8);
        byte[] signedDate = AwsV4SignedHttpRequestFactory.sign(secret, dateStamp);
        byte[] signedRegion = AwsV4SignedHttpRequestFactory.sign(signedDate, region);
        byte[] signedService = AwsV4SignedHttpRequestFactory.sign(signedRegion, service);
        return AwsV4SignedHttpRequestFactory.sign(signedService, AWS_4_REQUEST);
    }

    private String buildAuthorizationHeader(String credentialScope, String signedHeaders, String signature) {
        String authHeader = algorithm + ' ' + "Credential=" + this.credentials.getAccessKeyId() + '/' + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        AwsV4SignedHttpRequestFactory.trace("Auth header: '" + authHeader + '\'');
        return authHeader;
    }

    private static byte[] sign(byte[] key, String message) throws UnsupportedEncodingException {
        return AwsV4SignedHttpRequestFactory.hmac(key, message.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] hmac(byte[] keyBytes, byte[] dataBytes) {
        GlibcSha256CryptAlgorithmBundle algorithmBundle = GlibcSha256CryptAlgorithmBundle.getInstance();
        try {
            Mac mac = Mac.getInstance(algorithmBundle.getMacAlgorithmName());
            if (keyBytes.length > 0) {
                mac.init(new SecretKeySpec(keyBytes, algorithmBundle.getSecretKeySpecAlgorithmName()));
            }
            return mac.doFinal(dataBytes);
        }
        catch (Exception e) {
            throw new SecurityException("Could not get hmac: " + e);
        }
    }

    private static String hashSha256(String in) throws NoSuchAlgorithmException {
        String alg = "SHA-256";
        MessageDigest digester = MessageDigest.getInstance(alg);
        digester.update(in.getBytes(StandardCharsets.UTF_8));
        byte[] bytes = digester.digest();
        return TextUtil.bytesToHexString((byte[])bytes);
    }

    private static void trace(String msg) {
        if (AwsAuthUtils.LOG.isLoggable(Level.FINEST)) {
            AwsAuthUtils.LOG.log(Level.FINEST, "AwsV4Signing " + msg);
        }
    }
}

