/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.iot.jitp;

import com.tridium.awsUtils.BAwsService;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.PemSource;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.profile.BSimpleSigningProfile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

@NiagaraType
public class BAwsSigningProfile
extends BSimpleSigningProfile {
    @Generated
    public static final Type TYPE = Sys.loadType(BAwsSigningProfile.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doValidateCsr(NPKCS10CertificationRequest csr) throws SigningServiceException {
        super.doValidateCsr(csr);
        X500Name subjectDN = csr.getSubjectDN();
        String commonName = (String)PemSource.extractOptionalCommonName((X500Name)subjectDN).orElseThrow(() -> new SigningServiceException(BAwsService.LEX, "aws.jitp.error.cn.notfound"));
        if (commonName.contains(".")) {
            throw new SigningServiceException(BAwsService.LEX, "aws.jitp.error.cn.badchar");
        }
        RDN[] countryValues = subjectDN.getRDNs(BCStyle.C);
        if (countryValues == null || countryValues.length == 0) {
            throw new SigningServiceException(BAwsService.LEX, "aws.jitp.error.c.missing");
        }
    }
}

