/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils.iot.jitp;

import com.tridium.awsUtils.BAwsService;
import com.tridium.awsUtils.auth.AwsAuthException;
import com.tridium.awsUtils.iot.jitp.AwsProvisioningException;
import com.tridium.awsUtils.iot.jitp.AwsProvisioningUtils;
import com.tridium.awsUtils.iot.jitp.BAwsCaProvisioningParams;
import com.tridium.awsUtils.iot.jitp.BCaCertificateSource;
import com.tridium.awsUtils.rest.AwsRestException;
import com.tridium.awsUtils.rest.requests.AwsDescribeEndpointRequest;
import com.tridium.awsUtils.rest.requests.AwsGetRegistrationCodeRequest;
import com.tridium.awsUtils.rest.requests.AwsRegisterCaCertRequest;
import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NSigningParameters;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.cert.PemSource;
import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.security.BPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.x500.X500Name;

@NiagaraType
public class BAwsJustInTimeProvisioningJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BAwsJustInTimeProvisioningJob.class);
    private BAwsCaProvisioningParams parameters;
    public static final String JITP_CERT_PREFIX = "aws-ca-";
    public static final int KEY_SIZE = 2048;
    private static final Lexicon LEX = Lexicon.make(BAwsJustInTimeProvisioningJob.class);
    private static final Logger LOGGER = Logger.getLogger("awsUtils.jitp.provisioning");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void run(Context cx) throws Exception {
        this.dualLog(LEX.get("aws.jitp.start"), Level.INFO);
        try {
            if (!BAwsJustInTimeProvisioningJob.getService().getEnabled()) {
                throw new AwsProvisioningException(LEX.get("aws.service.not.enabled"));
            }
            this.parameters = BAwsJustInTimeProvisioningJob.getService().getAwsIoT().getCaProvisioningParams();
            IX509CertificateEntry caCertificate = this.getCaCertificate();
            Objects.requireNonNull(caCertificate);
            String alias = caCertificate.getAlias();
            this.performCaCertRegistration(caCertificate, this.parameters.getAccessKeyId(), cx);
            BAwsJustInTimeProvisioningJob.getService().getAwsIoT().setProvisioningCaCertAlias(alias);
            this.progress(75);
            this.lookupEndpointAddress(this.parameters.getAccessKeyId(), cx);
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            LOGGER.log(Level.SEVERE, LEX.get("aws.jitp.error"), e);
            throw e;
        }
        finally {
            this.dualLog(LEX.get("aws.jitp.end"), Level.INFO);
        }
    }

    private void performCaCertRegistration(IX509CertificateEntry caCertificate, String accessKeyId, Context cx) throws AwsRestException, AwsAuthException, AwsProvisioningException, PrivilegedActionException {
        this.dualLog(LEX.get("aws.jitp.reg"), Level.INFO);
        BAwsService service = BAwsJustInTimeProvisioningJob.getService();
        JSONObject jsonObject = AccessController.doPrivileged(() -> service.sendAwsRequest(new AwsGetRegistrationCodeRequest(), accessKeyId, cx));
        String regCode = BAwsJustInTimeProvisioningJob.getJsonString(jsonObject, "registrationCode");
        this.progress(50);
        AwsRegisterCaCertRequest caCertRequest = this.registerCaCert(caCertificate, regCode);
        JSONObject json = AccessController.doPrivileged(() -> service.sendAwsRequest(caCertRequest, accessKeyId, cx));
        String certArn = BAwsJustInTimeProvisioningJob.getJsonString(json, "certificateArn");
        String certificateId = BAwsJustInTimeProvisioningJob.getJsonString(json, "certificateId");
        this.dualLog(LEX.getText("aws.jitp.cacert.registered", new Object[]{certArn, certificateId}), Level.INFO);
    }

    private static BAwsService getService() {
        return (BAwsService)Sys.getService((Type)BAwsService.TYPE).as(BAwsService.class);
    }

    private IX509CertificateEntry getCaCertificate() throws Exception {
        IX509CertificateEntry caCert = null;
        if (this.parameters.getCaCertificatePassword().isDefault()) {
            throw new AwsProvisioningException(LEX.getText("aws.jitp.error.nopassword"));
        }
        String caPassword = this.parameters.getCaCertificatePassword().getValue();
        if (this.parameters.getCaCertificateSource().equals((Object)BCaCertificateSource.generateNewCert)) {
            caCert = this.generateCaCert(caPassword);
            this.dualLog(LEX.getText("aws.jitp.gen", new Object[]{caCert.getAlias()}), Level.INFO);
        } else if (this.parameters.getCaCertificateSource().equals((Object)BCaCertificateSource.existingNiagaraCert)) {
            caCert = BAwsJustInTimeProvisioningJob.fetchCaCert(this.parameters.getExistingNiagaraCertAlias(), this.parameters.getCaCertificatePassword().getValue());
            this.dualLog(LEX.getText("aws.jitp.existing", new Object[]{this.parameters.getExistingNiagaraCertAlias()}), Level.INFO);
        }
        return caCert;
    }

    private IX509CertificateEntry generateCaCert(String caPassword) throws Exception {
        String aliasRoot;
        BRelTime expiryPeriod = this.parameters.getNewCaCertificateExpiryDays();
        CertificateDates dates = new CertificateDates(expiryPeriod);
        String caDN = this.parameters.getNewCaCertificateDn();
        X500Name x500Name = new X500Name(caDN);
        String commonName = BAwsJustInTimeProvisioningJob.extractCommonName(x500Name);
        caDN = x500Name.toString();
        String caAlias = aliasRoot = JITP_CERT_PREFIX + commonName;
        caAlias = AwsProvisioningUtils.getUniqueAlias(caAlias, this.parameters);
        NX509CertificateBuilder caCertBuilder = NX509CertificateBuilder.getInstance((KeyPurpose)KeyPurpose.CA_CERT).withAlias(caAlias).withSubjectDN(caDN).withIssuerDN(caDN).withNotBefore(dates.notBefore).withNotAfter(dates.notAfter);
        IX509CertificateEntry caCert = caCertBuilder.generateEntry((NKeyPairGenerator)new NRsaKeyPairGenerator(2048));
        ICryptoManager cryptoManager = CertManagerFactory.getInstance();
        cryptoManager.getKeyStore().setKeyEntry(caAlias, (Key)caCert.getPrivateKey(), caPassword.toCharArray(), new X509Certificate[]{caCert.getCertificate(0).getCertificate()});
        cryptoManager.getKeyStore().save();
        return caCert;
    }

    private static String extractCommonName(X500Name x500Name) throws AwsProvisioningException {
        return (String)PemSource.extractOptionalCommonName((X500Name)x500Name).orElseThrow(() -> new AwsProvisioningException(LEX.getText("aws.jitp.error.cn.notfound")));
    }

    private static NX509CertificateEntry fetchCaCert(String existingCaCertAlias, String caPassword) throws Exception {
        ICryptoManager cryptoManager = CertManagerFactory.getInstance();
        X509Certificate cert = cryptoManager.getKeyStore().getCertificate(existingCaCertAlias);
        PrivateKey key = (PrivateKey)cryptoManager.getKeyStore().getKey(existingCaCertAlias, caPassword.toCharArray());
        if (cert == null || key == null) {
            throw new AwsProvisioningException(LEX.getText("aws.jitp.error.fetchCa", new Object[]{existingCaCertAlias}));
        }
        return NX509CertificateEntry.make((String)existingCaCertAlias, (X509Certificate[])new X509Certificate[]{cert}, (PrivateKey)key);
    }

    private AwsRegisterCaCertRequest registerCaCert(IX509CertificateEntry caCert, String registrationCode) throws AwsProvisioningException {
        BRelTime expiryPeriod = this.parameters.getNewCaCertificateExpiryDays();
        CertificateDates dates = new CertificateDates(expiryPeriod);
        try {
            String verificationDN = "CN=" + registrationCode;
            NX509CertificateBuilder caCertBuilder = NX509CertificateBuilder.getInstance((KeyPurpose)KeyPurpose.CA_CERT).withSubjectDN(verificationDN).withIssuerDN(verificationDN).withNotBefore(dates.notBefore).withNotAfter(dates.notAfter);
            IX509CertificateEntry verificationCert = caCertBuilder.generateEntry((NKeyPairGenerator)new NRsaKeyPairGenerator(2048));
            NPKCS10CertificationRequest csr = CertUtils.generateCSR((IX509CertificateEntry)verificationCert);
            NX509Certificate signedVerificationCert = CertUtils.signCertificate((NPKCS10CertificationRequest)csr, (IX509CertificateEntry)caCert, (NSigningParameters)NSigningParameters.make((Date)dates.notBefore, (Date)dates.notAfter));
            String roleArn = AccessController.doPrivileged(() -> ((BPassword)this.parameters.getRoleArn()).getValue());
            return new AwsRegisterCaCertRequest(caCert, signedVerificationCert, roleArn);
        }
        catch (Exception e) {
            throw new AwsProvisioningException(LEX.getText("aws.jitp.error.register"), e);
        }
    }

    private void lookupEndpointAddress(String accessKeyId, Context cx) throws AwsRestException, AwsProvisioningException, AwsAuthException, PrivilegedActionException {
        BAwsService service = BAwsJustInTimeProvisioningJob.getService();
        JSONObject json = AccessController.doPrivileged(() -> service.sendAwsRequest(new AwsDescribeEndpointRequest(), accessKeyId, cx));
        String endpoint = BAwsJustInTimeProvisioningJob.getJsonString(json, "endpointAddress");
        this.dualLog(LEX.getText("aws.jitp.endpoint", new Object[]{endpoint}), Level.INFO);
        service.getAwsIoT().setMqttDataEndpoint(endpoint);
    }

    private static String getJsonString(JSONObject json, String key) throws AwsProvisioningException {
        try {
            return json.getString(key);
        }
        catch (JSONException e) {
            throw new AwsProvisioningException(LEX.getText("aws.jitp.error.response", new Object[]{key, json}));
        }
    }

    private void dualLog(String message, Level level) {
        this.log().message(message);
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, message);
        }
    }

    static class CertificateDates {
        private final Date notBefore = new Date();
        private final Date notAfter;

        public CertificateDates(BRelTime expiryPeriod) {
            BAbsTime expiry = BAbsTime.now().add(expiryPeriod);
            this.notAfter = new Date(expiry.getMillis());
        }
    }
}

