/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aceEdge.ui.conversion;

import com.tridium.ace.component.BAceComponent;
import com.tridium.driver.file.util.CsvParser;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.ord.BFileOrdChooser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="buttonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)})
public class BAceGenTblConvDialog
extends BDialog {
    @Generated
    public static final Action buttonPressed = BAceGenTblConvDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action setModified = BAceGenTblConvDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAceGenTblConvDialog.class);
    private BButton okButton;
    private BButton cancelButton;
    private BAceComponent generalTblConv;
    private BGridPane tablePane;
    private int nextIndex;
    private Array<Integer> map = new Array(Integer.class);
    private static final int MAX_ARRAY_SIZE = 20;
    private static Lexicon LEX = Lexicon.make(BAceGenTblConvDialog.class);
    private static final String INPUT_SLOT_NAME = "input";
    private static final String OUTPUT_SLOT_NAME = "output";
    private static final String TABLE_SIZE = "tableSize";

    @Generated
    public void buttonPressed(BWidgetEvent parameter) {
        this.invoke(buttonPressed, (BValue)parameter, null);
    }

    @Generated
    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAceGenTblConvDialog() {
    }

    public BAceGenTblConvDialog(BWidget parent, String title, BAceComponent target) {
        super(parent, title, true);
        this.generalTblConv = target;
        this.tablePane = new BGridPane(3);
        this.tablePane.setColumnAlign(BHalign.center);
        this.tablePane.setRowAlign(BValign.fill);
        this.tablePane.setValign(BValign.top);
        String[][] xy = this.getTableFromConv();
        this.buildTablePane(xy);
        BButton importButton = new BButton((Command)new ImportCmd());
        BButton exportButton = new BButton((Command)new ExportCmd());
        BButton resortButton = new BButton((Command)new ResortCmd());
        BButton addButton = new BButton((Command)new AddCmd());
        this.linkTo(null, (BComponent)importButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)exportButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)resortButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)addButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        BGridPane addbuttonPane = new BGridPane(1);
        addbuttonPane.setUniformColumnWidth(true);
        addbuttonPane.setColumnAlign(BHalign.fill);
        addbuttonPane.setValign(BValign.top);
        addbuttonPane.add(null, (BValue)importButton);
        addbuttonPane.add(null, (BValue)exportButton);
        addbuttonPane.add(null, (BValue)resortButton);
        addbuttonPane.add(null, (BValue)addButton);
        BGridPane okbuttonPane = new BGridPane(2);
        okbuttonPane.setColumnAlign(BHalign.fill);
        okbuttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton("OK");
        okbuttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.okButton.setEnabled(false);
        BButton cancelButton = new BButton("Cancel");
        okbuttonPane.add(null, (BValue)cancelButton);
        this.linkTo("linkB", (BComponent)cancelButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        BEdgePane outerPane = new BEdgePane();
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.tablePane));
        scrollPane.setVpolicy(BScrollBarPolicy.always);
        scrollPane.setHpolicy(BScrollBarPolicy.never);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT));
        constrainedPane.setFixedSize(250.0, 250.0);
        outerPane.setCenter((BWidget)new BBorderPane((BWidget)constrainedPane));
        outerPane.setRight((BWidget)new BBorderPane((BWidget)addbuttonPane));
        outerPane.setBottom((BWidget)new BBorderPane((BWidget)okbuttonPane));
        this.setContent((BWidget)outerPane);
        this.setDefaultButton(this.okButton);
    }

    private String[][] getTableFromConv() {
        int i;
        BDouble[] x = new BDouble[20];
        for (i = 0; i < 20; ++i) {
            x[i] = (BDouble)this.generalTblConv.get(INPUT_SLOT_NAME + (i + 1));
            if (i >= 1 && x[i - 1].compareTo((Object)x[i]) >= 0) break;
        }
        int len = i;
        String[][] xy = new String[len][2];
        for (i = 0; i < len; ++i) {
            xy[i][0] = x[i].toString();
            xy[i][1] = this.generalTblConv.get(OUTPUT_SLOT_NAME + (i + 1)).toString();
        }
        return xy;
    }

    private void initTablePane() {
        this.tablePane.removeAll();
        this.map.clear();
        this.nextIndex = 0;
        this.tablePane.add("xh", (BValue)new BLabel(LEX.get("aceEdge.conversion.dialog.inputLabel")));
        this.tablePane.add("yh", (BValue)new BLabel(LEX.get("aceEdge.conversion.dialog.outputLabel")));
        this.tablePane.add("dh", (BValue)new BNullWidget());
    }

    private void buildTablePane(String[][] xy) {
        this.initTablePane();
        int size = xy.length;
        if (size == 0) {
            return;
        }
        if (size > 20) {
            int ret = BDialog.confirm((BWidget)this, (Object)LEX.get("aceEdge.conversion.dialog.csvfileTooLong"));
            if (ret == 8) {
                return;
            }
            size = 20;
        }
        for (int i = 0; i < size; ++i) {
            if (xy[i].length != 2) {
                this.initTablePane();
                BDialog.error((BWidget)this, (Object)LEX.get("aceEdge.conversion.dialog.csvfileError"));
                return;
            }
            this.addOneRow(i, xy[i][0], xy[i][1]);
        }
        this.nextIndex = size;
    }

    public void doButtonPressed(BWidgetEvent event) {
        int ret = 4;
        if (event.getWidget().equals((Object)this.okButton)) {
            int j;
            int i;
            BDouble[] x = new BDouble[20];
            BDouble[] y = new BDouble[20];
            BDouble lastX = null;
            for (i = 0; i < this.map.size(); ++i) {
                String[] row = this.getOneRow(i);
                try {
                    x[i] = BDouble.make((String)row[0]);
                    y[i] = BDouble.make((String)row[1]);
                    if (!this.isAscending(x[i], lastX)) {
                        ret = BDialog.confirm((BWidget)this, (Object)LEX.getText("aceEdge.conversion.dialog.invalidValue", new Object[]{i}));
                        break;
                    }
                    lastX = x[i];
                    continue;
                }
                catch (NumberFormatException n) {
                    BDialog.error((BWidget)this, (Object)LEX.get("aceEdge.conversion.dialog.invalidFormatError"));
                    this.close();
                    return;
                }
            }
            if (ret == 8) {
                return;
            }
            for (j = 0; j < i; ++j) {
                this.generalTblConv.set(INPUT_SLOT_NAME + (j + 1), (BValue)x[j]);
                this.generalTblConv.set(OUTPUT_SLOT_NAME + (j + 1), (BValue)y[j]);
            }
            for (j = i; j < 20; ++j) {
                BDouble val = BDouble.make((double)0.0);
                this.generalTblConv.set(INPUT_SLOT_NAME + (j + 1), (BValue)val);
                this.generalTblConv.set(OUTPUT_SLOT_NAME + (j + 1), (BValue)val);
            }
            this.generalTblConv.set(TABLE_SIZE, (BValue)BInteger.make((int)i));
        }
        this.close();
    }

    private boolean isAscending(BDouble x, BDouble lastX) {
        if (lastX == null) {
            return true;
        }
        return x.compareTo((Object)lastX) > 0;
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        this.okButton.setEnabled(true);
    }

    private void addOneRow(int index, String x, String y) {
        BTextField xfield = new BTextField(x + "", 10);
        BTextField yfield = new BTextField(y + "", 10);
        xfield.setExpandHeight(true);
        yfield.setExpandHeight(true);
        DeleteCmd deleteCmd = new DeleteCmd(index);
        BButton dfield = new BButton((Command)deleteCmd);
        dfield.setButtonStyle(BButtonStyle.toolBar);
        this.tablePane.add("x" + index, (BValue)xfield);
        this.tablePane.add("y" + index, (BValue)yfield);
        this.tablePane.add("d" + index, (BValue)dfield);
        this.linkTo(null, (BComponent)xfield, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)yfield, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.map.add((Object)index);
    }

    private String[] getOneRow(int index) {
        String xname = "x" + this.map.get(index);
        String yname = "y" + this.map.get(index);
        BTextField xfield = (BTextField)this.tablePane.get(xname);
        BTextField yfield = (BTextField)this.tablePane.get(yname);
        String[] row = new String[]{xfield.getText(), yfield.getText()};
        return row;
    }

    class AddCmd
    extends Command {
        public AddCmd() {
            super((BWidget)BAceGenTblConvDialog.this, LEX, "aceEdge.conversion.dialog.addButton");
        }

        public CommandArtifact doInvoke() {
            if (BAceGenTblConvDialog.this.map.size() >= 20) {
                BDialog.error((BWidget)BAceGenTblConvDialog.this, (Object)LEX.get("aceEdge.conversion.dialog.tooMuchArrayError"));
                return null;
            }
            BAceGenTblConvDialog.this.addOneRow(BAceGenTblConvDialog.this.nextIndex, "", "");
            BAceGenTblConvDialog.this.nextIndex++;
            return null;
        }
    }

    class DeleteCmd
    extends Command {
        private int index;

        public DeleteCmd(int index) {
            super((BWidget)BAceGenTblConvDialog.this, LEX, "aceEdge.conversion.dialog.deleteButton");
            this.index = index;
        }

        public CommandArtifact doInvoke() {
            BAceGenTblConvDialog.this.tablePane.remove("x" + this.index);
            BAceGenTblConvDialog.this.tablePane.remove("y" + this.index);
            BAceGenTblConvDialog.this.tablePane.remove("d" + this.index);
            BAceGenTblConvDialog.this.map.remove((Object)this.index);
            return null;
        }
    }

    class ResortCmd
    extends Command {
        public ResortCmd() {
            super((BWidget)BAceGenTblConvDialog.this, LEX, "aceEdge.conversion.dialog.resortButton");
        }

        public CommandArtifact doInvoke() {
            String[][] xy = new String[BAceGenTblConvDialog.this.map.size()][];
            for (int i = 0; i < BAceGenTblConvDialog.this.map.size(); ++i) {
                xy[i] = BAceGenTblConvDialog.this.getOneRow(i);
            }
            Arrays.sort(xy, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return BDouble.make((String)o1[0]).compareTo((Object)BDouble.make((String)o2[0]));
                }
            });
            BAceGenTblConvDialog.this.buildTablePane(xy);
            return null;
        }
    }

    class ExportCmd
    extends Command {
        public ExportCmd() {
            super((BWidget)BAceGenTblConvDialog.this, LEX, "aceEdge.conversion.dialog.exportButton");
        }

        public CommandArtifact doInvoke() {
            BFacets facets = BFacets.make((String)"save", (BIDataValue)BBoolean.TRUE);
            String defaultName = "conversion_table.csv";
            facets = BFacets.make((BFacets)facets, (String)"defaultFileName", (BIDataValue)BString.make((String)defaultName));
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("csv Files (*.csv)", "csv"));
            BOrd ord = chooser.openChooser((BWidget)BAceGenTblConvDialog.this, (BObject)BAceGenTblConvDialog.this, BOrd.make((String)"local:|file:"), (Context)facets);
            if (ord == null) {
                return null;
            }
            try {
                this.saveFile(ord);
            }
            catch (Exception e) {
                BDialog.error((BWidget)BAceGenTblConvDialog.this, (String)BDialog.TITLE_ERROR, (Object)LEX.get("aceEdge.conversion.dialog.exportError"), (Throwable)e);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveFile(BOrd fileOrd) throws Exception {
            if (BAceGenTblConvDialog.this.map.size() < 1) {
                BDialog.error((BWidget)BAceGenTblConvDialog.this, (Object)LEX.get("aceEdge.conversion.dialog.noArrayError"));
                return;
            }
            String[][] xy = new String[BAceGenTblConvDialog.this.map.size()][];
            for (int i = 0; i < BAceGenTblConvDialog.this.map.size(); ++i) {
                xy[i] = BAceGenTblConvDialog.this.getOneRow(i);
                try {
                    BDouble x = BDouble.make((String)xy[i][0]);
                    BDouble bDouble = BDouble.make((String)xy[i][1]);
                    continue;
                }
                catch (NumberFormatException n) {
                    BDialog.error((BWidget)BAceGenTblConvDialog.this, (Object)LEX.get("aceEdge.conversion.dialog.invalidFormatError"));
                    return;
                }
            }
            OutputStream out = null;
            try {
                BIFile file = (BIFile)fileOrd.get();
                BCsvFile csvFile = (BCsvFile)file;
                out = csvFile.getOutputStream();
                for (int i = 0; i < BAceGenTblConvDialog.this.map.size(); ++i) {
                    this.writeRow(xy[i], out);
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)BAceGenTblConvDialog.this, (String)LEX.get("aceEdge.conversion.dialog.writingError"), (Object)e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }

        void writeRow(String[] row, OutputStream out) throws Exception {
            for (int i = 0; i < row.length; ++i) {
                out.write(row[i].getBytes());
                if (i >= row.length - 1) continue;
                out.write(44);
            }
            out.write("\r\n".getBytes());
        }
    }

    class ImportCmd
    extends Command {
        public ImportCmd() {
            super((BWidget)BAceGenTblConvDialog.this, LEX, "aceEdge.conversion.dialog.importButton");
        }

        public CommandArtifact doInvoke() {
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("csv Files (*.csv)", "csv"));
            BOrd ord = chooser.openChooser((BWidget)BAceGenTblConvDialog.this, (BObject)BAceGenTblConvDialog.this, BOrd.make((String)"local:|file:"), null);
            if (ord == null) {
                return null;
            }
            try {
                this.loadFile(ord);
            }
            catch (Exception e) {
                BDialog.error((BWidget)BAceGenTblConvDialog.this, (String)BDialog.TITLE_ERROR, (Object)LEX.get("aceEdge.conversion.dialog.importError"), (Throwable)e);
            }
            return null;
        }

        private void loadFile(BOrd fileOrd) throws Exception {
            BIFile file = (BIFile)fileOrd.get();
            if (file == null) {
                throw new Exception("File not defined.");
            }
            InputStream in = file.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            CsvParser parser = new CsvParser(reader);
            String[][] table = parser.parseAll();
            BAceGenTblConvDialog.this.buildTablePane(table);
        }
    }
}

