/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.ws;

import com.tridium.httpClient.BHttpClientGlobalCapacityExt;
import com.tridium.httpClient.BHttpClientService;
import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.BIHttpCommClientTransport;
import com.tridium.httpClient.comm.client.BIHttpCommClientWrite;
import com.tridium.httpClient.comm.transport.BHttpTransport;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.BHttpResponseHealth;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridium.httpClient.datatypes.auth.SessionBasedAuth;
import com.tridium.httpClient.datatypes.exception.HttpCommException;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.util.HttpClientRegister;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.InputStreamUtil;
import com.tridium.httpClient.util.LicenseUtil;
import com.tridium.httpClient.ws.BWebsocketConfig;
import com.tridium.httpClient.ws.BWebsocketHealth;
import com.tridium.httpClient.ws.BWebsocketMetrics;
import com.tridium.httpClient.ws.WebsocketCallbacks;
import com.tridium.httpClient.ws.WebsocketClientSession;
import com.tridium.httpClient.ws.WsMessageEvent;
import com.tridium.httpClient.ws.jetty.JettyWebsocketClientSession;
import com.tridium.util.EngineCycleQueue;
import com.tridium.util.PrefixLogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="proxy", type="BHttpClientGlobalCapacityExt", defaultValue="new BHttpClientGlobalCapacityExt()", flags=4), @NiagaraProperty(name="health", type="BHttpResponseHealth", defaultValue="new BWebsocketHealth()"), @NiagaraProperty(name="address", type="BHttpAddress", defaultValue="new BHttpAddress()"), @NiagaraProperty(name="headers", type="BHttpHeaders", defaultValue="new BHttpHeaders()"), @NiagaraProperty(name="config", type="BWebsocketConfig", defaultValue="new BWebsocketConfig()"), @NiagaraProperty(name="authenticator", type="BHttpAuthenticator", defaultValue="new BHttpAuthenticator()"), @NiagaraProperty(name="requestBody", type="BRequestBody", defaultValue="new BRequestBody()"), @NiagaraProperty(name="connected", type="boolean", defaultValue="false", flags=11), @NiagaraProperty(name="lastConnected", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65601), @NiagaraProperty(name="lastSentMessage", type="String", defaultValue="BString.DEFAULT", flags=65547, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="lastSentTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65601), @NiagaraProperty(name="lastReceivedMessage", type="String", defaultValue="BString.DEFAULT", flags=65547, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="lastReceivedTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65601), @NiagaraProperty(name="outgoingQueueSize", type="int", defaultValue="0", flags=65551), @NiagaraProperty(name="incomingQueueSize", type="int", defaultValue="0", flags=65551), @NiagaraProperty(name="transport", type="BHttpTransport", defaultValue="new BHttpTransport()", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="connect", flags=16), @NiagaraAction(name="disconnect", flags=16), @NiagaraAction(name="send", flags=16)})
@NiagaraTopics(value={@NiagaraTopic(name="messageSent", eventType="BString"), @NiagaraTopic(name="messageReceived", eventType="BString")})
public class BWebsocketClient
extends BComponent
implements BIHttpCommClient,
BIHttpCommClientTransport,
BIHttpCommClientWrite,
WebsocketCallbacks {
    @Generated
    public static final Property enabled = BWebsocketClient.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property proxy = BWebsocketClient.newProperty((int)4, (BValue)new BHttpClientGlobalCapacityExt(), null);
    @Generated
    public static final Property health = BWebsocketClient.newProperty((int)0, (BValue)new BWebsocketHealth(), null);
    @Generated
    public static final Property address = BWebsocketClient.newProperty((int)0, (BValue)new BHttpAddress(), null);
    @Generated
    public static final Property headers = BWebsocketClient.newProperty((int)0, (BValue)new BHttpHeaders(), null);
    @Generated
    public static final Property config = BWebsocketClient.newProperty((int)0, (BValue)new BWebsocketConfig(), null);
    @Generated
    public static final Property authenticator = BWebsocketClient.newProperty((int)0, (BValue)new BHttpAuthenticator(), null);
    @Generated
    public static final Property requestBody = BWebsocketClient.newProperty((int)0, (BValue)new BRequestBody(), null);
    @Generated
    public static final Property connected = BWebsocketClient.newProperty((int)11, (boolean)false, null);
    @Generated
    public static final Property lastConnected = BWebsocketClient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastSentMessage = BWebsocketClient.newProperty((int)65547, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property lastSentTime = BWebsocketClient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastReceivedMessage = BWebsocketClient.newProperty((int)65547, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property lastReceivedTime = BWebsocketClient.newProperty((int)65601, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property outgoingQueueSize = BWebsocketClient.newProperty((int)65551, (int)0, null);
    @Generated
    public static final Property incomingQueueSize = BWebsocketClient.newProperty((int)65551, (int)0, null);
    @Generated
    public static final Property transport = BWebsocketClient.newProperty((int)4, (BValue)new BHttpTransport(), null);
    @Generated
    public static final Action connect = BWebsocketClient.newAction((int)16, null);
    @Generated
    public static final Action disconnect = BWebsocketClient.newAction((int)16, null);
    @Generated
    public static final Action send = BWebsocketClient.newAction((int)16, null);
    @Generated
    public static final Topic messageSent = BWebsocketClient.newTopic((int)0, null);
    @Generated
    public static final Topic messageReceived = BWebsocketClient.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWebsocketClient.class);
    public static final long MAX_QUEUE_ITEM_LENGTH = 0x100000L;
    public static final String DEFAULT_CLOSE_REASON = "NiagaraDisconnect";
    public static final Logger WS_LOGGER = Logger.getLogger("httpClient.ws");
    private final Object sessionMutex = new Object();
    private EngineCycleQueue<String> outgoingQueue;
    private EngineCycleQueue<String> incomingQueue;
    private WebsocketClientSession session;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BHttpClientGlobalCapacityExt getProxy() {
        return (BHttpClientGlobalCapacityExt)this.get(proxy);
    }

    @Generated
    public void setProxy(BHttpClientGlobalCapacityExt v) {
        this.set(proxy, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpResponseHealth getHealth() {
        return (BHttpResponseHealth)this.get(health);
    }

    @Override
    @Generated
    public void setHealth(BHttpResponseHealth v) {
        this.set(health, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpAddress getAddress() {
        return (BHttpAddress)this.get(address);
    }

    @Override
    @Generated
    public void setAddress(BHttpAddress v) {
        this.set(address, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpHeaders getHeaders() {
        return (BHttpHeaders)this.get(headers);
    }

    @Override
    @Generated
    public void setHeaders(BHttpHeaders v) {
        this.set(headers, (BValue)v, null);
    }

    @Generated
    public BWebsocketConfig getConfig() {
        return (BWebsocketConfig)this.get(config);
    }

    @Generated
    public void setConfig(BWebsocketConfig v) {
        this.set(config, (BValue)v, null);
    }

    @Override
    @Generated
    public BHttpAuthenticator getAuthenticator() {
        return (BHttpAuthenticator)this.get(authenticator);
    }

    @Override
    @Generated
    public void setAuthenticator(BHttpAuthenticator v) {
        this.set(authenticator, (BValue)v, null);
    }

    @Override
    @Generated
    public BRequestBody getRequestBody() {
        return (BRequestBody)this.get(requestBody);
    }

    @Generated
    public void setRequestBody(BRequestBody v) {
        this.set(requestBody, (BValue)v, null);
    }

    @Generated
    public boolean getConnected() {
        return this.getBoolean(connected);
    }

    @Generated
    public void setConnected(boolean v) {
        this.setBoolean(connected, v, null);
    }

    @Generated
    public BAbsTime getLastConnected() {
        return (BAbsTime)this.get(lastConnected);
    }

    @Generated
    public void setLastConnected(BAbsTime v) {
        this.set(lastConnected, (BValue)v, null);
    }

    @Generated
    public String getLastSentMessage() {
        return this.getString(lastSentMessage);
    }

    @Generated
    public void setLastSentMessage(String v) {
        this.setString(lastSentMessage, v, null);
    }

    @Generated
    public BAbsTime getLastSentTime() {
        return (BAbsTime)this.get(lastSentTime);
    }

    @Generated
    public void setLastSentTime(BAbsTime v) {
        this.set(lastSentTime, (BValue)v, null);
    }

    @Generated
    public String getLastReceivedMessage() {
        return this.getString(lastReceivedMessage);
    }

    @Generated
    public void setLastReceivedMessage(String v) {
        this.setString(lastReceivedMessage, v, null);
    }

    @Generated
    public BAbsTime getLastReceivedTime() {
        return (BAbsTime)this.get(lastReceivedTime);
    }

    @Generated
    public void setLastReceivedTime(BAbsTime v) {
        this.set(lastReceivedTime, (BValue)v, null);
    }

    @Generated
    public int getOutgoingQueueSize() {
        return this.getInt(outgoingQueueSize);
    }

    @Generated
    public void setOutgoingQueueSize(int v) {
        this.setInt(outgoingQueueSize, v, null);
    }

    @Generated
    public int getIncomingQueueSize() {
        return this.getInt(incomingQueueSize);
    }

    @Generated
    public void setIncomingQueueSize(int v) {
        this.setInt(incomingQueueSize, v, null);
    }

    @Override
    @Generated
    public BHttpTransport getTransport() {
        return (BHttpTransport)this.get(transport);
    }

    @Override
    @Generated
    public void setTransport(BHttpTransport v) {
        this.set(transport, (BValue)v, null);
    }

    @Generated
    public void connect() {
        this.invoke(connect, null, null);
    }

    @Generated
    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    @Override
    @Generated
    public void send() {
        this.invoke(send, null, null);
    }

    @Generated
    public void fireMessageSent(BString event) {
        this.fire(messageSent, (BValue)event, null);
    }

    @Generated
    public void fireMessageReceived(BString event) {
        this.fire(messageReceived, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStation()) {
            this.incomingQueue = new EngineCycleQueue(this.getSlotPath().toString() + "/incomingQueue", this::handleIncomingMessage, (long)this.getConfig().getSleepMillisBetweenDequeues(), this.getConfig().getIncomingMessageQueueSize());
            this.outgoingQueue = new EngineCycleQueue(this.getSlotPath().toString() + "/outgoingQueue", this::sendOutgoingMessage, (long)this.getConfig().getSleepMillisBetweenDequeues(), this.getConfig().getOutgoingMessageQueueSize());
            HttpClientRegister.registerClient(this);
        }
    }

    public void atSteadyState() {
        if (this.getEnabled() && this.getConfig().getWriteOnStart()) {
            this.send();
        }
    }

    public void stopped() {
        if (Sys.isStation()) {
            this.disconnectSession(true);
            if (this.incomingQueue != null) {
                this.incomingQueue.stop();
            }
            if (this.outgoingQueue != null) {
                this.outgoingQueue.stop();
            }
            HttpClientRegister.unregisterClient(this);
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property.equals(enabled)) {
                if (this.getEnabled() && this.getConfig().getWriteOnEnabled()) {
                    this.send();
                } else if (!this.getEnabled()) {
                    this.disconnectSession(false);
                }
            }
            if (property.equals(address)) {
                HttpClientUtils.auditAddressChange(this.getAddress(), context);
            }
            if (property.equals(connected) && !this.getConnected() && this.getAuthenticator().getConfig() instanceof SessionBasedAuth) {
                ((SessionBasedAuth)((Object)this.getAuthenticator().getConfig())).endSession();
            }
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return BHttpClientService.post(this, action, argument, cx);
    }

    @Override
    public void writeRequested() {
        this.send();
    }

    public void doConnect(Context cx) {
        if (this.getEnabled() && BHttpClientService.permittedByService((BIHttpCommClient)this, cx)) {
            this.connectSession();
        }
    }

    public void doDisconnect() {
        this.disconnectSession(false);
    }

    public void doSend(Context cx) {
        this.connectAndSend(cx);
    }

    private void connectAndSend(Context cx) {
        if (!this.getEnabled() || !BHttpClientService.permittedByService((BIHttpCommClient)this, cx)) {
            return;
        }
        this.connectSession();
        try {
            if (this.getPayloadSource().length() <= 0x100000L) {
                this.queueOutgoingMessage(InputStreamUtil.streamToString(this.getPayloadSource().getStream()));
            } else {
                this.sendOutgoingMessage(this.getPayloadSource().getStream(), this.getPayloadSource().length());
            }
        }
        catch (Exception e) {
            this.getHealth().updateHealth(BStatus.fault, "Failed to queue outgoing message", e);
            this.getWsMetrics().messageNotQueued(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSession(boolean stopping) {
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isConnected()) {
                PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.FINE, () -> "Disconnecting ws session (stopping:" + stopping + ')', (Object)this);
                try {
                    this.session.disconnect(stopping);
                    this.session = null;
                    this.setConnected(false);
                }
                catch (HttpCommException e) {
                    PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.WARNING, (String)"Failed to disconnect", (Throwable)((Object)e), (Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectSession() {
        if (!this.isRunning()) {
            return;
        }
        this.checkPermissions();
        try {
            LicenseUtil.licenseCheck();
        }
        catch (Exception e) {
            this.getHealth().updateHealth(BStatus.fault, "Licensed check fail", e);
            return;
        }
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session == null) {
                PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.FINE, (String)"Creating ws session", (Object)this);
                this.session = new JettyWebsocketClientSession();
                this.session.init(this, this.getConfig());
            }
            if (!this.session.isConnected()) {
                try {
                    int responseCode = this.session.connect(this.getAddress(), this.getHeaders(), this.getAuthenticator().getConfig(), this.getConfig().getConnectionAttemptTimeout().getMillis());
                    this.getHealth().setLastResponseCode(responseCode);
                }
                catch (HttpCommException e) {
                    this.connectionDown("Session connection failed", -1, (Exception)((Object)e));
                    this.getWsMetrics().connectionResult(false);
                }
            }
        }
    }

    @Override
    public void messageReceived(String sessionId, String incomingMessage) {
        PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.FINE, () -> String.format("Received %d bytes message from: %s", incomingMessage.getBytes(StandardCharsets.UTF_8).length, sessionId), (Object)this);
        this.incomingQueue.setMaxQueueSize(this.getConfig().getIncomingMessageQueueSize());
        try {
            this.incomingQueue.performEnqueue((Object)incomingMessage);
        }
        catch (Exception e) {
            this.getHealth().updateHealth(BStatus.fault, "Failed to queue incoming message", e);
            this.getWsMetrics().messageNotQueued(true);
        }
        this.setIncomingQueueSize(this.incomingQueue.size());
    }

    @Override
    public void onError(Exception cause) {
        PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.SEVERE, (String)"WebSocket Error", (Throwable)cause, (Object)this);
        this.getWsMetrics().error();
        this.getHealth().updateHealth(BStatus.fault, "Ws error received", cause);
    }

    @Override
    public void sessionConnected(String sessionId) {
        PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.FINE, () -> String.format("Connected to ws session: %s", sessionId), (Object)this);
        this.setConnected(true);
        this.setLastConnected(BAbsTime.now());
        this.getWsMetrics().connectionResult(true);
        this.getHealth().clearFault();
    }

    @Override
    public void sessionDisconnected(String sessionId, int statusCode, String fault, Exception exception) {
        PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.FINE, () -> String.format("Connection to ws session closed: %s code: %d", sessionId, statusCode), (Object)this);
        this.connectionDown(fault, statusCode, exception);
    }

    private void connectionDown(String fault, int statusCode, Exception exception) {
        boolean expectedDisconnect;
        this.setConnected(false);
        BStatus status = BStatus.down;
        this.getHealth().setStatus(BStatus.make((int)(this.getHealth().getStatus().getBits() | 4)));
        if (statusCode == -1 && exception instanceof HttpCommException) {
            statusCode = ((HttpCommException)((Object)exception)).getResponseCode();
        }
        this.getHealth().setLastResponseCode(statusCode);
        boolean bl = expectedDisconnect = fault.equals(DEFAULT_CLOSE_REASON) || statusCode == 1000;
        if (!expectedDisconnect) {
            status = BStatus.make((int)(status.getBits() | 2));
        }
        this.getWsMetrics().disconnected(expectedDisconnect);
        this.getHealth().updateHealth(status, fault, exception);
    }

    private void queueOutgoingMessage(String message) {
        if (this.outgoingQueue == null) {
            throw new IllegalStateException("Illegal state: no outgoing message queue available");
        }
        if (!this.getConnected()) {
            throw new IllegalStateException("Illegal state: socket not connected, cannot queue message");
        }
        this.outgoingQueue.setMaxQueueSize(this.getConfig().getOutgoingMessageQueueSize());
        this.outgoingQueue.performEnqueue((Object)message);
        this.setOutgoingQueueSize(this.outgoingQueue.size());
    }

    private void sendOutgoingMessage(String message) {
        this.sendOutgoingMessage(new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)), message.getBytes(StandardCharsets.UTF_8).length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOutgoingMessage(InputStream messageBytes, long length) {
        HttpCommException exception = null;
        WsMessageEvent messageEvent = WsMessageEvent.outbound(0x100000L, messageBytes, length);
        Object object = this.sessionMutex;
        synchronized (object) {
            if (this.session != null && this.session.isConnected()) {
                try {
                    messageEvent = this.session.sendBytes(messageEvent, this.getConfig().getSendMessageTimeout().getMillis());
                    this.setLastSentMessage(messageEvent.getMessageContent());
                    this.setLastSentTime(BAbsTime.now());
                    this.fireMessageSent(BString.make((String)messageEvent.getMessageContent()));
                    this.getHealth().clearFault();
                    messageEvent.succeeded();
                }
                catch (HttpCommException e) {
                    exception = e;
                }
            } else {
                exception = new HttpCommException("Bad state, no connected websocket session");
            }
        }
        if (exception != null) {
            PrefixLogUtil.logWithPrefix((Logger)WS_LOGGER, (Level)Level.SEVERE, (String)"Failed to send ws message", (Throwable)((Object)exception), (Object)this);
            this.getHealth().updateHealth(BStatus.fault, "Failed to send ws message", (Exception)((Object)exception));
        } else {
            this.getHealth().clearFault();
        }
        HttpClientUtils.updateConsumers(this, messageEvent);
    }

    private void handleIncomingMessage(String incomingMessage) {
        WsMessageEvent messageEvent = WsMessageEvent.inbound(incomingMessage);
        this.setLastReceivedMessage(incomingMessage);
        this.setLastReceivedTime(BAbsTime.now());
        this.fireMessageReceived(BString.make((String)incomingMessage));
        HttpClientUtils.updateConsumers(this, messageEvent);
        this.getHealth().clearFault();
    }

    public BWebsocketMetrics getWsMetrics() {
        return ((BWebsocketHealth)this.getHealth().as(BWebsocketHealth.class)).getWsMetrics();
    }

    public String identifierForLogs() {
        return this.getName();
    }

    public BIcon getIcon() {
        return HttpClientUtils.HTTP_EXPORT_ICON;
    }

    @Override
    public BHttpRequestMethod getMethod() {
        return BHttpRequestMethod.get;
    }

    @Override
    public void setMethod(BHttpRequestMethod x) {
    }

    @Override
    public BHttpParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(BHttpParameters x) {
    }

    @Override
    public BHttpTuningPolicy getHttpTuningPolicy() {
        return new BHttpTuningPolicy();
    }

    @Override
    public String sendSync() {
        throw new BajaRuntimeException("sendSync on websocket unsupported");
    }

    @Override
    public final boolean isDriverBasedClient() {
        return false;
    }

    private void checkPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(this.getAddress().getHostAddress(), this.getAddress().getPort());
        }
    }
}

