/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.util;

import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.PrefixLogUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class InputStreamUtil {
    private InputStreamUtil() {
    }

    public static String streamToString(InputStream input) throws IOException {
        if (input != null) {
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String string = buffer.lines().collect(Collectors.joining("\n"));
                return string;
            }
        }
        return "";
    }

    public static String streamToBoundedString(InputStream input, long maxLength) throws IOException {
        if (input != null && maxLength > 0L) {
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            while ((bytesRead = input.read(bytes)) != -1) {
                int bytesToCopy = (int)Math.min((long)bytesRead, maxLength - (long)buffer.size());
                buffer.write(bytes, 0, bytesToCopy);
                if ((long)buffer.size() < maxLength) continue;
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.WARNING, (String)("Input truncated at " + maxLength), null);
                break;
            }
            buffer.flush();
            return buffer.toString(StandardCharsets.UTF_8.name());
        }
        return "";
    }
}

