/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.datatypes.auth;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridium.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridium.httpClient.datatypes.exception.HttpCommException;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.util.BResponseCookieCapture;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.PrefixLogUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BPassword;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="client", type="String", defaultValue="BString.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"httpClient:HttpClientChooserFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"httpClient:HttpClientChooser\"))")}), @NiagaraProperty(name="cookieName", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="cookieFound", type="boolean", defaultValue="false", flags=3)})
public class BResponseCookieAuth
extends BAbstractHttpAuth {
    @Generated
    public static final Property client = BResponseCookieAuth.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"httpClient:HttpClientChooserFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"httpClient:HttpClientChooser"))));
    @Generated
    public static final Property cookieName = BResponseCookieAuth.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property cookieFound = BResponseCookieAuth.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BResponseCookieAuth.class);

    @Generated
    public String getClient() {
        return this.getString(client);
    }

    @Generated
    public void setClient(String v) {
        this.setString(client, v, null);
    }

    @Generated
    public String getCookieName() {
        return this.getString(cookieName);
    }

    @Generated
    public void setCookieName(String v) {
        this.setString(cookieName, v, null);
    }

    @Generated
    public boolean getCookieFound() {
        return this.getBoolean(cookieFound);
    }

    @Generated
    public void setCookieFound(boolean v) {
        this.setBoolean(cookieFound, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BHttpAuthenticator createCookieAuthenticator(String sourceClientHandle, String cookieId) {
        BHttpAuthenticator authenticator = new BHttpAuthenticator();
        authenticator.setAuthType(TYPE.getTypeSpec());
        authenticator.checkAuthenticator();
        BResponseCookieAuth auth = (BResponseCookieAuth)authenticator.getConfig().as(BResponseCookieAuth.class);
        auth.setClient(sourceClientHandle);
        auth.setCookieName(cookieId);
        return authenticator;
    }

    @Override
    public void appendHeaders(BHttpHeaders headers) throws HttpCommException {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.setCookieFound(false);
            BIHttpCommClient client = (BIHttpCommClient)BOrd.make((String)this.getClient()).get((BObject)Sys.getStation()).as(BIHttpCommClient.class);
            PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)"Cookie authenticator found client to use", (Object)client);
            Optional<Object> cookieValue = Optional.empty();
            HttpCommResponse lastResponse = client.getHealth().getLastCommResponse();
            if (lastResponse != null) {
                cookieValue = this.searchLastResponse(lastResponse);
            }
            if (!cookieValue.isPresent()) {
                cookieValue = this.searchCookieCapture(client);
            }
            if (cookieValue.isPresent()) {
                this.setCookieValue(headers, (String)cookieValue.get());
            } else {
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)"No response found in cookie source client", (Object)this);
            }
        }
        catch (NullOrdException | SyntaxException | UnresolvedException e) {
            throw new HttpCommException("Cookie authenticator unable to find source client", (Exception)e);
        }
    }

    private Optional<String> searchCookieCapture(BIHttpCommClient client) {
        PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)"Cookie authenticator searching for cookie capture", (Object)client);
        BResponseCookieCapture[] captures = (BResponseCookieCapture[])client.asObject().asComponent().getChildren(BResponseCookieCapture.class);
        if (captures.length > 0) {
            for (BResponseCookieCapture capture : captures) {
                Optional<Property> foundProperty = Arrays.stream(capture.getDynamicPropertiesArray()).filter(prop -> prop.getName().equalsIgnoreCase(this.getCookieName())).findFirst();
                if (!foundProperty.isPresent()) continue;
                BValue value = capture.get(foundProperty.get());
                String valueString = value instanceof BPassword ? ((BPassword)value.as(BPassword.class)).getValue() : value.toString();
                return Optional.of(valueString);
            }
        }
        return Optional.empty();
    }

    private Optional<String> searchLastResponse(HttpCommResponse lastResponse) {
        PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)"Cookie authenticator searching last response", (Object)client);
        Optional<List<String>> setCookieValues = lastResponse.getHeaders().getAllValues("Set-Cookie");
        if (setCookieValues.isPresent()) {
            for (String cookiePair : setCookieValues.get()) {
                Optional<String> found = this.findMatchingCookieValue(cookiePair);
                if (!found.isPresent()) continue;
                return found;
            }
        }
        return Optional.empty();
    }

    private Optional<String> findMatchingCookieValue(String cookieHeaderValue) {
        Optional<String[]> cookiePair = HttpClientUtils.getFirstHeaderTokenPair(cookieHeaderValue);
        Optional<String> cookieValue = cookiePair.filter(pair -> ((String[])pair).length > 1 && pair[0].equalsIgnoreCase(this.getCookieName())).map(pair -> pair[1]);
        return cookieValue;
    }

    private void setCookieValue(BHttpHeaders headers, String cookieValue) {
        headers.addToRequest("Cookie", String.format("%s=%s", this.getCookieName(), cookieValue));
        PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, (String)"Cookie authenticator found value to use", (Object)((Object)headers));
        this.setCookieFound(true);
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.box), @Transport(type=TransportType.fox)})
    public static Map<String, String> findAllClients(Context context) {
        return HttpClientUtils.findAllClients(context);
    }
}

