/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.datatypes.auth;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridium.httpClient.datatypes.auth.BHttpAuthenticator;
import com.tridium.httpClient.datatypes.auth.SessionBasedAuth;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.nre.auth.NiagaraStationAlgorithmBundle;
import com.tridium.nre.auth.ScramAlgorithmBundle;
import com.tridium.nre.auth.ScramClient;
import com.tridium.util.PrefixLogUtil;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="credentials", type="BUsernameAndPassword", defaultValue="new BUsernameAndPassword()", flags=64), @NiagaraProperty(name="hasSession", type="boolean", defaultValue="false", flags=67651)})
@NiagaraAction(name="clearSession")
public class BNiagaraScramShaDigestAuth
extends BAuthorizationHeaderScheme
implements SessionBasedAuth {
    @Generated
    public static final Property credentials = BNiagaraScramShaDigestAuth.newProperty((int)64, (BValue)new BUsernameAndPassword(), null);
    @Generated
    public static final Property hasSession = BNiagaraScramShaDigestAuth.newProperty((int)67651, (boolean)false, null);
    @Generated
    public static final Action clearSession = BNiagaraScramShaDigestAuth.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraScramShaDigestAuth.class);
    private BIHttpCommClient currentClient;
    private String sessionId;
    private static final String PATH_TO_USE_FOR_AUTH = "/ord/station:%7Cslot:/";

    @Generated
    public BUsernameAndPassword getCredentials() {
        return (BUsernameAndPassword)this.get(credentials);
    }

    @Generated
    public void setCredentials(BUsernameAndPassword v) {
        this.set(credentials, (BValue)v, null);
    }

    @Generated
    public boolean getHasSession() {
        return this.getBoolean(hasSession);
    }

    @Generated
    public void setHasSession(boolean v) {
        this.setBoolean(hasSession, v, null);
    }

    @Generated
    public void clearSession() {
        this.invoke(clearSession, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doClearSession() {
        this.updateSessionId("");
    }

    @Override
    public void endSession() {
        this.doClearSession();
    }

    @Override
    public String getAuthHeaderValue(BIHttpCommClient client) {
        if (!this.hasSession()) {
            try {
                this.currentClient = client;
                this.updateSessionId(this.loginScramShaHeader());
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.SEVERE, (String)"ScramSha Auth failed", (Throwable)e, (Object)this);
            }
        }
        return String.format("%s %s=%s", "BEARER", "authToken", this.sessionId);
    }

    private String loginScramShaHeader() throws Exception {
        String userName = this.getCredentials().getUsername();
        String helloAuthResponse = this.sendHelloMessage(userName);
        if (!helloAuthResponse.startsWith("SCRAM hash=SHA-256, handshakeToken=")) {
            throw new BajaRuntimeException("Server does not support SCRAM-SHA-256 header authentication");
        }
        String handshakeToken = HttpClientUtils.readTokenFromAuthHeader(helloAuthResponse, "handshakeToken", false);
        String password = this.getCredentials().getPassword().getValue();
        ScramClient scramClient = new ScramClient((ScramAlgorithmBundle)NiagaraStationAlgorithmBundle.getInstance(), userName, password);
        String clientFirstMessage = scramClient.createClientFirstMessage();
        String serverFirstResp = this.sendScramMessage(clientFirstMessage, handshakeToken, "WWW-Authenticate");
        String serverFirstMessage = HttpClientUtils.readTokenFromAuthHeader(serverFirstResp, "data", true);
        String clientFinalMessage = scramClient.createClientFinalMessage(serverFirstMessage);
        String serverFinalResp = "BEARER " + this.sendScramMessage(clientFinalMessage, handshakeToken, "Authentication-Info");
        String serverFinalMessage = HttpClientUtils.readTokenFromAuthHeader(serverFinalResp, "data", true);
        scramClient.processServerFinalMessage(serverFinalMessage);
        return HttpClientUtils.readTokenFromAuthHeader(serverFinalResp, "authToken", false);
    }

    private String sendHelloMessage(String userName) throws Exception {
        HttpCommResponse response = this.sendMessage(String.format("HELLO username=%s", HttpClientUtils.toBase64(userName)), false);
        Optional<String> headerVal = response.getHeaders().getHeader("WWW-Authenticate");
        return headerVal.orElseThrow(() -> new BajaRuntimeException("Missing header: WWW-Authenticate"));
    }

    private String sendScramMessage(String scramMessage, String handshakeToken, String headerToRead) throws Exception {
        HttpCommResponse response = this.sendMessage(String.format("SCRAM data=%s,handshakeToken=%s", HttpClientUtils.toBase64(scramMessage), handshakeToken), true);
        Optional<String> headerVal = response.getHeaders().getHeader(headerToRead);
        return headerVal.orElseThrow(() -> new BajaRuntimeException("Missing Scram header: " + headerToRead));
    }

    protected HttpCommResponse sendMessage(String message, boolean scramMessage) throws Exception {
        BHttpAddress addressCopy = (BHttpAddress)this.currentClient.getAddress().newCopy().as(BHttpAddress.class);
        addressCopy.setPath(PATH_TO_USE_FOR_AUTH);
        BHttpHeaders headers = new BHttpHeaders();
        if (scramMessage) {
            headers.addToRequest("Content-Type", "application/x-niagara-login-support");
        }
        headers.addToRequest("Authorization", message);
        PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, () -> "Scram Authorization Message: " + message, (Object)this);
        HttpCommResponse response = this.sendAuthRequest(this.currentClient, addressCopy, headers);
        PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, () -> "Auth Response Code: " + response.getResponseCode(), (Object)this);
        PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, () -> "Auth Response: " + response.getBody(), (Object)this);
        return response;
    }

    @Override
    public boolean hasSession() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }

    private void updateSessionId(String sessionId) {
        this.sessionId = sessionId;
        this.setHasSession(this.hasSession());
    }

    public static BHttpAuthenticator createScramShaAuthenticator(String username, String password) {
        BHttpAuthenticator authenticator = new BHttpAuthenticator();
        authenticator.setAuthType(TYPE.getTypeSpec());
        authenticator.checkAuthenticator();
        BNiagaraScramShaDigestAuth auth = (BNiagaraScramShaDigestAuth)authenticator.getConfig().as(BNiagaraScramShaDigestAuth.class);
        auth.setCredentials(new BUsernameAndPassword(username, password));
        return authenticator;
    }
}

