/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.datatypes;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.client.HttpCommResponse;
import com.tridium.httpClient.comm.transport.BAbstractHttpTransport;
import com.tridium.httpClient.util.BHttpClientMetrics;
import com.tridium.httpClient.util.BIHttpConsumer;
import com.tridium.httpClient.util.BMetrics;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.HttpConsumable;
import com.tridium.httpClient.util.ParentLegal;
import com.tridium.util.PrefixLogUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.stale", flags=65603), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65603), @NiagaraProperty(name="lastResponse", type="BString", defaultValue="BString.DEFAULT", flags=65603), @NiagaraProperty(name="lastResponseCode", type="int", defaultValue="BHttpResponseHealth.UNKNOWN_RESPONSE_CODE", flags=65603), @NiagaraProperty(name="faultCause", type="BString", defaultValue="BString.DEFAULT", flags=65603), @NiagaraProperty(name="metrics", type="BMetrics", defaultValue="new BHttpClientMetrics()", flags=65601)})
@NiagaraAction(name="reset")
public class BHttpResponseHealth
extends BComponent
implements BIHttpConsumer {
    @Generated
    public static final Property status = BHttpResponseHealth.newProperty((int)65603, (BValue)BStatus.stale, null);
    @Generated
    public static final Property lastUpdate = BHttpResponseHealth.newProperty((int)65603, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastResponse = BHttpResponseHealth.newProperty((int)65603, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property lastResponseCode = BHttpResponseHealth.newProperty((int)65603, (int)-1, null);
    @Generated
    public static final Property faultCause = BHttpResponseHealth.newProperty((int)65603, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property metrics = BHttpResponseHealth.newProperty((int)65601, (BValue)new BHttpClientMetrics(), null);
    @Generated
    public static final Action reset = BHttpResponseHealth.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpResponseHealth.class);
    public static final int UNKNOWN_RESPONSE_CODE = -1;
    private HttpCommResponse lastCommResponse;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    @Generated
    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Generated
    public String getLastResponse() {
        return this.getString(lastResponse);
    }

    @Generated
    public void setLastResponse(String v) {
        this.setString(lastResponse, v, null);
    }

    @Generated
    public int getLastResponseCode() {
        return this.getInt(lastResponseCode);
    }

    @Generated
    public void setLastResponseCode(int v) {
        this.setInt(lastResponseCode, v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BMetrics getMetrics() {
        return (BMetrics)this.get(metrics);
    }

    @Generated
    public void setMetrics(BMetrics v) {
        this.set(metrics, (BValue)v, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doReset() {
        this.setStatus((BStatus)status.getDefaultValue());
        this.setLastUpdate((BAbsTime)lastUpdate.getDefaultValue());
        this.setLastResponseCode(-1);
        this.setLastResponse(lastResponse.getDefaultValue().toString());
        this.setFaultCause(faultCause.getDefaultValue().toString());
        this.lastCommResponse = null;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(lastResponseCode)) {
            int response = this.getLastResponseCode();
            this.setLastResponse(HttpClientUtils.getReasonPhrase(response));
            this.setStatus(HttpCommResponse.isSuccessResponse(response) || HttpCommResponse.isWebSocketUpgrade(response) ? BStatus.ok : BStatus.fault);
        }
    }

    public BHttpClientMetrics getHttpMetrics() {
        return (BHttpClientMetrics)this.getMetrics().as(BHttpClientMetrics.class);
    }

    @Override
    public void consume(HttpConsumable consumable) {
        if (consumable instanceof HttpCommResponse) {
            this.updateHealth((HttpCommResponse)consumable);
        }
    }

    public void updateHealth(HttpCommResponse response) {
        this.lastCommResponse = response;
        this.setLastResponseCode(response.getResponseCode());
        if (BAbstractHttpTransport.TRANSPORT_LOG.isLoggable(Level.FINE)) {
            PrefixLogUtil.logWithPrefix((Logger)BAbstractHttpTransport.TRANSPORT_LOG, (Level)Level.FINE, () -> String.format("Received response code [%s] response [%1.50s]", response.getResponseCode(), response.getBody()), (Object)this);
            response.getHeaders().forEach((k, v) -> PrefixLogUtil.logWithPrefix((Logger)BAbstractHttpTransport.TRANSPORT_LOG, (Level)Level.FINE, () -> String.format("Received response header [%s]:[%s]", k, v), (Object)this));
        }
        this.updateHealth(response.isGood() ? BStatus.ok : BStatus.fault, response.getFault(), response.getException());
    }

    public void updateHealth(BStatus status, String fault, Exception exception) {
        this.setStatus(status);
        if (exception != null) {
            fault = HttpClientUtils.updateFaultWithException(fault, exception);
        }
        this.setFaultCause(fault);
        this.setLastUpdate(BAbsTime.now());
    }

    public void clearFault() {
        this.setFaultCause("");
        this.setStatus(BStatus.ok);
        this.setLastUpdate(BAbsTime.now());
    }

    public HttpCommResponse getLastCommResponse() {
        return this.lastCommResponse;
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BIHttpCommClient.TYPE);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"monitor.png");
    }
}

