/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.datatypes;

import com.tridium.driver.util.DrUtil;
import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.datatypes.enums.BHttpMode;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.datatypes.options.BIHttpOptionsSupplier;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.httpClient.util.ParentLegal;
import com.tridium.httpClient.ws.BWebsocketClient;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.util.IPrefixLoggable;
import com.tridium.util.PrefixLogUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="mode", type="BHttpMode", defaultValue="BHttpMode.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="hostAddress", type="String", defaultValue="BString.DEFAULT", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")}), @NiagaraProperty(name="port", type="int", defaultValue="Http.DEFAULT_HTTPS_PORT", facets={@Facet(name="BFacets.MIN", value="-1"), @Facet(name="BFacets.MAX", value="65536"), @Facet(name="BFacets.SECURITY", value="BBoolean.TRUE"), @Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)")}), @NiagaraProperty(name="path", type="String", defaultValue="/", facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT)"), @Facet(name="BFacets.SECURITY", value="BBoolean.TRUE")})})
@NiagaraAction(name="populateFromUrl", parameterType="BString", defaultValue="BString.DEFAULT")
public class BHttpAddress
extends BComponent
implements IPrefixLoggable {
    @Generated
    public static final Property mode = BHttpAddress.newProperty((int)0, (BValue)BHttpMode.DEFAULT, (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    @Generated
    public static final Property hostAddress = BHttpAddress.newProperty((int)0, (BValue)BString.DEFAULT, (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    @Generated
    public static final Property port = BHttpAddress.newProperty((int)0, (int)443, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-1), (BFacets)BFacets.make((String)"max", (int)65536)), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)), (BFacets)SfUtil.incl((String)"ed")));
    @Generated
    public static final Property path = BHttpAddress.newProperty((int)0, (String)"/", (BFacets)BFacets.make((BFacets)SfUtil.incl((String)"ed"), (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE)));
    @Generated
    public static final Action populateFromUrl = BHttpAddress.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHttpAddress.class);

    @Generated
    public BHttpMode getMode() {
        return (BHttpMode)this.get(mode);
    }

    @Generated
    public void setMode(BHttpMode v) {
        this.set(mode, (BValue)v, null);
    }

    @Generated
    public String getHostAddress() {
        return this.getString(hostAddress);
    }

    @Generated
    public void setHostAddress(String v) {
        this.setString(hostAddress, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public String getPath() {
        return this.getString(path);
    }

    @Generated
    public void setPath(String v) {
        this.setString(path, v, null);
    }

    @Generated
    public void populateFromUrl(BString parameter) {
        this.invoke(populateFromUrl, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHttpAddress() {
    }

    public BHttpAddress(BHttpMode mode, String address, int port, String path) {
        this.setMode(mode);
        this.setHostAddress(address);
        this.setPort(port);
        this.setPath(path);
    }

    public boolean isParentLegal(BComponent parent) {
        return ParentLegal.is((BComplex)this, (BComplex)parent, BIHttpCommClient.TYPE);
    }

    public void started() {
        BIHttpOptionsSupplier optionsSupplier;
        if (this.isRunning() && !this.isConfigured() && this.getPath().equalsIgnoreCase(path.getDefaultValue().toString()) && (optionsSupplier = (BIHttpOptionsSupplier)DrUtil.getParent((BComplex)this, (Type)BIHttpOptionsSupplier.TYPE)) != null) {
            this.setPath(optionsSupplier.getDefaultPath());
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && context == null && (property.equals(mode) || property.equals(hostAddress) || property.equals(port) || property.equals(path))) {
            HttpClientUtils.auditAddressChange(this, null);
        }
    }

    public void doPopulateFromUrl(BString urlString) {
        HttpClientUtils.populateFromUrl(this, urlString.toString());
    }

    public boolean isConfigured() {
        return !this.getHostAddress().isEmpty() && !this.getPath().isEmpty();
    }

    public URL getUrl(BHttpRequestMethod method, BHttpParameters parameters) throws MalformedURLException {
        String url = this.buildUrl(method, parameters);
        return new URL(url);
    }

    private String buildUrl(BHttpRequestMethod method, BHttpParameters parameters) throws MalformedURLException {
        if (this.getHostAddress().trim().length() < 1) {
            throw new MalformedURLException("Address too short");
        }
        StringBuilder url = new StringBuilder(this.buildUrlBase());
        if (method == BHttpRequestMethod.get && !parameters.asMap().isEmpty()) {
            url.append('?').append(BHttpAddress.buildParameterString(parameters));
        }
        PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.FINE, () -> "Full url: " + url, (Object)((Object)parameters));
        return url.toString();
    }

    public String buildUrlBase() {
        StringBuilder url = new StringBuilder(this.getMode().getModeString(this.isWebSocket())).append("://").append(this.getHostAddress().trim());
        if (this.getPort() > -1) {
            url.append(':').append(this.getPort());
        }
        if (this.getPath().isEmpty() || this.getPath().charAt(0) != '/') {
            url.append('/');
        }
        url.append(this.getPath());
        return url.toString();
    }

    public static String buildParameterString(BHttpParameters parameters) {
        Map<String, String> paramsMap = parameters.asMap();
        return paramsMap.entrySet().stream().map(entry -> {
            StringBuilder paramBuilder = new StringBuilder();
            try {
                return paramBuilder.append(URLEncoder.encode(SlotPath.unescape((String)((String)entry.getKey())), StandardCharsets.UTF_8.name())).append('=').append(URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                PrefixLogUtil.logWithPrefix((Logger)HttpClientUtils.MAIN_LOGGER, (Level)Level.WARNING, (String)"Building URL", (Throwable)e, (Object)((Object)parameters));
                return paramBuilder.toString();
            }
        }).collect(Collectors.joining("&"));
    }

    boolean isWebSocket() {
        return this.isRunning() && this.getParent() instanceof BWebsocketClient;
    }

    public String identifierForLogs() {
        return this.buildUrlBase();
    }

    public String toString(Context context) {
        StringBuilder builder = new StringBuilder(this.getMode().getModeString(false)).append("://").append(this.getHostAddress());
        if (!HttpClientUtils.isDefaultServicePort(this)) {
            builder.append(':').append(this.getPort());
        }
        return builder.append(this.getPath()).toString();
    }

    public BIcon getIcon() {
        return BIcon.std((String)"gears.png");
    }
}

