/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.transport.okHttp;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.transport.BAbstractHttpTransport;
import com.tridium.httpClient.comm.transport.HttpRequestInstance;
import com.tridium.httpClient.datatypes.BHttpAddress;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.auth.BAbstractHttpAuth;
import com.tridium.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridium.httpClient.datatypes.auth.BNoHttpAuth;
import com.tridium.httpClient.datatypes.exception.HttpCommException;
import com.tridium.httpClient.datatypes.options.BHttpHeaders;
import com.tridium.httpClient.datatypes.options.BHttpParameters;
import com.tridium.httpClient.datatypes.payload.BAbstractPayloadSource;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.PrefixLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.httpClient.datatypes.BHttpRequestMethod;
import okhttp3.CacheControl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class OkHttpRequest
extends HttpRequestInstance {
    private BHttpAddress address;
    private final Request.Builder builder = new Request.Builder();
    protected static final Logger log = BAbstractHttpTransport.TRANSPORT_LOG;
    private static final String ERR_HTTP_TRANSPORT_MALFORMED = HttpClientUtils.LEX.get("err.http.transport.malformed");

    OkHttpRequest(BIHttpCommClient client) {
        super(client);
    }

    @Override
    public HttpRequestInstance applyAddress(BHttpAddress address) {
        this.address = address;
        return this;
    }

    @Override
    public HttpRequestInstance applyData(BHttpRequestMethod method, BHttpParameters parameters, BRequestBody requestBody) throws HttpCommException {
        try {
            this.builder.url(this.address.getUrl(method, parameters));
            if (method.equals((Object)BHttpRequestMethod.get)) {
                this.builder.get();
            } else if (method.equals((Object)BHttpRequestMethod.post) || method.equals((Object)BHttpRequestMethod.put) || method.equals((Object)BHttpRequestMethod.delete)) {
                if (requestBody != null) {
                    String contentType = requestBody.getLatestContentType();
                    MediaType mediaType = contentType == null || contentType.isEmpty() ? null : MediaType.get((String)contentType);
                    RequestBody body = OkHttpRequest.streamBody(mediaType, requestBody.getSource(), requestBody.getWriteBufferSize());
                    if (method.equals((Object)BHttpRequestMethod.post)) {
                        this.builder.post(body);
                    } else if (method.equals((Object)BHttpRequestMethod.put)) {
                        this.builder.put(body);
                    } else if (method.equals((Object)BHttpRequestMethod.delete)) {
                        this.builder.delete(body);
                    }
                } else {
                    PrefixLogUtil.logWithPrefix((Logger)log, (Level)Level.WARNING, (String)"No Payload found", (Object)((Object)parameters));
                }
            }
        }
        catch (MalformedURLException malformed) {
            PrefixLogUtil.logWithPrefix((Logger)log, (Level)Level.WARNING, (String)ERR_HTTP_TRANSPORT_MALFORMED, (Throwable)malformed, (Object)((Object)parameters));
            throw new HttpCommException(ERR_HTTP_TRANSPORT_MALFORMED, malformed);
        }
        return this;
    }

    public static RequestBody streamBody(final MediaType contentType, final BAbstractPayloadSource payloadSource, final int bufferSize) {
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return payloadSource.length();
            }

            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source((InputStream)payloadSource.getStream());){
                    long read = 0L;
                    while (read != -1L) {
                        Buffer buffer = new Buffer();
                        read = source.read(buffer, (long)bufferSize);
                        if (read <= -1L) continue;
                        sink.write(buffer, read);
                    }
                }
            }
        };
    }

    @Override
    public HttpRequestInstance applyHeaders(BHttpHeaders headers) {
        headers.asMap().forEach((arg_0, arg_1) -> ((Request.Builder)this.builder).addHeader(arg_0, arg_1));
        return this;
    }

    @Override
    public HttpRequestInstance applyAuthenticator(BAbstractHttpAuth authenticator) throws HttpCommException {
        if (authenticator.getType().is(BAuthorizationHeaderScheme.TYPE)) {
            AccessController.doPrivileged(() -> {
                this.builder.header("Authorization", ((BAuthorizationHeaderScheme)authenticator.as(BAuthorizationHeaderScheme.class)).getAuthHeaderValue(this.getClient()));
                return null;
            });
        } else if (!authenticator.getType().is(BNoHttpAuth.TYPE)) {
            authenticator.apply(this);
        }
        return this;
    }

    @Override
    public HttpRequestInstance applyTuningPolicy(BHttpTuningPolicy policy) {
        this.builder.cacheControl(policy.getUseCaches() ? new CacheControl.Builder().build() : CacheControl.FORCE_NETWORK);
        return this;
    }

    public String identifierForLogs() {
        return this.address.identifierForLogs();
    }

    Request getRequest() {
        return this.builder.build();
    }
}

