/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.httpClient.comm.transport.httpUrlConnection;

import com.tridium.httpClient.comm.client.BIHttpCommClient;
import com.tridium.httpClient.comm.transport.BAbstractHttpTransport;
import com.tridium.httpClient.datatypes.BHttpTuningPolicy;
import com.tridium.httpClient.datatypes.auth.BAuthorizationHeaderScheme;
import com.tridium.httpClient.datatypes.enums.BHttpStreamingMode;
import com.tridium.httpClient.datatypes.payload.BHttpStreamingConfig;
import com.tridium.httpClient.datatypes.payload.BRequestBody;
import com.tridium.httpClient.util.HttpClientUtils;
import com.tridium.util.PrefixLogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpUrlConnectionUtil {
    private static final Logger log = BAbstractHttpTransport.TRANSPORT_LOG;

    private HttpUrlConnectionUtil() {
    }

    static void addPostData(HttpURLConnection conn, BRequestBody requestBody) throws IOException {
        if (HttpUrlConnectionUtil.requiresRequestBody(conn)) {
            PrefixLogUtil.logWithPrefix((Logger)log, (Level)Level.FINE, (String)"HttpUrlConnection attempting to add data", (Object)((Object)requestBody));
            try (OutputStream out = conn.getOutputStream();
                 InputStream source = requestBody.getSource().getStream();){
                int length;
                byte[] buf = new byte[requestBody.getWriteBufferSize()];
                while ((length = source.read(buf)) > -1) {
                    out.write(buf, 0, length);
                }
            }
        }
    }

    static boolean requiresRequestBody(HttpURLConnection conn) {
        return "POST".equalsIgnoreCase(conn.getRequestMethod()) || "PUT".equalsIgnoreCase(conn.getRequestMethod()) || "DELETE".equals(conn.getRequestMethod());
    }

    static void setContentLength(HttpURLConnection conn, BHttpStreamingConfig config, long sourceLength) {
        BHttpStreamingMode streamingMode = config.getStreamingMode();
        if (BHttpStreamingMode.chunked.equals((Object)streamingMode)) {
            int length = config.getChunkLength();
            PrefixLogUtil.logWithPrefix((Logger)log, (Level)Level.FINE, () -> "HttpUrlConnection chunked streaming length: " + length, (Object)((Object)config));
            conn.setChunkedStreamingMode(length);
        } else if (BHttpStreamingMode.fixed.equals((Object)streamingMode)) {
            PrefixLogUtil.logWithPrefix((Logger)log, (Level)Level.FINE, () -> "HttpUrlConnection fixed streaming length: " + sourceLength, (Object)((Object)config));
            conn.setFixedLengthStreamingMode(sourceLength);
        }
    }

    static void applyTuningPolicy(BHttpTuningPolicy tuningPolicy, HttpURLConnection conn) {
        if (tuningPolicy != null) {
            conn.setConnectTimeout((int)tuningPolicy.getConnectTimeout().getMillis());
            conn.setReadTimeout((int)tuningPolicy.getReadTimeout().getMillis());
            conn.setUseCaches(tuningPolicy.getUseCaches());
            conn.setInstanceFollowRedirects(tuningPolicy.getFollowRedirects());
            conn.setAllowUserInteraction(false);
        }
    }

    static void applyAuthHeader(HttpURLConnection conn, BAuthorizationHeaderScheme auth, BIHttpCommClient client) {
        AccessController.doPrivileged(() -> {
            conn.setRequestProperty("Authorization", auth.getAuthHeaderValue(client));
            return null;
        });
    }

    static void printConnDebug(HttpURLConnection conn, BIHttpCommClient client) {
        if (log.isLoggable(Level.FINEST)) {
            try {
                StringBuilder debug = new StringBuilder().append("Configured HTTP Connection:[ ").append('\n').append(conn.getURL()).append('\n').append(conn.getRequestMethod()).append('\n').append(HttpClientUtils.safeHeadersForLogging(conn.getRequestProperties())).append('\n');
                PrefixLogUtil.logWithPrefix((Logger)log, (Level)Level.FINEST, (String)debug.toString(), (Object)client);
            }
            catch (Exception e) {
                PrefixLogUtil.logWithPrefix((Logger)log, (Level)Level.WARNING, (String)"Could not build conn debug string", (Throwable)e, (Object)client);
            }
        }
    }
}

